package com.acecounter.android.acetm.common.util;

import android.text.TextUtils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.AceTM;
import com.acecounter.android.acetm.common.config.ACEPublicStaticConfig;

public final class ACEGenderUtils {
    @NonNull
    public static String validateGender(@NonNull String value) {
        if (value.equalsIgnoreCase(ACEPublicStaticConfig.ACEGender.Man.getName())) {
            return AceTM.Gender.MAN.toString();
        }
        else if (value.equalsIgnoreCase(AceTM.Gender.MAN.toString())) {
            return value;
        }
        else if (value.equalsIgnoreCase(ACEPublicStaticConfig.ACEGender.Woman.getName())) {
            return AceTM.Gender.WOMAN.toString();
        }
        else if (value.equalsIgnoreCase(AceTM.Gender.WOMAN.toString())) {
            return value;
        }
        else {
            return AceTM.Gender.UNKNOWN.toString();
        }
    }

    @NonNull
    public static ACEPublicStaticConfig.ACEGender stringToACEGender(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            return ACEPublicStaticConfig.ACEGender.Unknown;
        }

        if (value.equalsIgnoreCase(ACEPublicStaticConfig.ACEGender.Man.getName()) ||
                value.equalsIgnoreCase(AceTM.Gender.MAN.toString())) {
            return ACEPublicStaticConfig.ACEGender.Man;
        }
        else if (value.equalsIgnoreCase(ACEPublicStaticConfig.ACEGender.Woman.getName()) ||
                value.equalsIgnoreCase(AceTM.Gender.WOMAN.toString())) {
            return ACEPublicStaticConfig.ACEGender.Woman;
        }
        else {
            return ACEPublicStaticConfig.ACEGender.Unknown;
        }
    }
}
