package com.acecounter.android.acetm.common.parameter;

import android.text.TextUtils;

import androidx.annotation.CallSuper;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.ICallbackOfACE;
import com.acecounter.android.acetm.common.config.ACECommonStaticConfig;
import com.acecounter.android.acetm.common.config.ACEStaticConfig;
import com.acecounter.android.acetm.common.config.ACEStaticConfig.ACELOG_JSON_KEY;
import com.acecounter.android.acetm.common.config.ACEStaticConfig.LOG;
import com.acecounter.android.acetm.common.config.ACEStaticConfig.POLICY;
import com.acecounter.android.acetm.common.controltower.ACEControlTower;
import com.acecounter.android.acetm.common.http.ACENetworkResult;
import com.acecounter.android.acetm.common.logger.ACELog;
import com.acecounter.android.acetm.common.util.TimeUtils;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Date;
import java.util.Locale;
import java.util.Map;

public class Task {
    private final String TAG = Task.class.getSimpleName();

    protected boolean _isException;
    protected final int _logSource;
    protected final long _hash;
    protected Date _date;
    @Nullable
    protected ICallbackOfACE _doneWorkCallback;

    protected Task(int logSource) {
        _logSource = logSource;
        _hash = System.nanoTime();
        _date = new Date();
        _doneWorkCallback = null;
    }

    protected Task(int logSource, @Nullable ICallbackOfACE doneWorkCallback) {
        this(logSource);
        _doneWorkCallback = doneWorkCallback;
    }

    final public boolean isException() {
        return _isException;
    }

    @CallSuper
    public void doWork(@Nullable final ICallbackOfTask callbackForTask) {
        IACEParameterUtil _parameterUtil = ACECommonStaticConfig.getParameterUtil();
        if (_parameterUtil != null) {
            _parameterUtil.setLogSource(_logSource);
            _parameterUtil.setFirstLogParameters();
        }
    }

    public void didWork() { }

    @CallSuper
    public void completed(@Nullable final ACENetworkResult response) {
        ACELog.d(TAG, "in completed()");
        if (response == null) {
            return;
        }

        Map<String, String> _responseHeaders = response.getResponseHeaders();
        if (_responseHeaders.containsKey(POLICY.RESPONSE_FORCE_STOP)) {
            String _responseForceStopFlag = _responseHeaders.get(POLICY.RESPONSE_FORCE_STOP);
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, 강제 종료 플래그 확인: %s", this.getTaskHash(), _responseForceStopFlag));
            if (!TextUtils.isEmpty(_responseForceStopFlag) &&
                    _responseForceStopFlag.equals(POLICY.FLAG_SDK_FORCE_STOP)) {
                ACEControlTower.enableForceStop();
            }
        }
        if (_responseHeaders.containsKey(LOG.RESPONSE_COOKIES)) {
            String _setCookie = _responseHeaders.get(LOG.RESPONSE_COOKIES);
            if (!TextUtils.isEmpty(_setCookie)) {
                String[] _cookies = _setCookie.split(";");
                for (String cookie : _cookies) {
                    String[] content = cookie.split("=");
                    if (content.length > 1) {
                        if (LOG.RESPONSE_GSCK.equalsIgnoreCase(content[0])) {
                            ACELog.d(TAG,
                                    String.format(
                                            Locale.getDefault(),
                                            "%d, gsck will update: %s", this.getTaskHash(), content[1]));

                            IACEParameterUtil _parameterUtil = ACECommonStaticConfig.getParameterUtil();
                            if (_parameterUtil != null) {
                                _parameterUtil.setterForString("gsck", content[1]);
                            }
                        }
                    }
                }
            }
        }
    }

    public void failed(@Nullable final Throwable throwable) {
        ACELog.d(TAG, "in failed()");
        if (throwable != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, throwable.getMessage(): %s", this.getTaskHash(), throwable.getMessage()));
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, throwable.getCause(): %s", this.getTaskHash(), throwable.getCause()));
        }
    }

    @CallSuper
    public void exception() {
        _isException = true;
    }

    public String getDescription() {
        IACECommonAPI _commonAPI = ACECommonStaticConfig.getCommonAPI();
        if (_commonAPI != null) {
            return _commonAPI.getDescriptionForAPI(_logSource);
        }
        else {
            return "";
        }
    }

    public long getTaskHash() {
        return _hash;
    }

    protected Date getCreateTime() {
        return _date;
    }

    public String getCreateTimeString() {
        return TimeUtils.dateToACEDateFormatString(this.getCreateTime());
    }

    public JSONObject getJSONobject() throws JSONException {
        JSONObject _json = new JSONObject();

        _json.put(ACELOG_JSON_KEY.LOGTYPE, ACEStaticConfig.ACELOG_TYPE.API_LOG);
        _json.put(ACELOG_JSON_KEY.CREATETIME, getCreateTime().getTime());

        JSONObject _jsonRequestInformation = new JSONObject();
        _jsonRequestInformation.put(ACELOG_JSON_KEY.REQUEST_SERVICE_ID, ACECommonStaticConfig.getKey());
        if (ACEStaticConfig.USER_AGENT != null) {
            _jsonRequestInformation.put(ACELOG_JSON_KEY.REQUEST_USER_AGENT, ACEStaticConfig.USER_AGENT);
        }

        IACEParameterUtil _parameterUtil = ACECommonStaticConfig.getParameterUtil();
        if (_parameterUtil != null) {
            String cookie = _parameterUtil.getCookies();
            if (!TextUtils.isEmpty(cookie)) {
                _jsonRequestInformation.put(ACELOG_JSON_KEY.REQUEST_COOKIE, cookie);
            }
            _json.put(ACELOG_JSON_KEY.PARAMS, _parameterUtil.getParamsToJSONobject());
        }
        _json.put(ACELOG_JSON_KEY.REQUEST, _jsonRequestInformation);

        return _json;
    }

    public void doneWork() { }
}
