package com.acecounter.android.acetm.common.http;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.common.logger.ACEDebugLog;
import com.acecounter.android.acetm.common.logger.ACEException;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ACENetworkResult {
    private static final String TAG = ACENetworkResult.class.getSimpleName();

    private int _responseCode;
    @Nullable
    private String _responseMessage;
    @Nullable
    private String _responseBody;
    @NonNull
    private final Map<String, String> _responseHeaders;

    ACENetworkResult(
            int responseCode,
            @Nullable String responseMessage,
            @Nullable String responseBody,
            @Nullable Map<String, List<String>> responseHeaders) {
        _responseCode = responseCode;
        _responseMessage = responseMessage;
        _responseBody = responseBody;
        _responseHeaders = new HashMap<>();

        try {
            if (responseHeaders == null) {
                return;
            }
            for (String key : responseHeaders.keySet()) {
                List<String> contents = responseHeaders.get(key);
                if (contents != null && contents.size() > 0) {
                    _responseHeaders.put(key, contents.get(0));
                }
            }
        } catch (NullPointerException e) {
            ACEDebugLog.wtf(TAG, new ACEException(e, "응답 헤더 분석에 실패 했습니다.").toString());
        }
    }

    public int getResponseCode() {
        return _responseCode;
    }

    @Nullable
    private String getResponseMessage() {
        return _responseMessage;
    }

    @Nullable
    private String getResponseBody() {
        return _responseBody;
    }

    @NonNull
    public Map<String, String> getResponseHeaders() {
        return _responseHeaders;
    }

    public JSONObject getsVariablesToJSONobject() throws JSONException {
        JSONObject _json = new JSONObject();
        _json.put("responseCode", getResponseCode());
        _json.put("responseMessage", getResponseMessage());
        _json.put("responseBody", getResponseBody());
        _json.put("responseHeaders", getResponseHeaders());
        return _json;
    }

    @Override
    public String toString() {
        try {
            return getsVariablesToJSONobject().toString(2);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return super.toString();
    }
}
