package com.acecounter.android.acetm.common.http;

import android.text.TextUtils;

import androidx.annotation.NonNull;

import com.acecounter.android.acetm.acplus.parameter.ACEParameterUtilForPlus;
import com.acecounter.android.acetm.common.config.ACECommonStaticConfig;
import com.acecounter.android.acetm.common.config.ACEStaticConfig;

import java.util.concurrent.ConcurrentHashMap;

public final class ACENetworkAdapter extends ACENetwork {
    private final String TAG = ACENetworkAdapter.class.getSimpleName();

    public ACENetworkAdapter() {
        super();
    }

    //region override http
    protected int _getConnectTimeout() {
        return 2000;
    }

    protected int _getReadTimeout() {
        return 5000;
    }

    @NonNull
    protected ConcurrentHashMap<String, String> _getRequestHeaderMap() {
        ConcurrentHashMap<String, String> _map = new ConcurrentHashMap<>();
        _map.put(ACEStaticConfig.LOG.REQUEST_CONTENT_TYPE, ACEStaticConfig.LOG.REQUEST_CONTENT_TYPE_APPLICATION_JSON);
        _map.put(ACEStaticConfig.LOG.REQUEST_SERVICE_ID, ACECommonStaticConfig.getKey());
        if (ACEStaticConfig.USER_AGENT != null) {
            _map.put(ACEStaticConfig.LOG.REQUEST_USER_AGENT, ACEStaticConfig.USER_AGENT);
        }
        String cookie = ACEParameterUtilForPlus.getInstance().getGSCKForCookie();
        if (!TextUtils.isEmpty(cookie)) {
            _map.put(ACEStaticConfig.LOG.REQUEST_COOKIE, cookie);
        }
        return _map;
    }
    //endregion override http
}
