package com.acecounter.android.acetm.common.controltower;

import com.acecounter.android.acetm.common.config.ACECommonStaticConfig;
import com.acecounter.android.acetm.common.logger.ACELog;
import com.acecounter.android.acetm.common.policy.ACEPolicyParameterUtil;

import java.util.Locale;

public abstract class ACEControlTower {
    private static final String TAG = ACEControlTower.class.getSimpleName();

    protected Boolean _isCompletePolicy = false;
    protected Boolean _isInstallReferrerDone = false;
    protected Boolean _isSDKForceStop = false;
    protected Boolean _isSDKEnabled = false;

    //region abstract
    protected abstract void setInstallReferrerWaitDone(Boolean isInstallReferrerDone);
    protected abstract void setIsCompletePolicy(Boolean isCompletePolicy, Boolean isSucceedRequestPolicy);
    //endregion abstract

    protected Boolean getInstallReferrerWaitDone() {
        return this._isInstallReferrerDone;
    }

    public Boolean getIsCompletePolicy() {
        return this._isCompletePolicy;
    }

    protected Boolean isDisabled() {
        boolean currentIsCompletePolicy = getIsCompletePolicy();
        boolean currentIsSDKEnabled = getIsSDKEnabled();
        ACELog.d(TAG, "ACEControlTower.getIsCompletePolicy(): " + currentIsCompletePolicy +
                ", ACEControlTower.getIsSDKEnabled(): " + currentIsSDKEnabled);
        if (currentIsCompletePolicy && !currentIsSDKEnabled) {
            ACELog.i(TAG, "SDK is disabled.");
            return true;
        }

        return false;
    }

    protected Boolean getIsSDKEnabled() {
        if (this._isSDKForceStop) {
            ACELog.i(TAG, "SDK was forced to stop.");
            return false;
        }
        this._isSDKEnabled = ACEPolicyParameterUtil.getInstance().isEnableByPolicy();
        ACELog.d(TAG, String.format(Locale.getDefault(), "isEnabled: %s, _isSDKEnabled: %s", this._isSDKEnabled, this._isSDKEnabled));
        if (!this._isSDKEnabled) {
            ACELog.i(TAG, "not found SDK policy information.");
        }
        return this._isSDKEnabled;
    }

    public synchronized Boolean getSDKForceStop() {
        return this._isSDKForceStop;
    }

    protected synchronized void setSDKForceStop(Boolean forceStopSDK) {
        this._isSDKForceStop = forceStopSDK;
    }

    //region static
    public static Boolean isInstallReferrerWaitDone() {
        ACEControlTower controlTower = ACECommonStaticConfig.getControlTower();
        if (controlTower != null) {
            return controlTower.getInstallReferrerWaitDone();
        }

        return false;
    }

    public static synchronized void installReferrerWaitDone() {
        ACEControlTower controlTower = ACECommonStaticConfig.getControlTower();
        if (controlTower != null) {
            controlTower.setInstallReferrerWaitDone(true);
        }
    }

    public static synchronized void enableForceStop() {
        ACEControlTower controlTower = ACECommonStaticConfig.getControlTower();
        if (controlTower != null) {
            controlTower.setSDKForceStop(true);
        }
    }

    public static Boolean isSDKEnabled() {
        ACEControlTower controlTower = ACECommonStaticConfig.getControlTower();
        if (controlTower != null) {
            return controlTower.getIsSDKEnabled();
        }

        return false;
    }

    public static Boolean isCompletePolicy() {
        ACEControlTower controlTower = ACECommonStaticConfig.getControlTower();
        if (controlTower != null) {
            return controlTower.getIsCompletePolicy();
        }

        return false;
    }

    public static synchronized void succeedRequestPolicy() {
        ACEControlTower controlTower = ACECommonStaticConfig.getControlTower();
        if (controlTower != null) {
            controlTower.setIsCompletePolicy(true, true);
        }
    }

    public static synchronized void failedRequestPolicy() {
        ACEControlTower controlTower = ACECommonStaticConfig.getControlTower();
        if (controlTower != null) {
            controlTower.setIsCompletePolicy(true, false);
        }
    }
    //endregion static
}
