package com.acecounter.android.acetm.common.config;

import android.content.Context;

import androidx.annotation.IntDef;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringDef;

import com.acecounter.android.acetm.AceConfiguration;
import com.acecounter.android.acetm.common.controltower.ACEControlTower;
import com.acecounter.android.acetm.common.parameter.IACECommonAPI;
import com.acecounter.android.acetm.common.parameter.IACEParameterUtil;
import com.acecounter.android.acetm.common.parameter.ICallbackOfTask;
import com.acecounter.android.acetm.common.queue.ACEQueueManagerFactory;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashSet;

public abstract class ACEStaticConfig {
    private static final String TAG = ACEStaticConfig.class.getSimpleName();

    public static final String USER_AGENT = System.getProperty("http.agent", "");

    @Nullable
    protected Context _context;
    protected boolean _gather;
    @Nullable
    protected String _key;
    @Nullable
    protected HashSet<String> _ignoreCaseActivityClassNameSet;
    @Nullable
    protected ACEControlTower _controlTower;
    @Nullable
    protected ACEQueueManagerFactory _queueManagerFactory;
    @Nullable
    protected IACEParameterUtil _parameterUtil;
    @Nullable
    protected IACECommonAPI _commonAPI;

    //region abstract
    public abstract void configure(@NonNull AceConfiguration configuration,
                                   @NonNull ICallbackOfTask callback);

    public abstract boolean isGather();
    public abstract Context getContext();
    public abstract boolean getEnablePrivacyPolicy();
    public abstract String getEncryptKey();
    public abstract String getKey();
    public abstract HashSet<String> getIgnoreCaseActivityClassNameSet();
    //endregion abstract

    //region getter manager instances
    public IACECommonAPI getCommonAPI() {
        if (_commonAPI == null) {
            throw new RuntimeException("Stub!");
        }

        return _commonAPI;
    }

    public ACEControlTower getControlTower() {
        if (_controlTower == null) {
            throw new RuntimeException("Stub!");
        }

        return _controlTower;
    }

    public IACEParameterUtil getParameterUtil() {
        if (_parameterUtil == null) {
            throw new RuntimeException("Stub!");
        }

        return _parameterUtil;
    }

    public ACEQueueManagerFactory getQueueManagerFactory() {
        if (_queueManagerFactory == null) {
            throw new RuntimeException("Stub!");
        }

        return _queueManagerFactory;
    }
    //endregion getter manager instances

    //region static
    public static boolean isIgnoreCase(@Nullable Context context) {
        if (context == null) {
            return false;
        }
        else if (!ACECommonStaticConfig.isGather()) {
            return false;
        }

        @Nullable
        HashSet<String> _activityNamesSet = ACECommonStaticConfig.getIgnoreCaseActivityClassNameSet();
        if (_activityNamesSet != null) {
            String className = context.getClass().getSimpleName();
            return _activityNamesSet.contains(className);
        }

        return false;
    }

    @Nullable
    public static String getDescriptionAtACEofAPI(@ACEofAPI int identifier) {
        switch (identifier) {
            case ACEofAPI.Unknown:
                return "Unknown";
            case ACEofAPI.DeepLinkAtStartApp:
                return "DeepLinkAtStartApp";
            case ACEofAPI.DeepLinkAtRunningApp:
                return "DeepLinkAtRunningApp";
            case ACEofAPI.FailedLogSend:
                return "FailedLogSend";
            case ACEofAPI.InstallReferrer:
                return "InstallReferrer";
            case ACEofAPI.onPageFinished:
                return "onPageFinished";
            case ACEofAPI.ScriptRequestTask:
                return "ScriptRequestTask";
            case ACEofAPI.PluginGetPVParameters:
                return "PluginGetPVParameters";
            case ACEofAPI.POLICY:
                return "POLICY";
            case ACEofAPI.PushAtStartApp:
                return "PushAtStartApp";
            case ACEofAPI.PushAtRunningApp:
                return "PushAtRunningApp";
            case ACEofAPI.PvWithParameters:
                return "PvWithParameters";
            case ACEofAPI.SendByHybridAPI:
                return "SendByHybridAPI";
        }

        return null;
    }
    //endregion static

    //region enum

    //region 상수
    @Retention(RetentionPolicy.SOURCE)
    @StringDef(value = {
            IN_STORAGE.APPLIST_LAST_SENDTIME,
            IN_STORAGE.InstallReferrer})
    public @interface IN_STORAGE {
        String APPLIST_LAST_SENDTIME = "_AceTM.Last.Send";
        String InstallReferrer = "_ACE.Received.InstallReferrer";
    }

    /**
     * 곳곳에서 사용하는 string 상수
     */
    @Retention(RetentionPolicy.SOURCE)
    @StringDef({
            ACECONSTANT.ACP_PUSH,
            ACECONSTANT.ANDROID,
            ACECONSTANT.BOOKMARK,
            ACECONSTANT.DEFAULT_ADID,
            ACECONSTANT.DIRECT,
            ACECONSTANT.DOMAIN_DUMMY,
            ACECONSTANT.DOMAIN_LNC,
            ACECONSTANT.EMPTY,
            ACECONSTANT.EXTERNAL_STORAGE_PATH,
            ACECONSTANT.FAILED_SAVE_FILE_NAME,
            ACECONSTANT.INSTALL_REFERRER_BROADCAST_NAME,
            ACECONSTANT.INTENT_REFERRER_NAME,
            ACECONSTANT.LNC_LOG_VERSION,
            ACECONSTANT.PATCH,
            ACECONSTANT.TASK_CREATE_TIME_FORMAT,
            ACECONSTANT.OFFICIAL_LOG_TAG})
    public @interface ACECONSTANT {
        String ACP_PUSH = "acp_push";
        String ANDROID = "android";
        String BOOKMARK = "bookmark";
        String DEFAULT_ADID = "00000000-0000-0000-0000-000000000000";
        String DIRECT = "Direct";
        String DOMAIN_DUMMY = "www.acecounter.com";
        String DOMAIN_LNC = "api-logncrash.cloud.toast.com/v2/log";
        String EMPTY = "";
        String EXTERNAL_STORAGE_PATH = "/nhn/ace/temp/backup/";
        String FAILED_SAVE_FILE_NAME = "aceFailedLog.json";
        String INSTALL_REFERRER_BROADCAST_NAME = "com.android.vending.INSTALL_REFERRER";
        String INTENT_REFERRER_NAME = "referrer";
        String LNC_LOG_VERSION = "v2";
        String PATCH = "rev01";
        String TASK_CREATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
        String OFFICIAL_LOG_TAG = "[ACE]";
    }

    /**
     * 곳곳에서 사용하는 int 상수
     */
    @Retention(RetentionPolicy.SOURCE)
    @IntDef({ACECONSTANT_INTEGER.ACEPRODUCT_QUERY_MAX_LENGTH,
            ACECONSTANT_INTEGER.ENCRYPT_VALUE_AGE,
            ACECONSTANT_INTEGER.HalfOfHourMilliseconds,
            ACECONSTANT_INTEGER.INIT_FAILED_LOG_COUNT,
            ACECONSTANT_INTEGER.MAX_LENGTH_REDUCE_TEXT_COUNT,
            ACECONSTANT_INTEGER.OneDayMilliseconds,
            ACECONSTANT_INTEGER.QUEUE_MAX_FAILED_LOG_COUNT,
            ACECONSTANT_INTEGER.QUEUE_MAX_WAITING_COUNT,
            ACECONSTANT_INTEGER.TWO_MINUTES})
    public @interface ACECONSTANT_INTEGER {
        int ACEPRODUCT_QUERY_MAX_LENGTH = 512;
        int ENCRYPT_VALUE_AGE = 4;
        int HalfOfHourMilliseconds = 30 * 60 * 1000;
        int INIT_FAILED_LOG_COUNT = 1;
        int MAX_LENGTH_REDUCE_TEXT_COUNT = 128;
        int OneDayMilliseconds = 24 * 60 * 60 * 1000;
        int QUEUE_MAX_FAILED_LOG_COUNT = 99;
        int QUEUE_MAX_WAITING_COUNT = 100;
        int TWO_MINUTES = 120;
    }

    /**
     * 내부 API 상수
     */
    @Retention(RetentionPolicy.SOURCE)
    @IntDef({
            ACEofAPI.Unknown,
            ACEofAPI.DeepLinkAtStartApp,
            ACEofAPI.DeepLinkAtRunningApp,
            ACEofAPI.FailedLogSend,
            ACEofAPI.onPageFinished,
            ACEofAPI.ScriptRequestTask,
            ACEofAPI.PluginGetPVParameters,
            ACEofAPI.POLICY,
            ACEofAPI.PushAtStartApp,
            ACEofAPI.PushAtRunningApp,
            ACEofAPI.InstallReferrer,
            ACEofAPI.PvWithParameters,
            ACEofAPI.SendByHybridAPI})
    public @interface ACEofAPI {
        int Unknown = 0;
        int DeepLinkAtStartApp = 3000;
        int DeepLinkAtRunningApp = 3001;
        int FailedLogSend = 1500;
        int onPageFinished = 1400;
        int ScriptRequestTask = 1600;
        int PluginGetPVParameters = 7000;
        int POLICY = 1000;
        int PushAtStartApp = 3200;
        int PushAtRunningApp = 3210;
        int InstallReferrer = 3300;
        int PvWithParameters = 1030;
        int SendByHybridAPI = 4000;
    }

    /**
     * 1.x 에서 사용하던 key 상수
     */
    @Retention(RetentionPolicy.SOURCE)
    @StringDef(value = {
            LEGACY_KEY.ACECOUNTER_SID,
            LEGACY_KEY.ACECOUNTER_ENCRYPT_KEY})
    @interface LEGACY_KEY {
        String ACECOUNTER_SID = "ACECOUNTER_SID";
        String ACECOUNTER_ENCRYPT_KEY = "ACECOUNTER_ENCRYPT_KEY";
    }

    /**
     * 스토어 코드 상수
     */
    @Retention(RetentionPolicy.SOURCE)
    @StringDef({STORE_CODE.Android_Market})
    public @interface STORE_CODE {
        String Android_Market = "20";
    }

    @Retention(RetentionPolicy.SOURCE)
    @StringDef(value = {
            IACEParameterUtilKey.CPY,
            IACEParameterUtilKey.UniqueKeyForSDK})
    public @interface IACEParameterUtilKey {
        String CPY = "CPY";
        String UniqueKeyForSDK = "UniqueKeyForSDK";
    }
    //endregion 상수

    //region 정책
    /**
     * 정책에 사용되는 상수
     */
    @Retention(RetentionPolicy.SOURCE)
    @StringDef(value = {
            POLICY.REQUEST_URL,

            POLICY.REQUEST_APPLICATION_ID,
            POLICY.REQUEST_CID,
            POLICY.REQUEST_PLATFORM,
            POLICY.REQUEST_SERVICE_ID,
            POLICY.REQUEST_TIME,
            POLICY.REQUEST_VERSION,

            POLICY.RESPONSE_APPLIST_ENABLE,
            POLICY.RESPONSE_CID,
            POLICY.RESPONSE_DEBUG,
            POLICY.RESPONSE_DEBUG_LOG_URL,
            POLICY.RESPONSE_DOMAIN,
            POLICY.RESPONSE_FORCE_DELETE_FAILEDFILE,
            POLICY.RESPONSE_FORCE_STOP,
            POLICY.RESPONSE_POLICY_INTERVAL,
            POLICY.RESPONSE_PRIVATE,
            POLICY.RESPONSE_SDK_ENABLE,
            POLICY.RESPONSE_SOURCE_IP,
            POLICY.RESPONSE_TIME_INTERVAL,
            POLICY.RESPONSE_TOAST_APPKEY,

            POLICY.FLAG_ACELOG_GATHERING,
            POLICY.FLAG_FORCE_DELETE_FAILEDFILE,
            POLICY.FLAG_SDK_ENABLE,
            POLICY.FLAG_SDK_FORCE_STOP})
    public @interface POLICY {
        String REQUEST_URL = "https://policy.acecounter.com/policy";

        String REQUEST_APPLICATION_ID = "CP-Application-Id";
        String REQUEST_CID = "CP-Request-Cid";
        String REQUEST_PLATFORM = "CP-Request-Platform";
        String REQUEST_SERVICE_ID = "CP-Request-Id";
        String REQUEST_TIME = "CP-Request-Time";
        String REQUEST_VERSION = "CP-Request-Version";

        String RESPONSE_APPLIST_ENABLE = "Cp-App";
        String RESPONSE_CID = "Cp-Cid";
        String RESPONSE_DEBUG = "Cp-Debug";
        String RESPONSE_DEBUG_LOG_URL = "Cp-Crash-Domain";
        String RESPONSE_DOMAIN = "Cp-Domain";
        String RESPONSE_FORCE_DELETE_FAILEDFILE = "Cp-Force-Delete-FailedLogs";
        String RESPONSE_FORCE_STOP = "Cp-Force-Stop";
        String RESPONSE_POLICY_INTERVAL = "Cp-Repeat-Interval";
        String RESPONSE_PRIVATE = "Cp-Private";
        String RESPONSE_SDK_ENABLE = "Cp-Allow";
        String RESPONSE_SOURCE_IP = "Cp-Source-Ip";
        String RESPONSE_TIME_INTERVAL = "Cp-Time-Interval";
        String RESPONSE_TOAST_APPKEY = "Cp-LNC-Id";

        String FLAG_ACELOG_GATHERING = "1"; // cpDebug
        String FLAG_FORCE_DELETE_FAILEDFILE = "1";
        String FLAG_SDK_ENABLE = "*";
        String FLAG_SDK_FORCE_STOP = "1";
    }
    //endregion 정책

    //region HTTP
    /**
     * http 전송 방법 상수
     */
    @Retention(RetentionPolicy.SOURCE)
    @StringDef(value = {
            HTTP_METHOD.GET,
            HTTP_METHOD.POST})
    public @interface HTTP_METHOD {
        String GET = "GET";
        String POST = "POST";
    }

    @Retention(RetentionPolicy.SOURCE)
    @StringDef({
            PROTOCOL_TYPE.HTTP,
            PROTOCOL_TYPE.HTTPS})
    public @interface PROTOCOL_TYPE {
        String HTTP = "http";
        String HTTPS = "https";
    }
    //endregion HTTP

    //region JSON
    /**
     * Cookie 에 json key 상수
     */
    @Retention(RetentionPolicy.SOURCE)
    @StringDef(value = {
            COOKIE.JSON_KEY_GSCK})
    public @interface COOKIE {
        String JSON_KEY_GSCK = "GsCK_UAC";
    }

    /**
     * Task to JSON 할때 JSON key
     */
    @Retention(RetentionPolicy.SOURCE)
    @StringDef({
            ACELOG_JSON_KEY.CAUSE,
            ACELOG_JSON_KEY.CREATETIME,

            ACELOG_JSON_KEY.FAILED_COUNT,

            ACELOG_JSON_KEY.LOGTYPE,

            ACELOG_JSON_KEY.METHOD,

            ACELOG_JSON_KEY.PARAMS,

            ACELOG_JSON_KEY.REQUEST,
            ACELOG_JSON_KEY.REQUEST_COOKIE,
            ACELOG_JSON_KEY.REQUEST_GSCK,
            ACELOG_JSON_KEY.REQUEST_SERVICE_ID,
            ACELOG_JSON_KEY.REQUEST_USER_AGENT,

            ACELOG_JSON_KEY.STACKTRACE,

            ACELOG_JSON_KEY.TaskHash,
            ACELOG_JSON_KEY.THROWABLE,

            ACELOG_JSON_KEY.URL})
    public @interface ACELOG_JSON_KEY {
        String CAUSE = "cause";
        String CREATETIME = "createTime";

        String FAILED_COUNT = "failedCount";

        String LOGTYPE = "logType";

        String METHOD = "method";

        String PARAMS = "params";

        String REQUEST = "request";
        String REQUEST_COOKIE = "cookie";
        String REQUEST_GSCK = "GsCK_UAC";
        String REQUEST_SERVICE_ID = "X-AceAPI-Key";
        String REQUEST_USER_AGENT = "User-Agent";

        String STACKTRACE = "stackTrace";

        String TaskHash = "taskHash";
        String THROWABLE = "throwable";

        String URL = "url";
    }

    /**
     * ICallbackDoneAndFail 의 JSONObject 파라미터의 json key 상수
     */
    @Retention(RetentionPolicy.SOURCE)
    @StringDef(value = {
            ICallbackDoneAndFail_Result_JSON_KEY.ADID,
            ICallbackDoneAndFail_Result_JSON_KEY.FAIL_MESSAGE,
            ICallbackDoneAndFail_Result_JSON_KEY.IsAdTrackingEnabled})
    public @interface ICallbackDoneAndFail_Result_JSON_KEY {
        String ADID = "adid";
        String FAIL_MESSAGE = "failMessage";
        String IsAdTrackingEnabled = "isAdTrackingEnabled";
    }
    //endregion JSON

    //region Log
    /**
     * ACEDebugLog JSON body key
     */
    @Retention(RetentionPolicy.SOURCE)
    @StringDef({
            ACEDebugLog_JSON_KEY.APP_NAME,
            ACEDebugLog_JSON_KEY.APP_VERSION,
            ACEDebugLog_JSON_KEY.BODY,
            ACEDebugLog_JSON_KEY.STACKTRACE,
            ACEDebugLog_JSON_KEY.DOMAIN,
            ACEDebugLog_JSON_KEY.HOST,
            ACEDebugLog_JSON_KEY.LOG_SOURCE,
            ACEDebugLog_JSON_KEY.LOG_TYPE,
            ACEDebugLog_JSON_KEY.LOG_VERSION,
            ACEDebugLog_JSON_KEY.PLATFORM,
            ACEDebugLog_JSON_KEY.PROJECT_NAME,
            ACEDebugLog_JSON_KEY.PROJECT_VERSION})
    public @interface ACEDebugLog_JSON_KEY {
        String APP_NAME = "txtAppName";
        String APP_VERSION = "txtAppVersion";
        String BODY = "body";
        String STACKTRACE = "txtStacktrace";
        String DOMAIN = "txtDomain";
        String HOST = "host";
        String LOG_SOURCE = "logSource";
        String LOG_TYPE = "logType";
        String LOG_VERSION = "logVersion";
        String PLATFORM = "txtPlatform";
        String PROJECT_NAME = "projectName";
        String PROJECT_VERSION = "projectVersion";
    }

    /**
     * ACEDebugLog LogType
     */
    @Retention(RetentionPolicy.SOURCE)
    @StringDef({
            ACEDebugLog_Type.VERBOSE,
            ACEDebugLog_Type.DEBUG,
            ACEDebugLog_Type.INFO,
            ACEDebugLog_Type.WARN,
            ACEDebugLog_Type.ERROR,
            ACEDebugLog_Type.ASSERT})
    public @interface ACEDebugLog_Type {
        String VERBOSE = "VERBOSE";
        String DEBUG = "DEBUG";
        String INFO = "INFO";
        String WARN = "WARN";
        String ERROR = "ERROR";
        String ASSERT = "ASSERT";
    }

    /**
     * ACELOG_TYPE Task 들을 구분하기 위한 로그 타입
     */
    @Retention(RetentionPolicy.SOURCE)
    @StringDef({
            ACELOG_TYPE.POLICY,
            ACELOG_TYPE.API_LOG})
    public @interface ACELOG_TYPE {
        String POLICY = "policy";
        String API_LOG = "log";
    }

    /**
     * Log 전송에 사용되는 http request/response header key name 상
     */
    @Retention(RetentionPolicy.SOURCE)
    @StringDef(value = {
            LOG.REQUEST_CONTENT_TYPE,
            LOG.REQUEST_CONTENT_TYPE_APPLICATION_JSON,
            LOG.REQUEST_COOKIE,
            LOG.REQUEST_GSCK,
            LOG.REQUEST_SERVICE_ID,
            LOG.REQUEST_USER_AGENT,

            LOG.RESPONSE_COOKIES,
            LOG.RESPONSE_GSCK})
    public @interface LOG {
        String REQUEST_CONTENT_TYPE = "Content-Type";
        String REQUEST_CONTENT_TYPE_APPLICATION_JSON = "application/json";
        String REQUEST_COOKIE = "cookie";
        String REQUEST_GSCK = "GsCK_UAC";
        String REQUEST_SERVICE_ID = "X-AceAPI-Key";
        String REQUEST_USER_AGENT = "User-Agent";

        String RESPONSE_COOKIES = "Set-Cookie";
        String RESPONSE_GSCK = "GsCK_UAC";
    }
    //endregion Log

    //region Session
    /**
     * 세션 상수
     */
    @Retention(RetentionPolicy.SOURCE)
    @IntDef({
            SESSION.KEEP,
            SESSION.NEW})
    public @interface SESSION {
        int KEEP = 0;
        int NEW = 1;
    }
    //endregion Session

    //endregion enum
}
