package com.acecounter.android.acetm.common.config;

import android.app.Application;
import android.content.Context;

import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.AceConfiguration;
import com.acecounter.android.acetm.BuildConfig;
import com.acecounter.android.acetm.ICallbackOfACE;
import com.acecounter.android.acetm.acone.config.ACEOneStaticConfig;
import com.acecounter.android.acetm.acplus.config.ACEPlusStaticConfig;
import com.acecounter.android.acetm.common.controltower.ACEControlTower;
import com.acecounter.android.acetm.common.internal.AceActivityLifecycleCallbacks;
import com.acecounter.android.acetm.common.logger.ACELog;
import com.acecounter.android.acetm.common.parameter.IACECommonAPI;
import com.acecounter.android.acetm.common.parameter.IACEParameterUtil;
import com.acecounter.android.acetm.common.parameter.ICallbackOfTask;
import com.acecounter.android.acetm.common.policy.ACEPolicy;
import com.acecounter.android.acetm.common.queue.ACEQueueManagerFactory;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashSet;

import static com.acecounter.android.acetm.common.config.ACEPublicStaticConfig.ACEConstantCallbackKey_Failed_Cause;
import static com.acecounter.android.acetm.common.config.ACEPublicStaticConfig.ACEConstantCallbackKey_Result;

public final class ACECommonStaticConfig {
    private static final String TAG = ACECommonStaticConfig.class.getSimpleName();

    private static ACEStaticConfig _staticConfigImpl;
    private static @ACEPublicStaticConfig.ACEPlatform int _platform;

    /**
     * 'UTF-8' charset name
     */
    public static final String CHARSET_UTF8 = "UTF-8";

    @MainThread
    public static synchronized void configure(@NonNull final AceConfiguration configuration,
                                              @Nullable final ICallbackOfACE doneWorkCallback) {
        if (_staticConfigImpl == null) {
            if (!configuration.getDebug()) {
                ACELog.setLogLevel(ACELog.ERROR);
            }
            else {
                ACELog.setLogLevel(ACELog.INFO);
//                ACELog.setLogLevel(ACELog.VERBOSE);
            }

            // ActivityLifecycleCallbacks 설정 [S]
            final Application application = configuration.getApplication();
            final AceActivityLifecycleCallbacks aceActivityLifecycleCallbacks =
                    new AceActivityLifecycleCallbacks(configuration.getGather());
            application.registerActivityLifecycleCallbacks(aceActivityLifecycleCallbacks);
            // ActivityLifecycleCallbacks 설정 [E]

            ACELog.i(TAG, "NHN ACE SDK version: " + BuildConfig.VERSION_NAME);
            ACELog.i(TAG, "AceConfiguration information: " + configuration.toString());

            ACECommonStaticConfig.setPlatform(configuration.getPlatform());
            if (ACECommonStaticConfig.getPlatform() == ACEPublicStaticConfig.ACEPlatform.ACPlus) {
                _staticConfigImpl = new ACEPlusStaticConfig();
            }
            else {
                _staticConfigImpl = new ACEOneStaticConfig();
            }
            _staticConfigImpl.configure(configuration, new ICallbackOfTask() {
                @Override
                public void callback() {
                    // ACEPolicy [S]
                    ACEPolicy.requestPolicy(configuration.getApplication(), 0);
                    // ACEPolicy [E]

                    if (doneWorkCallback != null) {
                        ACELog.d(TAG, "Start doneWorkCallback: " + ACECommonStaticConfig.class.getSimpleName());
                        try {
                            JSONObject result = new JSONObject();
                            result.put(ACEStaticConfig.ACELOG_JSON_KEY.TaskHash, String.valueOf(System.nanoTime()));
                            result.put(ACEConstantCallbackKey_Result, "done");

                            doneWorkCallback.completed(result);
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
        else {
            ACELog.i(TAG, "Already set to '" + ACECommonStaticConfig.getKey() + "'.");

            if (doneWorkCallback != null) {
                ACELog.d(TAG, "Start doneWorkCallback: " + ACECommonStaticConfig.class.getSimpleName());
                try {
                    JSONObject result = new JSONObject();
                    result.put(ACEStaticConfig.ACELOG_JSON_KEY.TaskHash, String.valueOf(System.nanoTime()));
                    result.put(ACEConstantCallbackKey_Result, "failed");
                    result.put(ACEConstantCallbackKey_Failed_Cause, "Already set to '" + ACECommonStaticConfig.getKey() + "'.");

                    doneWorkCallback.failed(result);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    //region static
    @Nullable
    public static Context getContext() {
        if (_staticConfigImpl != null) {
            return _staticConfigImpl.getContext();
        }

        return null;
    }

    public static boolean getEnablePrivacyPolicy() {
        if (_staticConfigImpl != null) {
            return _staticConfigImpl.getEnablePrivacyPolicy();
        }

        return false;
    }

    @Nullable
    public static String getEncryptKey() {
        if (_staticConfigImpl != null) {
            return _staticConfigImpl.getEncryptKey();
        }

        return null;
    }

    @Nullable
    public static HashSet<String> getIgnoreCaseActivityClassNameSet() {
        if (_staticConfigImpl != null) {
            return _staticConfigImpl.getIgnoreCaseActivityClassNameSet();
        }

        return null;
    }

    private static @ACEPublicStaticConfig.ACEPlatform int getPlatform() {
        return _platform;
    }

    private static void setPlatform(@ACEPublicStaticConfig.ACEPlatform int platform) {
        _platform = platform;
    }

    @NonNull
    public static String getKey() {
        if (_staticConfigImpl != null) {
            return _staticConfigImpl.getKey();
        }

        return "";
    }

    public static boolean isGather() {
        if (_staticConfigImpl != null) {
            return _staticConfigImpl.isGather();
        }

        return false;
    }
    //endregion static

    //region getter manager instances
    @Nullable
    public static IACECommonAPI getCommonAPI() {
        if (_staticConfigImpl != null) {
            return _staticConfigImpl.getCommonAPI();
        }

        return null;
    }

    @Nullable
    public static ACEControlTower getControlTower() {
        if (_staticConfigImpl != null) {
            return _staticConfigImpl.getControlTower();
        }

        return null;
    }

    @Nullable
    public static IACEParameterUtil getParameterUtil() {
        if (_staticConfigImpl != null) {
            return _staticConfigImpl.getParameterUtil();
        }

        return null;
    }

    @Nullable
    public static ACEQueueManagerFactory getQueueManagerFactory() {
        if (_staticConfigImpl != null) {
            return _staticConfigImpl.getQueueManagerFactory();
        }

        return null;
    }
    //endregion getter manager instances
}
