package com.acecounter.android.acetm.acplus.parameter;

import android.content.Context;
import android.text.TextUtils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.ICallbackOfACE;
import com.acecounter.android.acetm.acplus.config.ACEPlusStaticConfig.ACEReducerForPlusAPIParamKey;
import com.acecounter.android.acetm.acplus.config.ACEPlusStaticConfig.ParamsPlusEnum_Key;
import com.acecounter.android.acetm.common.config.ACECommonStaticConfig;
import com.acecounter.android.acetm.common.config.ACEStaticConfig;
import com.acecounter.android.acetm.common.config.ACEStaticConfig.ACELOG_JSON_KEY;
import com.acecounter.android.acetm.common.file.ACEFileUtil;
import com.acecounter.android.acetm.common.http.ACENetwork;
import com.acecounter.android.acetm.common.http.ACENetworkAdapter;
import com.acecounter.android.acetm.common.http.ACENetworkResult;
import com.acecounter.android.acetm.common.http.IACENetworkParams;
import com.acecounter.android.acetm.common.logger.ACEDebugLog;
import com.acecounter.android.acetm.common.logger.ACEException;
import com.acecounter.android.acetm.common.logger.ACELog;
import com.acecounter.android.acetm.common.parameter.ACEParameterUtil;
import com.acecounter.android.acetm.common.parameter.ICallbackOfTask;
import com.acecounter.android.acetm.common.parameter.Task;
import com.acecounter.android.acetm.common.util.URLUtils;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import static com.acecounter.android.acetm.common.config.ACEPublicStaticConfig.ACEConstantCallbackKey_Failed_Cause;

final public class APIForPvWithParameters extends Task {
    private static final String TAG = APIForPvWithParameters.class.getSimpleName();

    @Nullable
    private Context _context;
    @Nullable
    private ConcurrentHashMap<String, Object> _parameters;
    @Nullable
    private Map<String, String> _map;

    APIForPvWithParameters(final int logSource,
                           @Nullable Map<String, Object> parameters,
                           @Nullable ICallbackOfACE doneWorkCallback) {
        super(logSource, doneWorkCallback);
        if (parameters != null) {
            _parameters = new ConcurrentHashMap<>();
            _parameters.putAll(parameters);
        }
    }

    @Override
    public void doWork(@Nullable final ICallbackOfTask callbackForTask) {
        super.doWork(callbackForTask);

        String _params = null;
        if (_parameters != null) {
            if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.CONTEXT)) {
                _context = (Context) _parameters.get(ACEReducerForPlusAPIParamKey.CONTEXT);
            }
            if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.PARAMETERS)) {
                _params = (String) _parameters.get(ACEReducerForPlusAPIParamKey.PARAMETERS);
            }
        }

        if (!TextUtils.isEmpty(_params)) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, doWork _params: %s", this.getTaskHash(), _params));
            _map = ACEParameterUtil.getURLToMapOnlyLetteringAtStartIndex(_params);
        }

        if (_map != null) {
            ACEParameterUtilForPlus _parameterUtilForPlus = ACEParameterUtilForPlus.getInstance();
            ACEParametersForPlus _parametersForPlus = ACEParametersForPlus.getInstance();

            _map.put(
                    ParamsPlusEnum_Key.LOGSOURCE,
                    String.format(Locale.getDefault(), "%d", _logSource));

            // push [S]
            if (!TextUtils.isEmpty(_parametersForPlus.getACP_PUSH())) {
                _parameterUtilForPlus.setPushParameters();
                _map.put(ParamsPlusEnum_Key.RDM, _parametersForPlus.getRDM());
                _map.put(ParamsPlusEnum_Key.AVN, String.valueOf(_parameterUtilForPlus.getSession()));
                _map.put(ParamsPlusEnum_Key.EREF, _parametersForPlus.getEREF());
            }
            // deeplink, install_referrer (1) [S]
            if (!TextUtils.isEmpty(_parametersForPlus.getPRMT())) {
                _map.put(ParamsPlusEnum_Key.PRMT, _parametersForPlus.getPRMT());
            }
            // deeplink, install_referrer (1) [E]
            // push [E]

            // deeplink, install_referrer (2) [S]
            if (!TextUtils.isEmpty(_parametersForPlus.getAS())) {
                _map.put(ParamsPlusEnum_Key.AS, _parametersForPlus.getAS());
            }
            if (!TextUtils.isEmpty(_parametersForPlus.getMS())) {
                _map.put(ParamsPlusEnum_Key.MS, _parametersForPlus.getMS());
            }
            if (!TextUtils.isEmpty(_parametersForPlus.getTK())) {
                _map.put(ParamsPlusEnum_Key.TK, _parametersForPlus.getTK());
            }
            // deeplink, install_referrer (2) [E]

            // sync [S]
            // AET [S]
            if (_map.containsKey(ParamsPlusEnum_Key.AET)) {
                String _aetString = _map.get(ParamsPlusEnum_Key.AET);
                if (!TextUtils.isEmpty(_aetString)) {
                    long _aet = _parameterUtilForPlus.getAET();
                    try {
                        _aet = Long.parseLong(_aetString);
                        if (_aet < 1) {
                            _aet = _parameterUtilForPlus.getAET();
                        }
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                    _parameterUtilForPlus.setAET(_aet);
                }
            }
            // AET [E]

            // AGE [S]
            if (_map.containsKey(ParamsPlusEnum_Key.AGE)) {
                String _ageString = _map.get(ParamsPlusEnum_Key.AGE);
                if (!TextUtils.isEmpty(_ageString)) {
                    int _age = _parameterUtilForPlus.getAGEForPure();
                    try {
                        _age = Integer.parseInt(_ageString);
                        if (_age < 1) {
                            _age = _parameterUtilForPlus.getAGEForPure();
                        }
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                    _parameterUtilForPlus.setAGEForPure(_age);
                }
            }
            // AGE [E]

            // MT [S]
            if (_map.containsKey(ParamsPlusEnum_Key.MT)) {
                String _mtString = _map.get(ParamsPlusEnum_Key.MT);
                if (!TextUtils.isEmpty(_mtString)) {
                    int _mt = _parameterUtilForPlus.getMT();
                    try {
                        _mt = Integer.parseInt(_mtString);
                        if (_mt < 1) {
                            _mt = _parameterUtilForPlus.getMT();
                        }
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                    _parameterUtilForPlus.setMT(_mt);
                }
            }
            // MT [E]

            // UID [S]
            if (_map.containsKey(ParamsPlusEnum_Key.UID)) {
                String _uidString = _map.get(ParamsPlusEnum_Key.UID);
                if (!TextUtils.isEmpty(_uidString)) {
                    _parameterUtilForPlus.setUID(_uidString);
                }
            }
            // UID [E]

            // URL [S]
            if (_map.containsKey(ParamsPlusEnum_Key.URL)) {
                String _urlString = _map.get(ParamsPlusEnum_Key.URL);
                if (!TextUtils.isEmpty(_urlString)) {
                    _parameterUtilForPlus.setURL(_urlString);
                }
            }
            // URL [E]
            // sync [E]

            try {
                ACELog.d(TAG,
                        String.format(
                                Locale.getDefault(),
                                "%d, doWork result _map: %s", this.getTaskHash(), new JSONObject(_map).toString(2)));
            } catch (JSONException e) {
                ACEDebugLog.wtf(TAG, new ACEException(e, "doWork ACELog 과정에 예외 발생").toString());
            }
        }

        if (callbackForTask != null) {
            callbackForTask.callback();
        }
    }

    @Override
    public void didWork() {
        ACENetworkAdapter networkAdapter = new ACENetworkAdapter();
        networkAdapter.setGetURL(new ACENetwork.OnGetURL() {
            @NonNull
            @Override
            public String getURL() {
                return URLUtils.convertMapToGetURL(ACEStaticConfig.HTTP_METHOD.GET, _map);
            }
        });
        networkAdapter.setGetRequestHeaderMap(new ACENetwork.OnGetRequestHeaderMap() {
            @NonNull
            @Override
            public ConcurrentHashMap<String, String> getRequestHeaderMap() {
                ConcurrentHashMap<String, String> _map = new ConcurrentHashMap<>();
                _map.put(ACEStaticConfig.LOG.REQUEST_SERVICE_ID, ACECommonStaticConfig.getKey());
                if (ACEStaticConfig.USER_AGENT != null) {
                    _map.put(ACEStaticConfig.LOG.REQUEST_USER_AGENT, ACEStaticConfig.USER_AGENT);
                }
                // deeplink, install_referrer [S]
                String cookie = ACEParameterUtilForPlus.getInstance().getGSCKForCookie();
                if (!TextUtils.isEmpty(cookie)) {
                    _map.put(ACEStaticConfig.LOG.REQUEST_COOKIE, cookie);
                }
                // deeplink, install_referrer [E]
                return _map;
            }
        });
        networkAdapter.request(new IACENetworkParams() {
            @Override
            public void completed(@Nullable final ACENetworkResult response) {
                APIForPvWithParameters.this.completed(response);
            }

            @Override
            public void failed(@Nullable final Throwable throwable) {
                APIForPvWithParameters.this.failed(throwable);
            }
        });
    }

    @Override
    public void completed(@Nullable final ACENetworkResult response) {
        super.completed(response);
        if (response != null) {
            ACELog.d(TAG, response.toString());
        }

        doneWork();
        ACELog.d(TAG,
                String.format(
                        Locale.getDefault(),
                        "%d, completed done", this.getTaskHash()));
        if (this._doneWorkCallback != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, Start doneWorkCallback: %s", this.getTaskHash(), this.getClass().getSimpleName()));

            try {
                JSONObject result = new JSONObject();
                result.put(ACEStaticConfig.ACELOG_JSON_KEY.TaskHash, String.valueOf(getTaskHash()));
                if (response != null) {
                    result.put("response", response.getsVariablesToJSONobject());
                }
                this._doneWorkCallback.completed(result);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void failed(@Nullable final Throwable throwable) {
        super.failed(throwable);

        try {
            JSONObject _json = getJSONobject();

            doneWork();

            int count = ACEStaticConfig.ACECONSTANT_INTEGER.INIT_FAILED_LOG_COUNT;
            if (_json.has(ACELOG_JSON_KEY.FAILED_COUNT)) {
                count = _json.getInt(ACELOG_JSON_KEY.FAILED_COUNT) + 1;
            }
            _json.put(ACELOG_JSON_KEY.FAILED_COUNT, count);

            if (throwable != null) {
                JSONObject _jsonThrowable = new JSONObject();
                _jsonThrowable.put(ACELOG_JSON_KEY.STACKTRACE, throwable.getMessage());
                _jsonThrowable.put(ACELOG_JSON_KEY.CAUSE, throwable.getCause());
                _json.put(ACELOG_JSON_KEY.THROWABLE, _jsonThrowable);
            }

            if (_context != null) {
                ACEFileUtil.appendFailedLogFile(_context, new JSONArray().put(_json));
            }

            ACEDebugLog.v(TAG, _json.toString());
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, failed: %s", this.getTaskHash(), _json.toString(2)));
        } catch (JSONException e) {
            e.printStackTrace();
        }

        if (this._doneWorkCallback != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, Start doneWorkCallback: %s", this.getTaskHash(), this.getClass().getSimpleName()));

            try {
                JSONObject result = new JSONObject();
                result.put(ACEStaticConfig.ACELOG_JSON_KEY.TaskHash, String.valueOf(getTaskHash()));
                if (throwable != null) {
                    result.put(ACEConstantCallbackKey_Failed_Cause, throwable.getCause().toString());
                }
                this._doneWorkCallback.failed(result);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void doneWork() {
        ACELog.d(TAG, "in doneWork()");
        // 공통 [S]
        ACEParameterUtilForPlus.getInstance().resetSessionAndParameterAfterSend();
        // 공통 [E]
    }

    public JSONObject getJSONobject() throws JSONException {
        JSONObject _json = new JSONObject();

        _json.put(ACELOG_JSON_KEY.LOGTYPE, ACEStaticConfig.ACELOG_TYPE.API_LOG);
        _json.put(ACELOG_JSON_KEY.CREATETIME, getCreateTime().getTime());

        JSONObject _jsonRequestInformation = new JSONObject();
        _jsonRequestInformation.put(ACELOG_JSON_KEY.REQUEST_SERVICE_ID, ACECommonStaticConfig.getKey());
        if (ACEStaticConfig.USER_AGENT != null) {
            _jsonRequestInformation.put(ACELOG_JSON_KEY.REQUEST_USER_AGENT, ACEStaticConfig.USER_AGENT);
        }
        String cookie = ACEParameterUtilForPlus.getInstance().getGSCKForCookie();
        if (!TextUtils.isEmpty(cookie)) {
            _jsonRequestInformation.put(ACEStaticConfig.LOG.REQUEST_COOKIE, cookie);
        }
        _json.put(ACELOG_JSON_KEY.REQUEST, _jsonRequestInformation);

        _json.put(ACELOG_JSON_KEY.PARAMS, new JSONObject(_map));

        return _json;
    }
}
