package com.acecounter.android.acetm.acplus.parameter;

import android.content.Context;

import androidx.annotation.Nullable;

import com.acecounter.android.acetm.ICallbackOfACE;
import com.acecounter.android.acetm.acplus.config.ACEPlusStaticConfig.ACEReducerForPlusAPIParamKey;
import com.acecounter.android.acetm.common.config.ACEStaticConfig;
import com.acecounter.android.acetm.common.logger.ACELog;
import com.acecounter.android.acetm.common.parameter.ICallbackOfTask;
import com.acecounter.android.acetm.common.parameter.Task;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class APIForPushAtStartAppForPlus extends Task {
    final private String TAG = APIForPushAtStartAppForPlus.class.getSimpleName();

    @Nullable
    protected Context _context;
    @Nullable
    protected ConcurrentHashMap<String, Object> _parameters;

    APIForPushAtStartAppForPlus(final int logSource,
                                @Nullable Map<String, Object> parameters,
                                @Nullable ICallbackOfACE doneWorkCallback) {
        super(logSource, doneWorkCallback);
        if (parameters != null) {
            _parameters = new ConcurrentHashMap<>();
            _parameters.putAll(parameters);
        }
    }

    @Override
    public void doWork(@Nullable final ICallbackOfTask callbackForTask) {
        super.doWork(callbackForTask);

        ACEParametersForPlus _parametersForPlus = ACEParametersForPlus.getInstance();
        ACEParameterUtilForPlus _parameterUtilForPlus = ACEParameterUtilForPlus.getInstance();

        switch (_logSource) {
            case ACEStaticConfig.ACEofAPI.PushAtStartApp: {
                if (_parameters != null) {
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.ACP_PUSH)) {
                        String _acpPush = (String)_parameters.get(ACEReducerForPlusAPIParamKey.ACP_PUSH);
                        _parametersForPlus.setACP_PUSH(_acpPush);
                        _parametersForPlus.setTK(null);
                    }
                }
                break;
            }
            default:
                break;
        }

        // doWork 결과
        ACELog.d(TAG,
                String.format(
                        Locale.getDefault(),
                        "%d, doWork result _params: %s", this.getTaskHash(), _parameterUtilForPlus.toString()));

        if (callbackForTask != null) {
            callbackForTask.callback();
        }

        if (this._doneWorkCallback != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, Start doneWorkCallback: %s", this.getTaskHash(), this.getClass().getSimpleName()));
            try {
                JSONObject result = new JSONObject();
                result.put(ACEStaticConfig.ACELOG_JSON_KEY.TaskHash, String.valueOf(getTaskHash()));
                result.put("response", "done");
                this._doneWorkCallback.completed(result);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void didWork() {
        super.didWork();
    }
}
