package com.acecounter.android.acetm.acplus.parameter;

import android.content.Context;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.ICallbackOfACE;
import com.acecounter.android.acetm.acplus.config.ACEPlusStaticConfig;
import com.acecounter.android.acetm.acplus.config.ACEPlusStaticConfig.ACEReducerForPlusAPIParamKey;
import com.acecounter.android.acetm.common.config.ACEStaticConfig;
import com.acecounter.android.acetm.common.file.ACEFileUtil;
import com.acecounter.android.acetm.common.http.ACENetwork;
import com.acecounter.android.acetm.common.http.ACENetworkAdapter;
import com.acecounter.android.acetm.common.http.ACENetworkResult;
import com.acecounter.android.acetm.common.http.IACENetworkParams;
import com.acecounter.android.acetm.common.logger.ACEDebugLog;
import com.acecounter.android.acetm.common.logger.ACELog;
import com.acecounter.android.acetm.common.parameter.ACEParameterUtil;
import com.acecounter.android.acetm.common.parameter.ICallbackOfTask;
import com.acecounter.android.acetm.common.parameter.Task;
import com.acecounter.android.acetm.common.policy.ACEPolicyParameters;
import com.acecounter.android.acetm.common.util.StringUtils;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import static com.acecounter.android.acetm.common.config.ACEPublicStaticConfig.ACEConstantCallbackKey_Failed_Cause;

class APIForPV extends Task {
    final private String TAG = APIForPV.class.getSimpleName();

    @Nullable
    protected Context _context;
    @Nullable
    protected ConcurrentHashMap<String, Object> _parameters;

    APIForPV(final int logSource,
             @Nullable Map<String, Object> parameters,
             @Nullable ICallbackOfACE doneWorkCallback) {
        super(logSource, doneWorkCallback);
        if (parameters != null) {
            _parameters = new ConcurrentHashMap<>();
            _parameters.putAll(parameters);
        }
    }

    @Override
    public void doWork(@Nullable final ICallbackOfTask callbackForTask) {
        super.doWork(callbackForTask);
        String _pageName = null;

        ACEParametersForPlus _parametersForPlus = ACEParametersForPlus.getInstance();
        ACEParameterUtilForPlus _parameterUtilForPlus = ACEParameterUtilForPlus.getInstance();

        _parametersForPlus.setRND((int) (Math.random() * 100000000));
        _parameterUtilForPlus.getUserInformation();
        _parametersForPlus.setACM(ACEPlusStaticConfig.ParamsPlusEnum_ACM.SITE);
        _parametersForPlus.setAEM(ACEPlusStaticConfig.ParamsPlusEnum_AEM.PV);

        if (_parameters != null) {
            if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.CONTEXT)) {
                _context = (Context)_parameters.get(ACEReducerForPlusAPIParamKey.CONTEXT);
            }
            if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.PAGE_NAME)) {
                _pageName = (String)_parameters.get(ACEReducerForPlusAPIParamKey.PAGE_NAME);
            }
        }

        // AET, AVT [S]
        if (_parameterUtilForPlus.isFirstLog()) {
            if (_context != null) {
                _parametersForPlus.setAET(System.currentTimeMillis() + ACEPolicyParameters.getInstance().getTimeInterval());
            }
        }
        else {
            _parameterUtilForPlus.updateAETnAVT();
        }
        // AET, AVT [E]

        // URL, EREF [S]
        if (StringUtils.isNull(_pageName)) {
            if (_context != null) {
                _pageName = ACEParameterUtil.getContextName(_context);
            }
        }
        if (StringUtils.isNull(_pageName)) {
            _pageName = "";
        }
        _parameterUtilForPlus.updateURLnEREF(_pageName);

        // URL, EREF [E]

        switch (_logSource) {
            case ACEStaticConfig.ACEofAPI.DeepLinkAtRunningApp: {
                if (_parameters != null) {
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.TK)) {
                        String _tk = (String)_parameters.get(ACEReducerForPlusAPIParamKey.TK);
                        _parametersForPlus.setTK(_tk);
                    }
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.GSCK)) {
                        String _gsck = (String)_parameters.get(ACEReducerForPlusAPIParamKey.GSCK);
                        _parametersForPlus.setGSCK(_gsck);
                    }
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.AS)) {
                        String _as = (String)_parameters.get(ACEReducerForPlusAPIParamKey.AS);
                        _parametersForPlus.setAS(_as);
                    }
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.MS)) {
                        String _ms = (String)_parameters.get(ACEReducerForPlusAPIParamKey.MS);
                        _parametersForPlus.setMS(_ms);
                    }
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.PRMT)) {
                        String _prmt = (String)_parameters.get(ACEReducerForPlusAPIParamKey.PRMT);
                        _parametersForPlus.setPRMT(_prmt);
                    }

                    _parametersForPlus.setIsNeedSetNewSession(true);
                }
                break;
            }
            case ACEStaticConfig.ACEofAPI.PushAtRunningApp: {
                if (_parameters != null) {
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.ACP_PUSH)) {
                        String _acpPush = (String)_parameters.get(ACEReducerForPlusAPIParamKey.ACP_PUSH);
                        _parametersForPlus.setACP_PUSH(_acpPush);
                        _parametersForPlus.setTK(null);
                    }

                    _parametersForPlus.setIsNeedSetNewSession(true);
                }
                break;
            }
            default:
                break;
        }

        _parameterUtilForPlus.setPushParameters();
        // doWork 결과
        ACELog.d(TAG,
                String.format(
                        Locale.getDefault(),
                        "%d, doWork result _params: %s", this.getTaskHash(), _parameterUtilForPlus.toString()));

        if (callbackForTask != null &&
                this.getClass().getSimpleName().equalsIgnoreCase(TAG)) {
            callbackForTask.callback();
        }
        else if (callbackForTask != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, class name: %s", this.getTaskHash(), this.getClass().getSimpleName()));
        }
    }

    @Override
    public void didWork() {
        super.didWork();

        ACENetworkAdapter networkAdapter = new ACENetworkAdapter();
        networkAdapter.setGetURL(new ACENetwork.OnGetURL() {
            @NonNull
            @Override
            public String getURL() {
                return ACEParameterUtilForPlus.getInstance().getParametersToURL(ACEStaticConfig.HTTP_METHOD.GET);
            }
        });
        networkAdapter.request(new IACENetworkParams() {
            @Override
            public void completed(@Nullable final ACENetworkResult response) {
                APIForPV.this.completed(response);
            }

            @Override
            public void failed(@Nullable final Throwable throwable) {
                APIForPV.this.failed(throwable);
            }
        });
    }

    @Override
    public void completed(@Nullable final ACENetworkResult response) {
        super.completed(response);
        if (response != null) {
            ACELog.d(TAG, response.toString());
        }

        doneWork();
        ACELog.d(TAG,
                String.format(
                        Locale.getDefault(),
                        "%d, completed done", this.getTaskHash()));

        if (this._doneWorkCallback != null &&
                this.getClass().getSimpleName().equalsIgnoreCase(TAG)) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, Start doneWorkCallback: %s", this.getTaskHash(), this.getClass().getSimpleName()));

            try {
                JSONObject result = new JSONObject();
                result.put(ACEStaticConfig.ACELOG_JSON_KEY.TaskHash, String.valueOf(getTaskHash()));
                if (response != null) {
                    result.put("response", response.getsVariablesToJSONobject());
                }
                this._doneWorkCallback.completed(result);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        else if (this._doneWorkCallback != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, class name: %s", this.getTaskHash(), this.getClass().getSimpleName()));
        }
        else if (this._doneWorkCallback == null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, _doneWorkCallback is null", this.getTaskHash()));
        }
    }

    @Override
    public void failed(@Nullable final Throwable throwable) {
        super.failed(throwable);

        try {
            JSONObject _json = getJSONobject();

            doneWork();

            int count = ACEStaticConfig.ACECONSTANT_INTEGER.INIT_FAILED_LOG_COUNT;
            if (_json.has(ACEStaticConfig.ACELOG_JSON_KEY.FAILED_COUNT)) {
                count = _json.getInt(ACEStaticConfig.ACELOG_JSON_KEY.FAILED_COUNT) + 1;
            }
            _json.put(ACEStaticConfig.ACELOG_JSON_KEY.FAILED_COUNT, count);

            if (throwable != null) {
                JSONObject _jsonThrowable = new JSONObject();
                _jsonThrowable.put(ACEStaticConfig.ACELOG_JSON_KEY.STACKTRACE, throwable.getMessage());
                _jsonThrowable.put(ACEStaticConfig.ACELOG_JSON_KEY.CAUSE, throwable.getCause());
                _json.put(ACEStaticConfig.ACELOG_JSON_KEY.THROWABLE, _jsonThrowable);
            }

            if (_context != null) {
                ACEFileUtil.appendFailedLogFile(_context, new JSONArray().put(_json));
            }

            ACEDebugLog.v(TAG, _json.toString());
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, failed: %s", this.getTaskHash(), _json.toString(2)));
        } catch (JSONException e) {
            e.printStackTrace();
        }

        if (this._doneWorkCallback != null &&
                this.getClass().getSimpleName().equalsIgnoreCase(TAG)) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, Start doneWorkCallback: %s", this.getTaskHash(), this.getClass().getSimpleName()));

            try {
                JSONObject result = new JSONObject();
                result.put(ACEStaticConfig.ACELOG_JSON_KEY.TaskHash, String.valueOf(getTaskHash()));
                if (throwable != null) {
                    result.put(ACEConstantCallbackKey_Failed_Cause, throwable.getCause().toString());
                }
                this._doneWorkCallback.failed(result);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        else if (this._doneWorkCallback != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, class name: %s", this.getTaskHash(), this.getClass().getSimpleName()));
        }
        else if (this._doneWorkCallback == null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, _doneWorkCallback is null", this.getTaskHash()));
        }
    }

    @Override
    public void doneWork() {
        ACELog.d(TAG, "in doneWork()");
        // 공통 [S]
        ACEParameterUtilForPlus.getInstance().resetSessionAndParameterAfterSend();
        // 공통 [E]
    }

}
