package com.acecounter.android.acetm.acplus.parameter;

import android.content.Context;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.AceTM;
import com.acecounter.android.acetm.ICallbackOfACE;
import com.acecounter.android.acetm.acplus.config.ACEPlusStaticConfig;
import com.acecounter.android.acetm.acplus.config.ACEPlusStaticConfig.ACEReducerForPlusAPIParamKey;
import com.acecounter.android.acetm.common.config.ACEPublicStaticConfig;
import com.acecounter.android.acetm.common.config.ACEStaticConfig;
import com.acecounter.android.acetm.common.http.ACENetwork;
import com.acecounter.android.acetm.common.http.ACENetworkAdapter;
import com.acecounter.android.acetm.common.http.ACENetworkResult;
import com.acecounter.android.acetm.common.http.IACENetworkParams;
import com.acecounter.android.acetm.common.logger.ACELog;
import com.acecounter.android.acetm.common.parameter.ACEParameterUtil;
import com.acecounter.android.acetm.common.parameter.ICallbackOfTask;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Locale;
import java.util.Map;

import static com.acecounter.android.acetm.common.config.ACEPublicStaticConfig.ACEConstantCallbackKey_Failed_Cause;

public final class APIForLoginOnPage extends APIForPV {
    private final String TAG = APIForLoginOnPage.class.getSimpleName();
    private AceTM.Gender _userGender = null;

    APIForLoginOnPage(final int logSource,
                      @Nullable Map<String, Object> parameters,
                      @Nullable ICallbackOfACE doneWorkCallback) {
        super(logSource, parameters, doneWorkCallback);
    }

    @Override
    public void doWork(@Nullable final ICallbackOfTask callbackForTask) {
        super.doWork(callbackForTask);

        String _pageName = null;
        String _userId = null;
        Integer _userAge = null;
        Integer _userGroup_1 = null;
        Integer _userGroup_2 = null;
        Integer _userGroup_3 = null;
        Integer _userGroup_4 = null;
        Integer _userGroup_5 = null;

        ACEParametersForPlus _parametersForPlus = ACEParametersForPlus.getInstance();
        ACEParameterUtilForPlus _parameterUtilForPlus = ACEParameterUtilForPlus.getInstance();

        if (_parameters != null) {
            if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.CONTEXT)) {
                _context = (Context)_parameters.get(ACEReducerForPlusAPIParamKey.CONTEXT);
            }
            if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.PAGE_NAME)) {
                _pageName = (String)_parameters.get(ACEReducerForPlusAPIParamKey.PAGE_NAME);
            }
            if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.USER_ID)) {
                _userId = (String)_parameters.get(ACEReducerForPlusAPIParamKey.USER_ID);
            }
            if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.AGE)) {
                _userAge = (Integer)_parameters.get(ACEReducerForPlusAPIParamKey.AGE);
            }
            if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.GENDER)) {
                _userGender = (AceTM.Gender)_parameters.get(ACEReducerForPlusAPIParamKey.GENDER);
            }
            if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.GROUP_1)) {
                _userGroup_1 = (Integer)_parameters.get(ACEReducerForPlusAPIParamKey.GROUP_1);
            }
            if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.GROUP_2)) {
                _userGroup_2 = (Integer)_parameters.get(ACEReducerForPlusAPIParamKey.GROUP_2);
            }
            if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.GROUP_3)) {
                _userGroup_3 = (Integer)_parameters.get(ACEReducerForPlusAPIParamKey.GROUP_3);
            }
            if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.GROUP_4)) {
                _userGroup_4 = (Integer)_parameters.get(ACEReducerForPlusAPIParamKey.GROUP_4);
            }
            if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.GROUP_5)) {
                _userGroup_5 = (Integer)_parameters.get(ACEReducerForPlusAPIParamKey.GROUP_5);
            }
        }

        if (_userAge == null) {
            _userAge = 0;
        }
        if (_userGender == null) {
            _userGender = AceTM.Gender.UNKNOWN;
        }
        if (_userGroup_1 == null) {
            _userGroup_1 = 0;
        }
        if (_userGroup_2 == null) {
            _userGroup_2 = 0;
        }
        if (_userGroup_3 == null) {
            _userGroup_3 = 0;
        }
        if (_userGroup_4 == null) {
            _userGroup_4 = 0;
        }
        if (_userGroup_5 == null) {
            _userGroup_5 = 0;
        }

        switch (_logSource) {
            case ACEPlusStaticConfig.ACEofAPIForPlus.Login: {
                // 빈문자열 대응
                if (_pageName != null) {
                    _parameterUtilForPlus.updateURLnEREF(_pageName);
                }
                else {
                    if (_context != null) {
                        _parameterUtilForPlus.updateURLnEREF(ACEParameterUtil.getContextName(_context));
                    }
                }
                _parametersForPlus.setMT(ACEPlusStaticConfig.MEMBERSHIP.LOGGED_IN);
                _parametersForPlus.setMT_nonInStorage(ACEPlusStaticConfig.MEMBERSHIP.LOGIN);
                _parametersForPlus.setAGE(_userAge + ACEStaticConfig.ACECONSTANT_INTEGER.ENCRYPT_VALUE_AGE);
                _parametersForPlus.setAGE_nonInStorage(_userAge);

                _parametersForPlus.setUID(_userId);
                if (_userGender == AceTM.Gender.MAN) {
                    _parametersForPlus.setGD_nonInStorage(ACEPublicStaticConfig.ACEGender.Man.getName());
                }
                else if (_userGender == AceTM.Gender.WOMAN) {
                    _parametersForPlus.setGD_nonInStorage(ACEPublicStaticConfig.ACEGender.Woman.getName());
                }
                else {
                    _parametersForPlus.setGD_nonInStorage(null);
                }

                _parametersForPlus.setUD1(_userGroup_1);
                _parametersForPlus.setUD2(_userGroup_2);
                _parametersForPlus.setUD3(_userGroup_3);
                _parametersForPlus.setUD4(_userGroup_4);
                _parametersForPlus.setUD5(_userGroup_5);
                break;
            }
            default:
                break;
        }

        _parametersForPlus.setMID(_userId);

        // doWork 결과
        ACELog.d(TAG,
                String.format(
                        Locale.getDefault(),
                        "%d, doWork result _params: %s", this.getTaskHash(), _parameterUtilForPlus.toString()));

        if (callbackForTask != null) {
            callbackForTask.callback();
        }
    }

    @Override
    public void didWork() {
        ACENetworkAdapter networkAdapter = new ACENetworkAdapter();
        networkAdapter.setGetURL(new ACENetwork.OnGetURL() {
            @NonNull
            @Override
            public String getURL() {
                return ACEParameterUtilForPlus.getInstance().getParametersToURL(ACEStaticConfig.HTTP_METHOD.GET);
            }
        });
        networkAdapter.request(new IACENetworkParams() {
            @Override
            public void completed(@Nullable final ACENetworkResult response) {
                APIForLoginOnPage.this.completed(response);
            }

            @Override
            public void failed(@Nullable final Throwable throwable) {
                APIForLoginOnPage.this.failed(throwable);
            }
        });
    }

    @Override
    public void completed(@Nullable final ACENetworkResult response) {
        super.completed(response);
        ACELog.d(TAG,
                String.format(
                        Locale.getDefault(),
                        "%d, completed done", this.getTaskHash()));
        if (this._doneWorkCallback != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, Start doneWorkCallback: %s", this.getTaskHash(), this.getClass().getSimpleName()));

            try {
                JSONObject result = new JSONObject();
                result.put(ACEStaticConfig.ACELOG_JSON_KEY.TaskHash, String.valueOf(getTaskHash()));
                if (response != null) {
                    result.put("response", response.getsVariablesToJSONobject());
                }
                this._doneWorkCallback.completed(result);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void failed(@Nullable final Throwable throwable) {
        super.failed(throwable);
        if (this._doneWorkCallback != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, Start doneWorkCallback: %s", this.getTaskHash(), this.getClass().getSimpleName()));

            try {
                JSONObject result = new JSONObject();
                result.put(ACEStaticConfig.ACELOG_JSON_KEY.TaskHash, String.valueOf(getTaskHash()));
                if (throwable != null) {
                    result.put(ACEConstantCallbackKey_Failed_Cause, throwable.getCause().toString());
                }
                this._doneWorkCallback.failed(result);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void doneWork() {
        super.doneWork();
        ACELog.d(TAG, "in doneWork()");
        ACEParametersForPlus _parametersForPlus = ACEParametersForPlus.getInstance();

        // 공통 [S]
        _parametersForPlus.setMT_nonInStorage(ACEPlusStaticConfig.MEMBERSHIP.LOGGED_IN);
        _parametersForPlus.getAGE();
        _parametersForPlus.setMID(null);
        _parametersForPlus.setGD(_userGender);
        _parametersForPlus.setUD1_nonInStorage(0);
        _parametersForPlus.setUD2_nonInStorage(0);
        _parametersForPlus.setUD3_nonInStorage(0);
        _parametersForPlus.setUD4_nonInStorage(0);
        _parametersForPlus.setUD5_nonInStorage(0);
        // 공통 [E]
    }
}
