package com.acecounter.android.acetm.acplus.parameter;

import android.content.Context;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.AceTM;
import com.acecounter.android.acetm.ICallbackOfACE;
import com.acecounter.android.acetm.acplus.config.ACEPlusStaticConfig;
import com.acecounter.android.acetm.acplus.config.ACEPlusStaticConfig.ACEReducerForPlusAPIParamKey;
import com.acecounter.android.acetm.common.config.ACEStaticConfig;
import com.acecounter.android.acetm.common.http.ACENetwork;
import com.acecounter.android.acetm.common.http.ACENetworkAdapter;
import com.acecounter.android.acetm.common.http.ACENetworkResult;
import com.acecounter.android.acetm.common.http.IACENetworkParams;
import com.acecounter.android.acetm.common.logger.ACELog;
import com.acecounter.android.acetm.common.parameter.ICallbackOfTask;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import static com.acecounter.android.acetm.common.config.ACEPublicStaticConfig.ACEConstantCallbackKey_Failed_Cause;

public final class APIForJoinOnPage extends APIForPV {
    private final String TAG = APIForJoinOnPage.class.getSimpleName();

    APIForJoinOnPage(final int logSource,
                     @Nullable Map<String, Object> parameters,
                     @Nullable ICallbackOfACE doneWorkCallback) {
        super(logSource, parameters, doneWorkCallback);
    }

    @Override
    public void doWork(@Nullable final ICallbackOfTask callbackForTask) {
        super.doWork(callbackForTask);

        String _userId = null;
        Integer _userAge = 0;
        Integer _userValue = 0;
        AceTM.Gender _userGender = AceTM.Gender.UNKNOWN;
        Integer _userGroup_1 = 0;
        Integer _userGroup_2 = 0;
        Integer _userGroup_3 = 0;
        Integer _userGroup_4 = 0;
        Integer _userGroup_5 = 0;

        ACEParametersForPlus _parametersForPlus = ACEParametersForPlus.getInstance();
        ACEParameterUtilForPlus _parameterUtilForPlus = ACEParameterUtilForPlus.getInstance();

        if (_parameters != null) {
            if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.CONTEXT)) {
                _context = (Context)_parameters.get(ACEReducerForPlusAPIParamKey.CONTEXT);
            }
            if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.USER_ID)) {
                _userId = (String)_parameters.get(ACEReducerForPlusAPIParamKey.USER_ID);
            }
            if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.USER_VALUE)) {
                _userValue = (Integer)_parameters.get(ACEReducerForPlusAPIParamKey.USER_VALUE);
            }
        }

        ACEParametersForPlus.getInstance().getUID();
        switch (_logSource) {
            case ACEPlusStaticConfig.ACEofAPIForPlus.Join: {
                _parametersForPlus.setMT_nonInStorage(ACEPlusStaticConfig.MEMBERSHIP.REGISTER);
                _parametersForPlus.setAGE_nonInStorage(_userAge);
                break;
            }
            default:
                break;
        }

        _parametersForPlus.setGD_nonInStorage(_userGender.toString());
        _parametersForPlus.setMID(_userId);
        if (_userValue == null) {
            _userValue = 0;
        }
        _parametersForPlus.setMV(_userValue);
        _parametersForPlus.setUD1_nonInStorage(_userGroup_1);
        _parametersForPlus.setUD2_nonInStorage(_userGroup_2);
        _parametersForPlus.setUD3_nonInStorage(_userGroup_3);
        _parametersForPlus.setUD4_nonInStorage(_userGroup_4);
        _parametersForPlus.setUD5_nonInStorage(_userGroup_5);

        // doWork 결과
        ACELog.d(TAG,
                String.format(
                        Locale.getDefault(),
                        "%d, doWork result _params: %s", this.getTaskHash(), _parameterUtilForPlus.toString()));

        if (callbackForTask != null) {
            callbackForTask.callback();
        }
    }

    @Override
    public void didWork() {
        ACENetworkAdapter networkAdapter = new ACENetworkAdapter();
        networkAdapter.setGetURL(new ACENetwork.OnGetURL() {
            @NonNull
            @Override
            public String getURL() {
                return ACEParameterUtilForPlus.getInstance().getParametersToURL(ACEStaticConfig.HTTP_METHOD.GET);
            }
        });
        networkAdapter.request(new IACENetworkParams() {
            @Override
            public void completed(@Nullable final ACENetworkResult response) {
                APIForJoinOnPage.this.completed(response);
            }

            @Override
            public void failed(@Nullable final Throwable throwable) {
                APIForJoinOnPage.this.failed(throwable);
            }
        });
    }

    @Override
    public void completed(@Nullable final ACENetworkResult response) {
        super.completed(response);
        ACELog.d(TAG,
                String.format(
                        Locale.getDefault(),
                        "%d, completed done", this.getTaskHash()));
        if (this._doneWorkCallback != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, Start doneWorkCallback: %s", this.getTaskHash(), this.getClass().getSimpleName()));

            try {
                JSONObject result = new JSONObject();
                result.put(ACEStaticConfig.ACELOG_JSON_KEY.TaskHash, String.valueOf(getTaskHash()));
                if (response != null) {
                    result.put("response", response.getsVariablesToJSONobject());
                }
                this._doneWorkCallback.completed(result);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void failed(@Nullable final Throwable throwable) {
        super.failed(throwable);
        if (this._doneWorkCallback != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, Start doneWorkCallback: %s", this.getTaskHash(), this.getClass().getSimpleName()));

            try {
                JSONObject result = new JSONObject();
                result.put(ACEStaticConfig.ACELOG_JSON_KEY.TaskHash, String.valueOf(getTaskHash()));
                if (throwable != null) {
                    result.put(ACEConstantCallbackKey_Failed_Cause, throwable.getCause().toString());
                }
                this._doneWorkCallback.failed(result);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void doneWork() {
        super.doneWork();
        ACELog.d(TAG, "in doneWork()");
        ACEParametersForPlus _parametersForPlus = ACEParametersForPlus.getInstance();

        // 공통 [S]
        _parametersForPlus.setMID(null);
        _parametersForPlus.setGD_nonInStorage(null);
        _parametersForPlus.setMV(0);
        _parametersForPlus.setMT_nonInStorage(ACEPlusStaticConfig.MEMBERSHIP.DEFAULT);
        _parametersForPlus.setUD1_nonInStorage(0);
        _parametersForPlus.setUD2_nonInStorage(0);
        _parametersForPlus.setUD3_nonInStorage(0);
        _parametersForPlus.setUD4_nonInStorage(0);
        _parametersForPlus.setUD5_nonInStorage(0);
        _parametersForPlus.getAGE();
        // 공통 [E]
    }
}
