package com.acecounter.android.acetm.acplus.parameter;

import android.content.Context;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.ICallbackOfACE;
import com.acecounter.android.acetm.acplus.config.ACEPlusStaticConfig.ACEReducerForPlusAPIParamKey;
import com.acecounter.android.acetm.common.config.ACEStaticConfig;
import com.acecounter.android.acetm.common.file.ACEFileUtil;
import com.acecounter.android.acetm.common.http.ACENetwork;
import com.acecounter.android.acetm.common.http.ACENetworkAdapter;
import com.acecounter.android.acetm.common.http.ACENetworkResult;
import com.acecounter.android.acetm.common.http.IACENetworkParams;
import com.acecounter.android.acetm.common.logger.ACEDebugLog;
import com.acecounter.android.acetm.common.logger.ACEException;
import com.acecounter.android.acetm.common.logger.ACELog;
import com.acecounter.android.acetm.common.parameter.ICallbackOfTask;
import com.acecounter.android.acetm.common.parameter.Task;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import static com.acecounter.android.acetm.common.config.ACEPublicStaticConfig.ACEConstantCallbackKey_Failed_Cause;

public final class APIForJSON extends Task {
    private final String TAG = APIForJSON.class.getSimpleName();

    @Nullable
    private Context _context;
    @Nullable
    private ConcurrentHashMap<String, Object> _parameters;
    @Nullable
    private JSONObject _jsonObject;

    APIForJSON(final int logSource,
               @Nullable Map<String, Object> parameters,
               @Nullable ICallbackOfACE doneWorkCallback) {
        super(logSource, doneWorkCallback);
        if (parameters != null) {
            _parameters = new ConcurrentHashMap<>();
            _parameters.putAll(parameters);
        }
        _jsonObject = null;
    }

    @Override
    public void doWork(@Nullable final ICallbackOfTask callbackForTask) {
        super.doWork(callbackForTask);

        if (_parameters != null) {
            if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.CONTEXT)) {
                _context = (Context)_parameters.get(ACEReducerForPlusAPIParamKey.CONTEXT);
            }
            if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.JSON_OBJECT)) {
                _jsonObject = (JSONObject)_parameters.get(ACEReducerForPlusAPIParamKey.JSON_OBJECT);
            }
        }

        try {
            if (_jsonObject != null) {
                ACELog.d(TAG,
                        String.format(
                                Locale.getDefault(),
                                "%d, doWork result _params: %s", this.getTaskHash(), _jsonObject.toString(2)));
            }
        }
        catch (JSONException e) {
            ACEDebugLog.wtf(TAG, new ACEException(e, "doWork ACELog 과정에 예외 발생").toString());
        }

        if (callbackForTask != null) {
            callbackForTask.callback();
        }
    }

    @Override
    public void didWork() {
        super.didWork();

        ACENetworkAdapter networkAdapter = new ACENetworkAdapter();
        networkAdapter.setGetURL(new ACENetwork.OnGetURL() {
            @NonNull
            @Override
            public String getURL() {
                return ACEParameterUtilForPlus.convertJsonToGetURL(_jsonObject);
            }
        });
        networkAdapter.request(new IACENetworkParams() {
            @Override
            public void completed(@Nullable final ACENetworkResult response) {
                APIForJSON.this.completed(response);
            }

            @Override
            public void failed(@Nullable final Throwable throwable) {
                APIForJSON.this.failed(throwable);
            }
        });
    }

    @Override
    public void completed(@Nullable final ACENetworkResult response) {
        super.completed(response);
        if (response != null) {
            ACELog.d(TAG, response.toString());
        }

        doneWork();
        ACELog.d(TAG,
                String.format(
                        Locale.getDefault(),
                        "%d, completed done", this.getTaskHash()));
        if (this._doneWorkCallback != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, Start doneWorkCallback: %s", this.getTaskHash(), this.getClass().getSimpleName()));

            try {
                JSONObject result = new JSONObject();
                result.put(ACEStaticConfig.ACELOG_JSON_KEY.TaskHash, String.valueOf(getTaskHash()));
                if (response != null) {
                    result.put("response", response.getsVariablesToJSONobject());
                }
                this._doneWorkCallback.completed(result);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void failed(@Nullable final Throwable throwable) {
        super.failed(throwable);

        try {
            JSONObject _json = getJSONobject();

            doneWork();

            int count = ACEStaticConfig.ACECONSTANT_INTEGER.INIT_FAILED_LOG_COUNT;
            if (_json.has(ACEStaticConfig.ACELOG_JSON_KEY.FAILED_COUNT)) {
                count = _json.getInt(ACEStaticConfig.ACELOG_JSON_KEY.FAILED_COUNT) + 1;
            }
            _json.put(ACEStaticConfig.ACELOG_JSON_KEY.FAILED_COUNT, count);

            if (throwable != null) {
                JSONObject _jsonThrowable = new JSONObject();
                _jsonThrowable.put(ACEStaticConfig.ACELOG_JSON_KEY.STACKTRACE, throwable.getMessage());
                _jsonThrowable.put(ACEStaticConfig.ACELOG_JSON_KEY.CAUSE, throwable.getCause());
                _json.put(ACEStaticConfig.ACELOG_JSON_KEY.THROWABLE, _jsonThrowable);
            }

            if (_context != null) {
                ACEFileUtil.appendFailedLogFile(_context, new JSONArray().put(_json));
            }

            ACEDebugLog.v(TAG, _json.toString());
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, failed: %s", this.getTaskHash(), _json.toString(2)));
        } catch (JSONException e) {
            e.printStackTrace();
        }

        if (this._doneWorkCallback != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, Start doneWorkCallback: %s", this.getTaskHash(), this.getClass().getSimpleName()));

            try {
                JSONObject result = new JSONObject();
                result.put(ACEStaticConfig.ACELOG_JSON_KEY.TaskHash, String.valueOf(getTaskHash()));
                if (throwable != null) {
                    result.put(ACEConstantCallbackKey_Failed_Cause, throwable.getCause().toString());
                }
                this._doneWorkCallback.failed(result);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void doneWork() {
        // 공통 [S]
        ACEParameterUtilForPlus.getInstance().resetSessionAndParameterAfterSend();
        // 공통 [E]
    }

    @Override
    public JSONObject getJSONobject() throws JSONException {
        JSONObject _json = new JSONObject();

        _json.put(ACEStaticConfig.ACELOG_JSON_KEY.LOGTYPE, ACEStaticConfig.ACELOG_TYPE.API_LOG);
        if (_jsonObject != null) {
            if (_jsonObject.has(ACEStaticConfig.ACELOG_JSON_KEY.CREATETIME)) {
                _json.put(ACEStaticConfig.ACELOG_JSON_KEY.CREATETIME, _jsonObject.get(ACEStaticConfig.ACELOG_JSON_KEY.CREATETIME));
            }
            if (_jsonObject.has(ACEStaticConfig.ACELOG_JSON_KEY.PARAMS)) {
                _json.put(ACEStaticConfig.ACELOG_JSON_KEY.PARAMS, _jsonObject.getJSONObject(ACEStaticConfig.ACELOG_JSON_KEY.PARAMS));
            }
        }
        else {
            _json.put(ACEStaticConfig.ACELOG_JSON_KEY.CREATETIME, getCreateTime().getTime());
        }

        return _json;
    }
}
