package com.acecounter.android.acetm.acplus.parameter;

import android.content.Context;

import androidx.annotation.Nullable;

import com.acecounter.android.acetm.ICallbackOfACE;
import com.acecounter.android.acetm.acplus.config.ACEPlusStaticConfig.ACEReducerForPlusAPIParamKey;
import com.acecounter.android.acetm.common.config.ACEStaticConfig;
import com.acecounter.android.acetm.common.logger.ACELog;
import com.acecounter.android.acetm.common.parameter.ICallbackOfTask;
import com.acecounter.android.acetm.common.parameter.Task;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class APIForDeepLinkAtStartAppForPlus extends Task {
    final private String TAG = APIForDeepLinkAtStartAppForPlus.class.getSimpleName();

    @Nullable
    protected Context _context;
    @Nullable
    protected ConcurrentHashMap<String, Object> _parameters;

    APIForDeepLinkAtStartAppForPlus(final int logSource,
                                    @Nullable Map<String, Object> parameters,
                                    @Nullable ICallbackOfACE doneWorkCallback) {
        super(logSource, doneWorkCallback);
        if (parameters != null) {
            _parameters = new ConcurrentHashMap<>();
            _parameters.putAll(parameters);
        }
    }

    @Override
    public void doWork(@Nullable final ICallbackOfTask callbackForTask) {
        super.doWork(callbackForTask);

        ACEParametersForPlus _parametersForPlus = ACEParametersForPlus.getInstance();
        ACEParameterUtilForPlus _parameterUtilForPlus = ACEParameterUtilForPlus.getInstance();
        switch (_logSource) {
            case ACEStaticConfig.ACEofAPI.DeepLinkAtStartApp: {
                if (_parameters != null) {
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.TK)) {
                        String _tk = (String)_parameters.get(ACEReducerForPlusAPIParamKey.TK);
                        _parametersForPlus.setTK(_tk);
                    }
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.GSCK)) {
                        String _gsck = (String)_parameters.get(ACEReducerForPlusAPIParamKey.GSCK);
                        _parametersForPlus.setGSCK(_gsck);
                    }
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.AS)) {
                        String _as = (String)_parameters.get(ACEReducerForPlusAPIParamKey.AS);
                        _parametersForPlus.setAS(_as);
                    }
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.MS)) {
                        String _ms = (String)_parameters.get(ACEReducerForPlusAPIParamKey.MS);
                        _parametersForPlus.setMS(_ms);
                    }
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.PRMT)) {
                        String _prmt = (String)_parameters.get(ACEReducerForPlusAPIParamKey.PRMT);
                        _parametersForPlus.setPRMT(_prmt);
                    }
                }
                break;
            }
            default:
                break;
        }

        // doWork 결과
        ACELog.d(TAG,
                String.format(
                        Locale.getDefault(),
                        "%d, doWork result _params: %s", this.getTaskHash(), _parameterUtilForPlus.toString()));

        if (callbackForTask != null) {
            callbackForTask.callback();
        }

        if (this._doneWorkCallback != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, Start doneWorkCallback: %s", this.getTaskHash(), this.getClass().getSimpleName()));
            try {
                JSONObject result = new JSONObject();
                result.put(ACEStaticConfig.ACELOG_JSON_KEY.TaskHash, String.valueOf(getTaskHash()));
                result.put("response", "done");
                this._doneWorkCallback.completed(result);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void didWork() {
        super.didWork();
    }
}
