package com.acecounter.android.acetm.acplus.parameter;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.AceTM;
import com.acecounter.android.acetm.ICallbackOfACE;
import com.acecounter.android.acetm.acplus.config.ACEPlusStaticConfig;
import com.acecounter.android.acetm.acplus.config.ACEPlusStaticConfig.ACEReducerForPlusAPIParamKey;
import com.acecounter.android.acetm.common.config.ACEStaticConfig;
import com.acecounter.android.acetm.common.http.ACENetwork;
import com.acecounter.android.acetm.common.http.ACENetworkAdapter;
import com.acecounter.android.acetm.common.http.ACENetworkResult;
import com.acecounter.android.acetm.common.http.IACENetworkParams;
import com.acecounter.android.acetm.common.logger.ACELog;
import com.acecounter.android.acetm.common.parameter.ICallbackOfTask;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Locale;
import java.util.Map;

import static com.acecounter.android.acetm.common.config.ACEPublicStaticConfig.ACEConstantCallbackKey_Failed_Cause;

public final class APIForDeactivateOnPage extends APIForPV {
    private final String TAG = APIForDeactivateOnPage.class.getSimpleName();

    APIForDeactivateOnPage(final int logSource,
                           @Nullable Map<String, Object> parameters,
                           @Nullable ICallbackOfACE doneWorkCallback) {
        super(logSource, parameters, doneWorkCallback);
    }

    @Override
    public void doWork(@Nullable final ICallbackOfTask callbackForTask) {
        super.doWork(callbackForTask);

        String _userId = null;
        Integer _userValue = 0;
        AceTM.Gender _userGender = AceTM.Gender.UNKNOWN;

        ACEParametersForPlus _parametersForPlus = ACEParametersForPlus.getInstance();
        ACEParameterUtilForPlus _parameterUtilForPlus = ACEParameterUtilForPlus.getInstance();

        if (_parameters != null) {
            if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.USER_ID)) {
                _userId = (String)_parameters.get(ACEReducerForPlusAPIParamKey.USER_ID);
            }
        }

        switch (_logSource) {
            case ACEPlusStaticConfig.ACEofAPIForPlus.Deactivate: {
                _parametersForPlus.setAGE(0);
                _parametersForPlus.removeMT();
                _parametersForPlus.setMT_nonInStorage(ACEPlusStaticConfig.MEMBERSHIP.LEAVE);
                _parametersForPlus.removeUID();
                _parametersForPlus.setUD1(0);
                _parametersForPlus.setUD2(0);
                _parametersForPlus.setUD3(0);
                _parametersForPlus.setUD4(0);
                _parametersForPlus.setUD5(0);
                break;
            }
            default:
                break;
        }

        _parametersForPlus.setGD(_userGender);
        _parametersForPlus.setMID(_userId);
        _parametersForPlus.setMV(_userValue);

        // doWork 결과
        ACELog.d(TAG,
                String.format(
                        Locale.getDefault(),
                        "%d, doWork result _params: %s", this.getTaskHash(), _parameterUtilForPlus.toString()));

        if (callbackForTask != null) {
            callbackForTask.callback();
        }
    }

    @Override
    public void didWork() {
        ACENetworkAdapter networkAdapter = new ACENetworkAdapter();
        networkAdapter.setGetURL(new ACENetwork.OnGetURL() {
            @NonNull
            @Override
            public String getURL() {
                return ACEParameterUtilForPlus.getInstance().getParametersToURL(ACEStaticConfig.HTTP_METHOD.GET);
            }
        });
        networkAdapter.request(new IACENetworkParams() {
            @Override
            public void completed(@Nullable final ACENetworkResult response) {
                APIForDeactivateOnPage.this.completed(response);
            }

            @Override
            public void failed(@Nullable final Throwable throwable) {
                APIForDeactivateOnPage.this.failed(throwable);
            }
        });
    }

    @Override
    public void completed(@Nullable final ACENetworkResult response) {
        super.completed(response);
        ACELog.d(TAG,
                String.format(
                        Locale.getDefault(),
                        "%d, completed done", this.getTaskHash()));
        if (this._doneWorkCallback != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, Start doneWorkCallback: %s", this.getTaskHash(), this.getClass().getSimpleName()));

            try {
                JSONObject result = new JSONObject();
                result.put(ACEStaticConfig.ACELOG_JSON_KEY.TaskHash, String.valueOf(getTaskHash()));
                if (response != null) {
                    result.put("response", response.getsVariablesToJSONobject());
                }
                this._doneWorkCallback.completed(result);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void failed(@Nullable final Throwable throwable) {
        super.failed(throwable);
        if (this._doneWorkCallback != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, Start doneWorkCallback: %s", this.getTaskHash(), this.getClass().getSimpleName()));

            try {
                JSONObject result = new JSONObject();
                result.put(ACEStaticConfig.ACELOG_JSON_KEY.TaskHash, String.valueOf(getTaskHash()));
                if (throwable != null) {
                    result.put(ACEConstantCallbackKey_Failed_Cause, throwable.getCause().toString());
                }
                this._doneWorkCallback.failed(result);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void doneWork() {
        super.doneWork();
        ACELog.d(TAG, "in doneWork()");
        ACEParametersForPlus _parametersForPlus = ACEParametersForPlus.getInstance();

        // 공통 [S]
        _parametersForPlus.setMT_nonInStorage(0);
        _parametersForPlus.setMID(null);
        _parametersForPlus.setGD_nonInStorage(null);
        // 공통 [E]
    }
}
