package com.acecounter.android.acetm.acplus.parameter;

import android.content.Context;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.ICallbackOfACE;
import com.acecounter.android.acetm.acplus.config.ACEPlusStaticConfig;
import com.acecounter.android.acetm.acplus.config.ACEPlusStaticConfig.ACEReducerForPlusAPIParamKey;
import com.acecounter.android.acetm.common.config.ACEStaticConfig;
import com.acecounter.android.acetm.common.http.ACENetwork;
import com.acecounter.android.acetm.common.http.ACENetworkAdapter;
import com.acecounter.android.acetm.common.http.ACENetworkResult;
import com.acecounter.android.acetm.common.http.IACENetworkParams;
import com.acecounter.android.acetm.common.logger.ACELog;
import com.acecounter.android.acetm.common.parameter.ACEParameterUtil;
import com.acecounter.android.acetm.common.parameter.ICallbackOfTask;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Locale;
import java.util.Map;

import static com.acecounter.android.acetm.common.config.ACEPublicStaticConfig.ACEConstantCallbackKey_Failed_Cause;

public final class APIForCommerceOnPage extends APIForPV {
    private final String TAG = APIForCommerceOnPage.class.getSimpleName();

    APIForCommerceOnPage(final int logSource,
                         @Nullable Map<String, Object> parameters,
                         @Nullable ICallbackOfACE doneWorkCallback) {
        super(logSource, parameters, doneWorkCallback);
    }

    @Override
    public void doWork(@Nullable final ICallbackOfTask callbackForTask) {
        super.doWork(callbackForTask);

        String _pageName = null;
        if (_parameters != null) {
            if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.CONTEXT)) {
                _context = (Context)_parameters.get(ACEReducerForPlusAPIParamKey.CONTEXT);
            }
            if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.PAGE_NAME)) {
                _pageName = (String)_parameters.get(ACEReducerForPlusAPIParamKey.PAGE_NAME);
            }
        }

        ACEParametersForPlus _parametersForPlus = ACEParametersForPlus.getInstance();
        ACEParameterUtilForPlus _parameterUtilForPlus = ACEParameterUtilForPlus.getInstance();

        switch (_logSource) {
            case ACEPlusStaticConfig.ACEofAPIForPlus.DetailView:
            case ACEPlusStaticConfig.ACEofAPIForPlus.DetailViewWithPage: {
                if (_pageName != null) {
                    _parameterUtilForPlus.updateURLnEREF(_pageName);
                }
                else {
                    if (_context != null) {
                        _parameterUtilForPlus.updateURLnEREF(ACEParameterUtil.getContextName(_context));
                    }
                }

                String _pr = null;
                String _productCategory = null;
                String _productImageUrl = null;
                String _productName = null;
                String _productNumber = null;
                if (_parameters != null) {
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.PRODUCT_CATEGORY)) {
                        _productCategory = (String)_parameters.get(ACEReducerForPlusAPIParamKey.PRODUCT_CATEGORY);
                    }
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.PRODUCT_ImageURL)) {
                        _productImageUrl = (String)_parameters.get(ACEReducerForPlusAPIParamKey.PRODUCT_ImageURL);
                    }
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.PRODUCT_PRICE)) {
                        _pr = (String)_parameters.get(ACEReducerForPlusAPIParamKey.PRODUCT_PRICE);
                    }
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.PRODUCT_NUMBER)) {
                        _productNumber = (String)_parameters.get(ACEReducerForPlusAPIParamKey.PRODUCT_NUMBER);
                    }
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.PRODUCT_NAME)) {
                        _productName = (String)_parameters.get(ACEReducerForPlusAPIParamKey.PRODUCT_NAME);
                    }
                }
                _parametersForPlus.setCT(_productCategory);
                _parametersForPlus.setPD(_productName);
                _parametersForPlus.setPIU(_productImageUrl);
                _parametersForPlus.setPNO(_productNumber);
                _parametersForPlus.setPR(_pr);
                break;
            }
            case ACEPlusStaticConfig.ACEofAPIForPlus.InnerSearch:
            case ACEPlusStaticConfig.ACEofAPIForPlus.InnerSearchWithPage: {
                if (_pageName != null) {
                    _parameterUtilForPlus.updateURLnEREF(_pageName);
                }
                else {
                    if (_context != null) {
                        _parameterUtilForPlus.updateURLnEREF(ACEParameterUtil.getContextName(_context));
                    }
                }

                String _keyword = null;
                if (_parameters != null) {
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.KEYWORD)) {
                        _keyword = (String)_parameters.get(ACEReducerForPlusAPIParamKey.KEYWORD);
                    }
                }
                _parametersForPlus.setINKW(_keyword);
                break;
            }
            default:
                break;
        }

        // doWork 결과
        ACELog.d(TAG,
                String.format(
                        Locale.getDefault(),
                        "%d, doWork result _params: %s", this.getTaskHash(), _parameterUtilForPlus.toString()));

        if (callbackForTask != null) {
            callbackForTask.callback();
        }
    }

    @Override
    public void didWork() {
        ACENetworkAdapter networkAdapter = new ACENetworkAdapter();
        networkAdapter.setGetURL(new ACENetwork.OnGetURL() {
            @NonNull
            @Override
            public String getURL() {
                return ACEParameterUtilForPlus.getInstance().getParametersToURL(ACEStaticConfig.HTTP_METHOD.GET);
            }
        });
        networkAdapter.request(new IACENetworkParams() {
            @Override
            public void completed(@Nullable final ACENetworkResult response) {
                APIForCommerceOnPage.this.completed(response);
            }

            @Override
            public void failed(@Nullable final Throwable throwable) {
                APIForCommerceOnPage.this.failed(throwable);
            }
        });
    }

    @Override
    public void completed(@Nullable final ACENetworkResult response) {
        super.completed(response);
        ACELog.d(TAG,
                String.format(
                        Locale.getDefault(),
                        "%d, completed done", this.getTaskHash()));
        if (this._doneWorkCallback != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, Start doneWorkCallback: %s", this.getTaskHash(), this.getClass().getSimpleName()));

            try {
                JSONObject result = new JSONObject();
                result.put(ACEStaticConfig.ACELOG_JSON_KEY.TaskHash, String.valueOf(getTaskHash()));
                if (response != null) {
                    result.put("response", response.getsVariablesToJSONobject());
                }
                this._doneWorkCallback.completed(result);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void failed(@Nullable final Throwable throwable) {
        super.failed(throwable);
        if (this._doneWorkCallback != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, Start doneWorkCallback: %s", this.getTaskHash(), this.getClass().getSimpleName()));

            try {
                JSONObject result = new JSONObject();
                result.put(ACEStaticConfig.ACELOG_JSON_KEY.TaskHash, String.valueOf(getTaskHash()));
                if (throwable != null) {
                    result.put(ACEConstantCallbackKey_Failed_Cause, throwable.getCause().toString());
                }
                this._doneWorkCallback.failed(result);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void doneWork() {
        super.doneWork();
        ACELog.d(TAG, "in doneWork()");
        ACEParametersForPlus _parametersForPlus = ACEParametersForPlus.getInstance();

        // 공통 [S]
        _parametersForPlus.setEREF(null);
        // 공통 [E]

        // DetailView, DetailViewWithPage [S]
        _parametersForPlus.setCT(null);
        _parametersForPlus.setPD(null);
        _parametersForPlus.setPIU(null);
        _parametersForPlus.setPNO(null);
        _parametersForPlus.setPR(null);
        // DetailView, DetailViewWithPage [E]

        // InnerSearch, InnerSearchWithPage [S]
        _parametersForPlus.setINKW(null);
        // InnerSearch, InnerSearchWithPage [E]
    }
}
