package com.acecounter.android.acetm.acplus.parameter;

import android.content.Context;
import android.net.Uri;
import android.os.AsyncTask;
import android.text.TextUtils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.acplus.config.ACEPlusStaticConfig;
import com.acecounter.android.acetm.acplus.config.ACEPlusStaticConfig.ParamsPlusEnum_Key;
import com.acecounter.android.acetm.common.config.ACECommonStaticConfig;
import com.acecounter.android.acetm.common.config.ACEStaticConfig;
import com.acecounter.android.acetm.common.config.ACEStaticConfig.ACECONSTANT;
import com.acecounter.android.acetm.common.config.ACEStaticConfig.SESSION;
import com.acecounter.android.acetm.common.gms.AdvertisingIdClient;
import com.acecounter.android.acetm.common.logger.ACEDebugLog;
import com.acecounter.android.acetm.common.logger.ACEException;
import com.acecounter.android.acetm.common.logger.ACELog;
import com.acecounter.android.acetm.common.parameter.ACEParameterUtil;
import com.acecounter.android.acetm.common.parameter.IACEParameterUtil;
import com.acecounter.android.acetm.common.parameter.ICallbackOfTask;
import com.acecounter.android.acetm.common.policy.ACEPolicyParameters;
import com.acecounter.android.acetm.common.queue.ACEQueueManager;
import com.acecounter.android.acetm.common.queue.ACEQueueManagerFactory;
import com.acecounter.android.acetm.common.queue.ACEWaitQueueManager;
import com.acecounter.android.acetm.common.util.StringUtils;
import com.acecounter.android.acetm.common.util.URLUtils;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public final class ACEParameterUtilForPlus implements IACEParameterUtil {
    static final private String TAG = ACEParameterUtilForPlus.class.getSimpleName();

    private Context _context;

    private ACEParameterUtilForPlus() { }

    //region 싱글턴
    private static class Singleton {
        private static final ACEParameterUtilForPlus INSTANCE = new ACEParameterUtilForPlus();
    }

    @NonNull
    public static ACEParameterUtilForPlus getInstance() {
        return ACEParameterUtilForPlus.Singleton.INSTANCE;
    }
    //endregion 싱글턴

    /**
     * _params 들을 초기화하고 SDK 필수값을 채움
     */
    public synchronized void initParameters(@NonNull final Context context,
                                            @NonNull final ICallbackOfTask callback) {
        _context = context;
        ACEParametersForPlus.getInstance().initParameters(_context);
        setFixedParameters(callback);
    }

    private synchronized void setFixedParameters(@NonNull final ICallbackOfTask callback) {
        loadUniqueKeyForSDK();

        final ACEParametersForPlus _parametersForPlus = ACEParametersForPlus.getInstance();

        _parametersForPlus.setACI(ACECommonStaticConfig.getKey());
        increaseAVC();
        _parametersForPlus.setBV(null);
        _parametersForPlus.setBZ(ACEParameterUtil.getApplicationName(_context));
        _parametersForPlus.setCK(0);
        _parametersForPlus.setCPY(ACEPolicyParameters.getInstance().getCpPrivate());
        _parametersForPlus.setDAV(ACEParameterUtil.getApplicationVersion(_context));
        _parametersForPlus.setDIM(ACEParameterUtil.getResolution(_context));
        _parametersForPlus.setDMN(ACEParameterUtil.getDeviceNormalizeName());
        _parametersForPlus.getDSC();
        _parametersForPlus.setDTC(ACEParameterUtil.getNetworkProvider(_context));
        _parametersForPlus.setIsNeedSetNewSession(false);
        _parametersForPlus.setPATCH(ACECONSTANT.PATCH);
        _parametersForPlus.setOS(ACEParameterUtil.getVersion());
        _parametersForPlus.getOVT();
        _parametersForPlus.setPCM(ACEPlusStaticConfig.SOURCE.ANDROID);
        _parametersForPlus.setREL(0);
        _parametersForPlus.setSV(ACEParameterUtil.getSdkVersion());
        _parametersForPlus.getUID();
        _parametersForPlus.setUL(ACEParameterUtil.getLanguage());

        setToggleParameters();
        loadDID(callback);
    }

    /**
     * SDK 초기화 후 최초 로그 발생시 업데이트한 뒤에는 바뀌지 않는 파라미터들 값 채움
     */
    private synchronized void setToggleParameters() {
        setNewSession();
        long _aet = ACEParametersForPlus.getInstance().getAET();
        if (_aet > 0) {
            _aet /= 1000;
        }
        ACEParametersForPlus.getInstance().setAVT(_aet);
        ACEParametersForPlus.getInstance().setRDM(ACECONSTANT.DIRECT);
    }

    //region except get url key
    @Override
    public boolean isExceptKeyInstance(@NonNull String key) {
        return ACEParameterUtilForPlus.isExceptKey(key);
    }

    private static boolean isExceptKey(@NonNull String key) {
        switch (key) {
            case ParamsPlusEnum_Key.ACP_PUSH:
            case ParamsPlusEnum_Key.AS:
            case ParamsPlusEnum_Key.GSCK:
                return true;
        }

        return false;
    }
    //endregion except get url key

    //region AET
    public long getAET() throws ClassCastException {
        return ACEParametersForPlus.getInstance().getAET();
    }

    public void setAET(long value) throws ClassCastException {
        ACEParametersForPlus.getInstance().setAET(value);
    }

    public void updateAETnAVT() throws ClassCastException {
        long _aet = ACEParametersForPlus.getInstance().getAET();
        if (_aet > 0) {
            _aet /= 1000;
        }

        final ACEParametersForPlus _parametersForPlus = ACEParametersForPlus.getInstance();

        _parametersForPlus.setAVT(_aet);
        _parametersForPlus.setAET(
                System.currentTimeMillis() + ACEPolicyParameters.getInstance().getTimeInterval());
    }
    //endregion AET

    //region AGE
    int getAGEForPure() {
        return ACEParametersForPlus.getInstance().getAGE();
    }

    void setAGEForPure(int age) {
        ACEParametersForPlus.getInstance().setAGE(age);
    }

    void setAGEForStore(int age) {
        ACEParametersForPlus.getInstance().setAGE(age + 4);
    }

    void setAGEForSend(int age) {
        ACEParametersForPlus.getInstance().setAGE_nonInStorage(age);
    }
    //endregion AGE

    //region AVC
    private void increaseAVC() throws ClassCastException {
        final ACEParametersForPlus _parametersForPlus = ACEParametersForPlus.getInstance();

        int beforeValue = _parametersForPlus.getAVC();
        _parametersForPlus.setAVC(beforeValue + 1);
    }
    //endregion AVC

    //region CID
    public void loadCID() {
        String _cid = ACEParametersForPlus.getInstance().getCID();
        if (TextUtils.isEmpty(_cid)) {
            _cid = ACEPolicyParameters.getInstance().getCpCid();
            if (!TextUtils.isEmpty(_cid)) {
                ACELog.d(TAG, "정책 서버에서 수신한 cid 로 업데이트 합니다.");
                ACEParametersForPlus.getInstance().setCID(_cid);
            }
            else {
                _cid = "";
            }
        }
        ACELog.i(TAG, "cid: " + _cid);
    }
    //endregion CID

    //region DID
    void loadDID(@Nullable final ICallbackOfTask callback) {
        final ACEParametersForPlus _parametersForPlus = ACEParametersForPlus.getInstance();

        _parametersForPlus.setDID(_parametersForPlus.getDeviceId());
        AsyncTask.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    AdvertisingIdClient.AdInfo advertisingIdInfo = AdvertisingIdClient.getAdvertisingIdInfo(_context);
                    if (!advertisingIdInfo.isLimitAdTrackingEnabled()) {
                        _parametersForPlus.setDID(advertisingIdInfo.getId());
                    }
                }
                catch (Exception _ex) {
                    ACEDebugLog.wtf(TAG, new ACEException(_ex, "did 를 불러오는 과정에 예외 발생").toString());
                }
                finally {
                    if (callback != null) {
                        callback.callback();
                    }
                }
            }
        });
    }
    //endregion DID

    //region MT
    public int getMT() {
        return ACEParametersForPlus.getInstance().getMT();
    }

    public void setMT(int value) {
        ACEParametersForPlus.getInstance().setMT(value);
    }
    //endregion MT

    //region OVT
    public void saveOVTAtNow() throws ClassCastException {
        long now = System.currentTimeMillis() / 1000;
        ACEParametersForPlus.getInstance().setOVT_inStorage(now);
    }
    //endregion OVT

    //region override
    //region Common
    @Override
    public void setterForString(@NonNull String key, @Nullable String value) {
        if (StringUtils.isNull(value)) {
            value = "";
        }

        ACEParametersForPlus _parametersForPlus = ACEParametersForPlus.getInstance();
        switch (key) {
            case "cpy":
                _parametersForPlus.setCPY(value);
                break;
            case "gsck":
                _parametersForPlus.setGSCK(value);
                break;
        }
    }

    @Nullable
    @Override
    public String getterForString(@NonNull String key) {
        switch (key) {
            case "gsck":
                return ACEParametersForPlus.getInstance().getGSCK();
        }

        return null;
    }
    //endregion Common

    //region INSTALL_REFERRER
    @Override
    public void setReferrer(@NonNull Map<String, String> map) {
        ACEParametersForPlus _parametersForPlus = ACEParametersForPlus.getInstance();
        if (map.containsKey(ParamsPlusEnum_Key.AS)) {
            _parametersForPlus.setAS(map.get(ParamsPlusEnum_Key.AS));
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%s: %s", ParamsPlusEnum_Key.AS, map.get(ParamsPlusEnum_Key.AS)));
        }
        else {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "not contained %s key.", ParamsPlusEnum_Key.AS));
        }
        if (map.containsKey(ParamsPlusEnum_Key.MS)) {
            _parametersForPlus.setMS(map.get(ParamsPlusEnum_Key.MS));
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%s: %s", ParamsPlusEnum_Key.MS, map.get(ParamsPlusEnum_Key.MS)));
        }
        else {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "not contained %s key.", ParamsPlusEnum_Key.MS));
        }
        if (map.containsKey(ParamsPlusEnum_Key.TK)) {
            _parametersForPlus.setTK(map.get(ParamsPlusEnum_Key.TK));
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%s: %s", ParamsPlusEnum_Key.TK, map.get(ParamsPlusEnum_Key.TK)));
        }
        else {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "not contained %s key.", ParamsPlusEnum_Key.TK));
        }
        if (map.containsKey(ParamsPlusEnum_Key.GSCK)) {
            _parametersForPlus.setGSCK(map.get(ParamsPlusEnum_Key.GSCK));
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%s: %s", ParamsPlusEnum_Key.GSCK, map.get(ParamsPlusEnum_Key.GSCK)));
        }
        else {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "not contained %s key.", ParamsPlusEnum_Key.GSCK));
        }
//        ACEReducerForPlus.referrer(
//                map,
//                null);
    }

    @Nullable
    @Override
    public String getInstallReferrer() {
        @Nullable
        String value = null;
        try {
            value = ACEParametersForPlus.getInstance().getInstallReferrer();
        }
        catch (ClassCastException e) {
            value = null;
        }
        catch (Exception e) {
            value = null;
        }
        return value;
    }

    @Override
    public void setInstallReferrer(@Nullable String value) {
        ACEParametersForPlus.getInstance().setInstallReferrer(value);
    }
    //endregion INSTALL_REFERRER

    //region JSON, toString
    @Override
    public JSONObject getParamsToJSONobject() throws JSONException {
        return ACEParametersForPlus.getInstance().getParamsToJSONobject();
    }

    @Override
    public String toString() {
        try {
            return getParamsToJSONobject().toString(2);
        } catch (JSONException e) {
            ACEDebugLog.wtf(TAG, new ACEException(e, "getParamsToJSONobject().toString() 과정에 예외 발생").toString());
        }
        return super.toString();
    }
    //endregion JSON, toString

    //region parameter utils
    @Override
    public void loadUniqueKeyForSDK() {
        loadCID();
    }

    @Override
    public void setFirstLogParameters() {
        ACELog.d(TAG,
                String.format(
                        Locale.getDefault(),
                        "this.isFirstLog(): %b", this.isFirstLog()));
        if (this.isFirstLog()) {
            ACEParametersForPlus _parametersForPlus = ACEParametersForPlus.getInstance();
            if (TextUtils.isEmpty(_parametersForPlus.getTK())) {
                _parametersForPlus.setTK(ACEParameterUtilForPlus.makeFingerprint(_context));
                ACELog.d(TAG,
                        String.format(
                                Locale.getDefault(),
                                "tk: %s", _parametersForPlus.getTK()));
            }
            else {
                ACELog.d(TAG,
                        String.format(
                                Locale.getDefault(),
                                "else tk: %s", _parametersForPlus.getTK()));
            }
            _parametersForPlus.setEREF(ACECONSTANT.BOOKMARK);
            _parametersForPlus.setURL(ACECONSTANT.BOOKMARK);
        }
    }

    @Override
    public void setLogSource(int value) {
        ACEParametersForPlus.getInstance().setLOGSOURCE(value);
    }
    //endregion parameter utils

    //region request Header
    @Override
    public String getCookies() {
        return getGSCKForCookie();
    }
    //endregion request Header

    //region Session
    @Override
    public Boolean isFirstLog() {
        if (getSession() == SESSION.NEW) {
            return true;
        }
        return false;
    }

    @Override
    public void resetSessionAndParameterAfterSend() {
        resetSessionAndParameterAfterSendWithParams(null);
    }

    @Override
    public void resetSessionAndParameterAfterSendWithParams(@Nullable Map<String, Object> params) {
        if (isFirstLog()) {
            setKeepSession();
        }
        ACEParametersForPlus _parametersForPlus = ACEParametersForPlus.getInstance();
        _parametersForPlus.setTK(null);
        ACEParameterUtilForPlus.getInstance().setPackageNameAtRDM();
        _parametersForPlus.setPRMT(null);
        _parametersForPlus.setMS(null);
        _parametersForPlus.setAS(null);
    }

    @Override
    public void setNewSession() {
        ACEParametersForPlus _parametersForPlus = ACEParametersForPlus.getInstance();
        _parametersForPlus.setAVN(SESSION.NEW);
    }

    public void setNewSessionByIsNeedSetNewSession() {
        ACEParametersForPlus _parametersForPlus = ACEParametersForPlus.getInstance();
        if (_parametersForPlus.getIsNeedSetNewSession()) {
            ACELog.d(TAG, "Update new session.");

            _parametersForPlus.setRDM(ACECONSTANT.DIRECT);
            _parametersForPlus.setEREF(ACECONSTANT.BOOKMARK);
            setNewSession();

            _parametersForPlus.setIsNeedSetNewSession(false);
        }
    }

    @Override
    public synchronized int getSession() {
        ACEParametersForPlus _parametersForPlus = ACEParametersForPlus.getInstance();
        return _parametersForPlus.getAVN();
    }

    @Override
    public synchronized void setKeepSession() {
        ACEParametersForPlus _parametersForPlus = ACEParametersForPlus.getInstance();
        _parametersForPlus.setAVN(SESSION.KEEP);
    }
    //endregion Session

    //endregion override

    //region prmt
    private void setPrmt(@Nullable String argPrmt) {
        if (TextUtils.isEmpty(argPrmt)) {
            return;
        }
        argPrmt = argPrmt.replaceFirst("^\\?", "");
        ACEParametersForPlus _parametersForPlus = ACEParametersForPlus.getInstance();
        String prmt = _parametersForPlus.getPRMT().replaceFirst("^\\?", "");
        if (TextUtils.isEmpty(prmt)) {
            _parametersForPlus.setPRMT(String.format(Locale.getDefault(), "?%s", argPrmt));
        } else {
            _parametersForPlus.setPRMT(String.format(Locale.getDefault(), "?%s&%s", prmt, argPrmt));
        }
    }
    //endregion prmt

    //region RDM
    private void setPackageNameAtRDM() {
        ACEParametersForPlus.getInstance().setRDM(_context.getPackageName());
    }
    //endregion RDM

    //region UID
    public String getUID() throws ClassCastException {
        return ACEParametersForPlus.getInstance().getUID();
    }

    public void setUID(@NonNull String value) throws ClassCastException {
        ACEParametersForPlus.getInstance().setUID(value);
    }
    //endregion UID

    //region URL
    public String getParametersToURL(@NonNull @ACEStaticConfig.HTTP_METHOD String method) {
        Uri.Builder builder = Uri.parse(ACEPolicyParameters.getInstance().getCpDomain()).buildUpon();
        if (method.equals(ACEStaticConfig.HTTP_METHOD.GET)) {
            try {
                JSONObject _params = getParamsToJSONobject();
                Iterator keys = _params.keys();

                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    if (!ACEParameterUtilForPlus.isExceptKey(key)) {
                        builder.appendQueryParameter(key, _params.getString(key));
                    }
                }
            }
            catch (JSONException e) {
                ACEDebugLog.wtf(TAG, new ACEException(e, "JSONObject to GET URL 과정에 예외 발생").toString());
            }
        }

        return builder.toString();
    }

    public void setURL(@NonNull String value) throws ClassCastException {
        ACEParametersForPlus.getInstance().setURL(value);
    }

    public void updateURLnEREF(@NonNull String pageName) throws ClassCastException {
        ACEParametersForPlus.getInstance().setEREF(
                ACEParametersForPlus.getInstance().getURL());
        ACEParametersForPlus.getInstance().setURL(
                String.format(Locale.getDefault(), "%s/%s", _context.getPackageName(), pageName));
    }
    //endregion URL

    //region User Information
    public void getUserInformation() throws ClassCastException {
        ACEParametersForPlus _parametersForPlus = ACEParametersForPlus.getInstance();
        _parametersForPlus.getMT();
        _parametersForPlus.getAGE();
        _parametersForPlus.getGD();
        _parametersForPlus.getUD1();
        _parametersForPlus.getUD2();
        _parametersForPlus.getUD3();
        _parametersForPlus.getUD4();
        _parametersForPlus.getUD5();
    }
    //endregion User Information

    //region Utils
    @NonNull
    public String getGSCKForCookie() {
        return String.format(
                Locale.getDefault(),
                "%s=%s;", ACEStaticConfig.LOG.REQUEST_GSCK, ACEParametersForPlus.getInstance().getGSCK());
    }

    public void setPushParameters() {
        ACEParametersForPlus _parametersForPlus = ACEParametersForPlus.getInstance();
        String acpPush = _parametersForPlus.getACP_PUSH();
        if (!TextUtils.isEmpty(acpPush)) {
            this.setNewSessionByIsNeedSetNewSession();
            this.setPrmt(acpPush);
            _parametersForPlus.setACP_PUSH(null);
            _parametersForPlus.setTK(null);
        }
    }

    @NonNull
    private static String makeFingerprint(@NonNull Context context) {
        String deviceNormalizeName = ACEParameterUtil.getDeviceNormalizeName();
        String ip = ACEParameterUtil.getIpAddress().replaceAll("\\.", "_");
        String language = ACEParameterUtil.getLanguage().toUpperCase(Locale.getDefault());
        String osName = ACEParameterUtil.getOS();
        long installTime = ACEParameterUtil.getInstallUnixTimeStamp(context);
        return String.format(Locale.getDefault(),
                "FP:%s.%s.%s.%d.%s",
                deviceNormalizeName, osName, ip, installTime, language);
    }
    //endregion Utils

    //region converter
    @NonNull
    public static String convertJsonToGetURL(@Nullable JSONObject jsonObject) {
        return URLUtils.convertFailedLogJsonToGetURL(ACEStaticConfig.HTTP_METHOD.GET, jsonObject);
    }
    //endregion converter

    //region JSON, toString
    @Nullable
    public String getSingleUsePvParametersWithPageNameStylePlain(int identifier,
                                                                 @NonNull String pageName) throws JSONException {
        JSONObject _json = getSingleUsePvParametersWithPageNameStyleJson(identifier, pageName);
        return ACEParameterUtil.convertJSONToGetURL(_json);
    }

    @NonNull
    public JSONObject getSingleUsePvParametersWithPageNameStyleJson(int identifier,
                                                                    @NonNull String pageName) throws JSONException {
        JSONObject _json = getSingleUsePvParametersJSONObjectWithPageName(pageName);
        _json.put(ParamsPlusEnum_Key.LOGSOURCE, identifier);
        return _json;
    }

    @NonNull
    private JSONObject getSingleUsePvParametersJSONObjectWithPageName(@NonNull String pageName) throws JSONException {
        ACEParametersForPlus _parameters = ACEParametersForPlus.getInstance();

        JSONObject _json = _parameters.getParamsToJSONobject();

        long _aet = _parameters.getAET();
        if (_aet > 0) {
            _aet /= 1000;
        }
        _json.put(ParamsPlusEnum_Key.AVT, _aet);

        _json.put(ParamsPlusEnum_Key.ACM, ACEPlusStaticConfig.ParamsPlusEnum_ACM.SITE);
        _json.put(ParamsPlusEnum_Key.AEM, ACEPlusStaticConfig.ParamsPlusEnum_AEM.PV);
        long _newAet = System.currentTimeMillis() + ACEPolicyParameters.getInstance().getTimeInterval();
        _json.put(ParamsPlusEnum_Key.AET, _newAet);
        _parameters.setAET(_newAet);
        _json.put(ParamsPlusEnum_Key.AGE, _parameters.getAGE());

        ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (queueManagerFactory != null) {
            ACEQueueManager queueManger = queueManagerFactory.getQueueManager();
            if (queueManger instanceof ACEWaitQueueManager) {
                int countTaskInWatingQueue = ((ACEWaitQueueManager) queueManger).count();
                if (countTaskInWatingQueue > 0) {
                    _json.put(ParamsPlusEnum_Key.AVN, SESSION.KEEP);
                } else {
                    _json.put(ParamsPlusEnum_Key.AVN, getSession());
                }
            } else {
                _json.put(ParamsPlusEnum_Key.AVN, getSession());
            }
        }

        _json.put(ParamsPlusEnum_Key.EREF, _parameters.getURL());

        _json.put(ParamsPlusEnum_Key.GD, _parameters.getGD());
        _json.put(ParamsPlusEnum_Key.MT, _parameters.getMT());

        _json.put(ParamsPlusEnum_Key.PRMT, _parameters.getPRMT());
        _json.put(ParamsPlusEnum_Key.RND, (int) (Math.random() * 100000000));

        if (_json.getInt(ParamsPlusEnum_Key.AVN) == SESSION.NEW) {
            if (TextUtils.isEmpty(_parameters.getTK())) {
                _json.put(ParamsPlusEnum_Key.TK, ACEParameterUtilForPlus.makeFingerprint(_context));
            }
            else {
                _json.put(ParamsPlusEnum_Key.TK, _parameters.getTK());
            }
        }
        else {
            if (!TextUtils.isEmpty(_parameters.getTK())) {
                _json.put(ParamsPlusEnum_Key.TK, _parameters.getTK());
            }
        }

        _json.put(ParamsPlusEnum_Key.UD1, _parameters.getUD1());
        _json.put(ParamsPlusEnum_Key.UD2, _parameters.getUD2());
        _json.put(ParamsPlusEnum_Key.UD3, _parameters.getUD3());
        _json.put(ParamsPlusEnum_Key.UD4, _parameters.getUD4());
        _json.put(ParamsPlusEnum_Key.UD5, _parameters.getUD5());
        _json.put(ParamsPlusEnum_Key.UL, _parameters.getUL());

        Context _context = ACECommonStaticConfig.getContext();
        pageName = StringUtils.onlyLetteringAtStartIndex(pageName);
        if (_context != null) {
            _json.put(
                    ParamsPlusEnum_Key.URL,
                    String.format(Locale.getDefault(), "%s/%s", _context.getPackageName(), pageName));
        }

        return _json;
    }
    //endregion JSON, toString
}
