package com.acecounter.android.acetm.acplus.controltower;

import com.acecounter.android.acetm.common.config.ACECommonStaticConfig;
import com.acecounter.android.acetm.common.controltower.ACEControlTower;
import com.acecounter.android.acetm.common.logger.ACELog;
import com.acecounter.android.acetm.common.queue.ACEQueueManager;
import com.acecounter.android.acetm.common.queue.ACEQueueManagerFactory;
import com.acecounter.android.acetm.common.queue.ACEWaitQueueManager;

public final class ACEControlTowerForPlus extends ACEControlTower {
    private static final String TAG = ACEControlTowerForPlus.class.getSimpleName();

    @Override
    public synchronized void setInstallReferrerWaitDone(Boolean isInstallReferrerDone) {
        if (isInstallReferrerDone && getIsSDKEnabled()) {
            ACELog.d(TAG, "Confirmed receive policy.");
            ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
            if (queueManagerFactory != null) {
                ACEQueueManager queueManger = queueManagerFactory.getQueueManager();
                queueManger.loadFailLogs();
                if (queueManger instanceof ACEWaitQueueManager) {
                    ACELog.d(TAG, "request clean waiting queue.");
                    ((ACEWaitQueueManager) queueManger).enqueueStop();
                }
                else {
                    ACELog.d(TAG, "not is waiting queue.");
                }
            }
        }
        else if (!getIsSDKEnabled()) {
            ACELog.d(TAG, "Confirmed disabled SDK.");
        }
        else if (isInstallReferrerDone) {
            ACELog.d(TAG, "not confirmed receive policy.");
        }
        this._isInstallReferrerDone = isInstallReferrerDone;
    }

    @Override
    public synchronized void setIsCompletePolicy(Boolean isCompletePolicy,
                                                 Boolean isSucceedRequestPolicy) {
        ACELog.d(TAG, "params isCompletePolicy: " + isCompletePolicy +
                ", isSucceedRequestPolicy: " + isSucceedRequestPolicy);

        if (isDisabled()) {
            return;
        }

        if (isCompletePolicy && isSucceedRequestPolicy && getInstallReferrerWaitDone()) {
            ACELog.d(TAG, "install referrer is timeout or received.");

            ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
            if (queueManagerFactory != null) {
                ACEQueueManager queueManger = queueManagerFactory.getQueueManager();
                queueManger.loadFailLogs();
                ACELog.d(TAG, "request clean waiting queue.");
                ACEWaitQueueManager.getInstance().enqueueStop();
            }
        }
        else if (isCompletePolicy &&
                isSucceedRequestPolicy) {
            ACELog.d(TAG, "waiting install referrer.");
        }
        else if (!isSucceedRequestPolicy) {
            ACELog.d(TAG, "failed receive policy will disable SDK.");
        }

        if (!isSucceedRequestPolicy) {
            ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
            if (queueManagerFactory != null) {
                ACEQueueManager queueManger = queueManagerFactory.getQueueManager();
                queueManger.dequeue();
            }

            this._isSDKEnabled = isSucceedRequestPolicy;
        }
        this._isCompletePolicy = isCompletePolicy;
    }
}
