package com.acecounter.android.acetm.acone.parameter;

import android.text.TextUtils;

import androidx.annotation.Nullable;

import com.acecounter.android.acetm.ICallbackOfACE;
import com.acecounter.android.acetm.acone.config.ACEOneStaticConfig.ACEReducerForOneAPIParamKey;
import com.acecounter.android.acetm.common.config.ACEStaticConfig;
import com.acecounter.android.acetm.common.logger.ACELog;
import com.acecounter.android.acetm.common.parameter.ICallbackOfTask;
import com.acecounter.android.acetm.common.parameter.Task;
import com.acecounter.android.acetm.common.policy.ACEPolicyParameterUtil;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import static com.acecounter.android.acetm.common.config.ACEPublicStaticConfig.ACEConstantCallbackKey_Data;

public final class APIForHybrid extends Task {
    private static final String TAG = APIForHybrid.class.getSimpleName();

    @Nullable
    private ConcurrentHashMap<String, Object> _parameters;

    APIForHybrid(final int logSource,
                 @Nullable Map<String, Object> parameters,
                 @Nullable ICallbackOfACE doneWorkCallback) {
        super(logSource, doneWorkCallback);
        if (parameters != null) {
            _parameters = new ConcurrentHashMap<>();
            _parameters.putAll(parameters);
        }
    }

    @Override
    public void doWork(@Nullable final ICallbackOfTask callbackForTask) {
        super.doWork(callbackForTask);

        JSONObject _jsonObject = null;
        if (_parameters != null) {
            if (_parameters.containsKey(ACEReducerForOneAPIParamKey.JSON_OBJECT)) {
                _jsonObject = (JSONObject) _parameters.get(ACEReducerForOneAPIParamKey.JSON_OBJECT);
            }
        }

        try {
            int resultCode = 200;
            JSONObject _result = new JSONObject();
            _result.put(ACEStaticConfig.ACELOG_JSON_KEY.TaskHash, String.valueOf(getTaskHash()));
            if (_jsonObject != null) {
                String type = _jsonObject.getString("type");
                if (!TextUtils.isEmpty(type)) {
                    switch (type) {
                        case "policy": {
                            JSONObject _data = ACEPolicyParameterUtil.getInstance().getParamsToJSONobject();
                            ACELog.d(TAG, "information policy: " + _data.toString(2));
                            _result.put("data", _data);
                            break;
                        }
                        case "stvt": {
                            ACEParameterUtilForOne.getInstance().loadST();
                            JSONObject _st = ACEParametersForOne.getInstance().getST().getJSONObjectSimpleStyle();
                            ACEParameterUtilForOne.getInstance().loadVT();
                            JSONObject _vt = ACEParametersForOne.getInstance().getVT().getJSONObjectSimpleStyle();
                            JSONObject _resultSTVTBuilder = new JSONObject();
                            _resultSTVTBuilder.put("st", _st);
                            _resultSTVTBuilder.put("vt", _vt);
                            _result.put("data", _resultSTVTBuilder);
                            break;
                        }
                        default: {
                            JSONObject _resultReasonBuilder = new JSONObject();
                            _resultReasonBuilder.put("reason", "not implementation type.");
                            _result.put("data", _resultReasonBuilder);
                            resultCode = -20002;
                            break;
                        }
                    }
                }
                else {
                    JSONObject _resultReasonBuilder = new JSONObject();
                    _resultReasonBuilder.put("reason", "type is empty.");
                    _result.put("data", _resultReasonBuilder);
                    resultCode = -20005;
                }
            }

            if (callbackForTask != null) {
                callbackForTask.callback();
            }

            _result.put("resultCode", resultCode);

            if (this._doneWorkCallback != null && resultCode == 200) {
                ACELog.d(TAG, String.format(Locale.getDefault(), "%d, Start doneWorkCallback::completed", getTaskHash()));
                _result.put("response", "done");
                this._doneWorkCallback.completed(_result);
            }
            else if (this._doneWorkCallback != null) {
                ACELog.d(TAG, String.format(Locale.getDefault(), "%d, Start doneWorkCallback::failed", getTaskHash()));
                _result.put("response", "fail");
                this._doneWorkCallback.failed(_result);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void didWork() {
        super.didWork();
    }
}
