package com.acecounter.android.acetm.acone.parameter;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.ACProduct;
import com.acecounter.android.acetm.ICallbackOfACE;
import com.acecounter.android.acetm.acone.config.ACEOneStaticConfig;
import com.acecounter.android.acetm.acone.config.ACEOneStaticConfig.ACEReducerForOneAPIParamKey;
import com.acecounter.android.acetm.common.config.ACEStaticConfig;
import com.acecounter.android.acetm.common.http.ACENetwork;
import com.acecounter.android.acetm.common.http.ACENetworkAdapter;
import com.acecounter.android.acetm.common.http.ACENetworkResult;
import com.acecounter.android.acetm.common.http.IACENetworkParams;
import com.acecounter.android.acetm.common.logger.ACELog;
import com.acecounter.android.acetm.common.parameter.ICallbackOfTask;
import com.acecounter.android.acetm.common.util.ACEProductUtil;
import com.acecounter.android.acetm.common.util.StringUtils;
import com.acecounter.android.acetm.common.util.TypeUtil;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import static com.acecounter.android.acetm.common.config.ACEPublicStaticConfig.ACEConstantCallbackKey_Failed_Cause;

public final class APIForBuy extends APIForPL {
    final private String TAG = APIForBuy.class.getSimpleName();

    @Nullable
    protected String _orderNumber;
    @Nullable
    protected String _payMethodName;
    @NonNull
    protected List<ACProduct> _products;

    APIForBuy(int logSource,
              @Nullable Map<String, Object> parameters,
              @Nullable ICallbackOfACE doneWorkCallback) {
        super(logSource, parameters, doneWorkCallback);
        _products = new ArrayList<>();
    }

    @Override
    public void doWork(@Nullable final ICallbackOfTask callbackForTask) {
        super.doWork(callbackForTask);

        if (_parameters != null) {
            if (_parameters.containsKey(ACEReducerForOneAPIParamKey.ORDER_NUMBER)) {
                _orderNumber = (String)_parameters.get(ACEReducerForOneAPIParamKey.ORDER_NUMBER);
            }
            if (_parameters.containsKey(ACEReducerForOneAPIParamKey.PAYMENT_METHOD)) {
                _payMethodName = (String)_parameters.get(ACEReducerForOneAPIParamKey.PAYMENT_METHOD);
            }
            if (_parameters.containsKey(ACEReducerForOneAPIParamKey.PRODUCT)) {
                Object __products = _parameters.get(ACEReducerForOneAPIParamKey.PRODUCT);
                if (__products != null && TypeUtil.isCollection(__products)) {
                    List<?> list = TypeUtil.convertObjectToList(__products);
                    for (Object item : list) {
                        if (item instanceof ACProduct) {
                            _products.add((ACProduct)item);
                        }
                    }
                }
            }
        }

        ACEParameterUtilForOne _parameterUtilForOne = ACEParameterUtilForOne.getInstance();

        switch (_logSource) {
            case ACEOneStaticConfig.ACEofAPIForOne.Buy: {
                _parameterUtilForOne.setBuyMode(ACEOneStaticConfig.IACBuyMode.Order);
                _parameterUtilForOne.setOrderNumber(_orderNumber);
                _parameterUtilForOne.setPay(_payMethodName);

                @NonNull String _productsToString = ACEProductUtil.getProductQueryForOne(_products, _logSource);
                _parameterUtilForOne.setProduct(_productsToString);

                // update BuyTimeTS [S]
                @Nullable Date _date = ACEParameterUtilForOne.getInstance().getGetTS();
                @Nullable String _6RandomSuffix = ACEParameterUtilForOne.getInstance().getGetTS6RandomSuffix();

                if (_date != null) {
                    ACELog.d(TAG,
                            String.format(
                                    Locale.getDefault(),
                                    "%d, _date: %s, _6RandomSuffix:%s", this.getTaskHash(), String.valueOf(_date.getTime()), _6RandomSuffix));
                }
                else {
                    ACELog.d(TAG, "_date is null");
                }

                if (_date != null && !StringUtils.isNull(_6RandomSuffix)) {
                    ACELog.d(TAG,
                            String.format(
                                    Locale.getDefault(),
                                    "%d, buytime 을 업데이트 합니다.", this.getTaskHash()));
                    ACEParameterUtilForOne.getInstance().setBuyTimeTSAtObject(
                            assignWillUpdateVt(),
                            _date,
                            _6RandomSuffix);
                }
                // update BuyTimeTS [E]

                // update BuyCount [S]
                int _buyCount = ACEParameterUtilForOne.getInstance().getBuyCount();
                ACEParameterUtilForOne.getInstance().setBuyCountAtObject(
                        assignWillUpdateVt(),
                        _buyCount + 1);
                // update BuyCount [E]
                break;
            }
            default:
                break;
        }

        // doWork 결과
        ACELog.d(TAG,
                String.format(
                        Locale.getDefault(),
                        "%d, doWork result _params: %s", this.getTaskHash(), _parameterUtilForOne.toString()));
        if (callbackForTask != null &&
                this.getClass().getSimpleName().equalsIgnoreCase(TAG)) {
            callbackForTask.callback();
        }
        else if (callbackForTask != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, class name: %s", this.getTaskHash(), this.getClass().getSimpleName()));
        }
    }

    @Override
    public void didWork() {
        ACENetworkAdapter networkAdapter = new ACENetworkAdapter();
        networkAdapter.setGetURL(new ACENetwork.OnGetURL() {
            @NonNull
            @Override
            public String getURL() {
                return ACEParameterUtilForOne.getInstance().getParametersToURL(ACEStaticConfig.HTTP_METHOD.GET);
            }
        });
        networkAdapter.request(new IACENetworkParams() {
            @Override
            public void completed(@Nullable final ACENetworkResult response) {
                APIForBuy.this.completed(response);
            }

            @Override
            public void failed(@Nullable final Throwable throwable) {
                APIForBuy.this.failed(throwable);
            }
        });
    }

    @Override
    public void completed(@Nullable final ACENetworkResult response) {
        super.completed(response);
        ACELog.d(TAG,
                String.format(
                        Locale.getDefault(),
                        "%d, completed done", this.getTaskHash()));
        if (this._doneWorkCallback != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, Start doneWorkCallback: %s", this.getTaskHash(), this.getClass().getSimpleName()));

            try {
                JSONObject result = new JSONObject();
                result.put(ACEStaticConfig.ACELOG_JSON_KEY.TaskHash, String.valueOf(getTaskHash()));
                if (response != null) {
                    result.put("response", response.getsVariablesToJSONobject());
                }
                this._doneWorkCallback.completed(result);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        else {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, _doneWorkCallback is null", this.getTaskHash()));
        }
    }

    @Override
    public void failed(@Nullable final Throwable throwable) {
        super.failed(throwable);
        if (this._doneWorkCallback != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, Start doneWorkCallback: %s", this.getTaskHash(), this.getClass().getSimpleName()));

            try {
                JSONObject result = new JSONObject();
                result.put(ACEStaticConfig.ACELOG_JSON_KEY.TaskHash, String.valueOf(getTaskHash()));
                if (throwable != null) {
                    result.put(ACEConstantCallbackKey_Failed_Cause, throwable.getCause().toString());
                }
                this._doneWorkCallback.failed(result);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        else {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, _doneWorkCallback is null", this.getTaskHash()));
        }
    }

    @Override
    public void doneWork() {
        super.doneWork();

        ACELog.d(TAG, "in doneWork()");
        ACEParameterUtilForOne _parameterUtilForOne = ACEParameterUtilForOne.getInstance();
        // Buy [S]
        _parameterUtilForOne.clearBuyMode();
        _parameterUtilForOne.clearPay();
        _parameterUtilForOne.clearOrderNumber();
        _parameterUtilForOne.clearProduct();
        // Buy [E]
    }
}
