package com.acecounter.android.acetm.acone.parameter;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.ICallbackOfACE;
import com.acecounter.android.acetm.acone.config.ACEOneStaticConfig;
import com.acecounter.android.acetm.acone.config.ACEOneStaticConfig.ACEReducerForOneAPIParamKey;
import com.acecounter.android.acetm.common.config.ACEStaticConfig;
import com.acecounter.android.acetm.common.http.ACENetwork;
import com.acecounter.android.acetm.common.http.ACENetworkAdapter;
import com.acecounter.android.acetm.common.http.ACENetworkResult;
import com.acecounter.android.acetm.common.http.IACENetworkParams;
import com.acecounter.android.acetm.common.logger.ACELog;
import com.acecounter.android.acetm.common.parameter.ICallbackOfTask;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Locale;
import java.util.Map;

import static com.acecounter.android.acetm.common.config.ACEPublicStaticConfig.ACEConstantCallbackKey_Failed_Cause;

public final class APIForAppearProduct extends APIForPL {
    final private String TAG = APIForAppearProduct.class.getSimpleName();

    @Nullable
    protected String _productName;
    @Nullable
    protected String _productCategoryName;
    @Nullable
    protected String _productPrice;

    APIForAppearProduct(int logSource,
                @Nullable Map<String, Object> parameters,
                @Nullable ICallbackOfACE doneWorkCallback) {
        super(logSource, parameters, doneWorkCallback);
    }

    @Override
    public void doWork(@Nullable final ICallbackOfTask callbackForTask) {
        super.doWork(callbackForTask);

        if (_parameters != null) {
            if (_parameters.containsKey(ACEReducerForOneAPIParamKey.PRODUCT_NAME)) {
                _productName = (String)_parameters.get(ACEReducerForOneAPIParamKey.PRODUCT_NAME);
            }
            if (_parameters.containsKey(ACEReducerForOneAPIParamKey.PRODUCT_CATEGORY)) {
                _productCategoryName = (String)_parameters.get(ACEReducerForOneAPIParamKey.PRODUCT_CATEGORY);
            }
            if (_parameters.containsKey(ACEReducerForOneAPIParamKey.PRODUCT_PRICE)) {
                _productPrice = (String)_parameters.get(ACEReducerForOneAPIParamKey.PRODUCT_PRICE);
            }
        }

        ACEParameterUtilForOne _parameterUtilForOne = ACEParameterUtilForOne.getInstance();

        switch (_logSource) {
            case ACEOneStaticConfig.ACEofAPIForOne.AppearProduct: {
                _parameterUtilForOne.setProductName(_productName);
                _parameterUtilForOne.setProductCategoryName(_productCategoryName);
                _parameterUtilForOne.setProductPrice(_productPrice);
                break;
            }
            default:
                break;
        }

        // doWork 결과
        ACELog.d(TAG,
                String.format(
                        Locale.getDefault(),
                        "%d, doWork result _params: %s", this.getTaskHash(), _parameterUtilForOne.toString()));
        if (callbackForTask != null &&
                this.getClass().getSimpleName().equalsIgnoreCase(TAG)) {
            callbackForTask.callback();
        }
        else if (callbackForTask != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, class name: %s", this.getTaskHash(), this.getClass().getSimpleName()));
        }
    }

    @Override
    public void didWork() {
        ACENetworkAdapter networkAdapter = new ACENetworkAdapter();
        networkAdapter.setGetURL(new ACENetwork.OnGetURL() {
            @NonNull
            @Override
            public String getURL() {
                return ACEParameterUtilForOne.getInstance().getParametersToURL(ACEStaticConfig.HTTP_METHOD.GET);
            }
        });
        networkAdapter.request(new IACENetworkParams() {
            @Override
            public void completed(@Nullable final ACENetworkResult response) {
                APIForAppearProduct.this.completed(response);
            }

            @Override
            public void failed(@Nullable final Throwable throwable) {
                APIForAppearProduct.this.failed(throwable);
            }
        });
    }

    @Override
    public void completed(@Nullable final ACENetworkResult response) {
        super.completed(response);
        ACELog.d(TAG,
                String.format(
                        Locale.getDefault(),
                        "%d, completed done", this.getTaskHash()));

        if (this._doneWorkCallback != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, Start doneWorkCallback: %s", this.getTaskHash(), this.getClass().getSimpleName()));

            try {
                JSONObject result = new JSONObject();
                result.put(ACEStaticConfig.ACELOG_JSON_KEY.TaskHash, String.valueOf(getTaskHash()));
                if (response != null) {
                    result.put("response", response.getsVariablesToJSONobject());
                }
                this._doneWorkCallback.completed(result);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        else {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, _doneWorkCallback is null", this.getTaskHash()));
        }
    }

    @Override
    public void failed(@Nullable final Throwable throwable) {
        super.failed(throwable);
        if (this._doneWorkCallback != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, Start doneWorkCallback: %s", this.getTaskHash(), this.getClass().getSimpleName()));

            try {
                JSONObject result = new JSONObject();
                result.put(ACEStaticConfig.ACELOG_JSON_KEY.TaskHash, String.valueOf(getTaskHash()));
                if (throwable != null) {
                    result.put(ACEConstantCallbackKey_Failed_Cause, throwable.getCause().toString());
                }
                this._doneWorkCallback.failed(result);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        else {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, _doneWorkCallback is null", this.getTaskHash()));
        }
    }

    @Override
    public void doneWork() {
        super.doneWork();

        ACELog.d(TAG, "in doneWork()");
        ACEParameterUtilForOne _parameterUtilForOne = ACEParameterUtilForOne.getInstance();
        // AppearProduct [S]
        _parameterUtilForOne.clearProductName();
        _parameterUtilForOne.clearProductCategoryName();
        _parameterUtilForOne.clearProductPrice();
        // AppearProduct [E]
    }
}
