package com.acecounter.android.acetm.acone.parameter;

import android.text.TextUtils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.acone.config.ACEOneStaticConfig;
import com.acecounter.android.acetm.acone.config.ACEOneStaticConfig.ACOneConstantVt;
import com.acecounter.android.acetm.common.parameter.ACEParameterUtil;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

final public class ACEntityForVT {
    private final String TAG = ACEntityForVT.class.getSimpleName();

    private Map<String, Object> _dic;

    ACEntityForVT() {
        _dic = new TreeMap<>();
        _dic.put(ACOneConstantVt.KeyVTS, ACOneConstantVt.DefaultTS);
        _dic.put(ACOneConstantVt.KeyRandom6ForVTS, "");

        _dic.put(ACOneConstantVt.KeyVisitCount, 0);

        _dic.put(ACOneConstantVt.KeyBuyTimeTS, ACOneConstantVt.DefaultTS);
        _dic.put(ACOneConstantVt.KeyRandom6ForBuyTimeTS, "");

        _dic.put(ACOneConstantVt.KeyBuyCount, 0);

        _dic.put(ACOneConstantVt.KeyPcStamp, ACOneConstantVt.DefaultTS);
        _dic.put(ACOneConstantVt.KeyRandom6ForPcStamp, "");
    }

    ACEntityForVT(@Nullable ACEntityForVT value) {
        _dic = new TreeMap<>();
        if (value != null) {
            _dic.putAll(value.getMap());
        }
    }

    ACEntityForVT(@Nullable Map<String, Object> value) {
        _dic = new TreeMap<>();
        if (value != null) {
            _dic.putAll(value);
        }
    }

    //region query 관련
    @NonNull
    public String getAssembleParams() {
        @NonNull String _vTS = getVTSGoldMaster();
        int _visitCount = getVisitCount();
        @NonNull String _buyTimeTS = getBuyTimeTSGoldMaster();
        int _buyCount = getBuyCount();
        @NonNull String _pcStamp = getPcStampGoldMaster();

        return String.format(Locale.getDefault(), "%s|%d|%s|%d|%s", _vTS, _visitCount, _buyTimeTS, _buyCount, _pcStamp);
    }

    @NonNull
    public String getVTSGoldMaster() {
        StringBuilder _string = new StringBuilder();

        @Nullable
        String _vTS = getVTS();
        if (TextUtils.isEmpty(_vTS)) {
            _string.append(ACOneConstantVt.DefaultTS);
        }
        else {
            _string.append(_vTS);
        }

        String _random = getRandom6ForVTS();
        if (!TextUtils.isEmpty(_random)) {
            _string.append(_random);
        }

        return _string.toString();
    }

    @NonNull
    public String getBuyTimeTSGoldMaster() {
        StringBuilder _string = new StringBuilder();

        @Nullable
        String _buyTimeTS = getBuyTimeTS();
        if (TextUtils.isEmpty(_buyTimeTS)) {
            _string.append(ACOneConstantVt.DefaultTS);
        }
        else {
            _string.append(_buyTimeTS);
        }

        String _random = getRandom6ForBuyTimeTS();
        if (!TextUtils.isEmpty(_random)) {
            _string.append(_random);
        }

        return _string.toString();
    }

    @NonNull
    public String getPcStampGoldMaster() {
        StringBuilder _string = new StringBuilder();

        @Nullable
        String _pcStamp = getPcStamp();
        if (TextUtils.isEmpty(_pcStamp)) {
            _string.append(ACOneConstantVt.DefaultTS);
        }
        else {
            _string.append(_pcStamp);
        }

        String _random = getRandom6ForPcStamp();
        if (!TextUtils.isEmpty(_random)) {
            _string.append(_random);
        }

        return _string.toString();
    }
    //endregion query 관련

    //region setter/getter

    //region VTS
    @Nullable
    public String getVTS() {
        if (_dic.containsKey(ACOneConstantVt.KeyVTS)) {
            return (String)_dic.get(ACOneConstantVt.KeyVTS);
        }
        else {
            return null;
        }
    }

    public void setVTS(@Nullable String value) {
        if (!TextUtils.isEmpty(value)) {
            _dic.put(ACOneConstantVt.KeyVTS, value);
        }
    }

    @Nullable
    public Date getVTSWithDate() {
        String _string = getVTS();
        if (!TextUtils.isEmpty(_string)) {
            try {
                return new Date(Long.parseLong(_string));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        else {
            return null;
        }
    }

    public void setVTSWithDate(@Nullable Date value) {
        if (value != null) {
            String _string = String.valueOf(value.getTime());
            setVTS(_string);
        }
    }
    //endregion VTS

    //region VTS random
    @Nullable
    public String getRandom6ForVTS() {
        if (_dic.containsKey(ACOneConstantVt.KeyRandom6ForVTS)) {
            return (String)_dic.get(ACOneConstantVt.KeyRandom6ForVTS);
        }
        else {
            return null;
        }
    }

    public void setRandom6ForVTS(@Nullable String value) {
        if (!TextUtils.isEmpty(value)) {
            _dic.put(ACOneConstantVt.KeyRandom6ForVTS, value);
        }
    }
    //endregion VTS random

    //region VisitCount
    public int getVisitCount() {
        if (_dic.containsKey(ACOneConstantVt.KeyVisitCount)) {
            Integer value = (Integer)_dic.get(ACOneConstantVt.KeyVisitCount);
            if (value == null) {
                return 0;
            }
            else {
                return value;
            }
        }
        else {
            return 0;
        }
    }

    public void setVisitCount(Integer value) {
        if (value > ACEOneStaticConfig.ACOneConstantInteger.VtVisitCountMax) {
            value = ACEOneStaticConfig.ACOneConstantInteger.VtVisitCountMax;
        }
        _dic.put(ACOneConstantVt.KeyVisitCount, value);
    }
    //endregion VisitCount

    //region BuyTimeTS
    @Nullable
    public String getBuyTimeTS() {
        if (_dic.containsKey(ACOneConstantVt.KeyBuyTimeTS)) {
            return (String)_dic.get(ACOneConstantVt.KeyBuyTimeTS);
        }
        else {
            return null;
        }
    }

    public void setBuyTimeTS(@Nullable String value) {
        if (!TextUtils.isEmpty(value)) {
            _dic.put(ACOneConstantVt.KeyBuyTimeTS, value);
        }
    }

    @Nullable
    public Date getBuyTimeTSWithDate() {
        String _string = getBuyTimeTS();
        if (!TextUtils.isEmpty(_string)) {
            try {
                return new Date(Long.parseLong(_string));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        else {
            return null;
        }
    }

    public void setBuyTimeTSWithDate(@Nullable Date value) {
        if (value != null) {
            String _string = String.valueOf(value.getTime());
            setBuyTimeTS(_string);
        }
    }
    //endregion BuyTimeTS

    //region BuyTimeTS random
    @Nullable
    public String getRandom6ForBuyTimeTS() {
        if (_dic.containsKey(ACOneConstantVt.KeyRandom6ForBuyTimeTS)) {
            return (String)_dic.get(ACOneConstantVt.KeyRandom6ForBuyTimeTS);
        }
        else {
            return null;
        }
    }

    public void setRandom6ForBuyTimeTS(@Nullable String value) {
        if (!TextUtils.isEmpty(value)) {
            _dic.put(ACOneConstantVt.KeyRandom6ForBuyTimeTS, value);
        }
    }
    //endregion BuyTimeTS random

    //region BuyCount
    public int getBuyCount() {
        if (_dic.containsKey(ACOneConstantVt.KeyBuyCount)) {
            Integer value = (Integer)_dic.get(ACOneConstantVt.KeyBuyCount);
            if (value == null) {
                return 0;
            }
            else {
                return value;
            }
        }
        else {
            return 0;
        }
    }

    public void setBuyCount(Integer value) {
        if (value < 0) {
            value = 0;
        }
        _dic.put(ACOneConstantVt.KeyBuyCount, value);
    }
    //endregion BuyCount

    //region PcStamp
    @Nullable
    public String getPcStamp() {
        if (_dic.containsKey(ACOneConstantVt.KeyPcStamp)) {
            return (String)_dic.get(ACOneConstantVt.KeyPcStamp);
        }
        else {
            return null;
        }
    }

    public void setPcStamp(@Nullable String value) {
        if (!TextUtils.isEmpty(value)) {
            _dic.put(ACOneConstantVt.KeyPcStamp, value);
        }
    }

    @Nullable
    public Date getPcStampWithDate() {
        @Nullable
        String _string = getPcStamp();
        if (!TextUtils.isEmpty(_string)) {
            try {
                return new Date(Long.parseLong(_string));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        else {
            return null;
        }
    }

    public void setPcStampWithDate(@Nullable Date value) {
        if (value != null) {
            String _string = String.valueOf(value.getTime());
            setPcStamp(_string);
        }
    }

    public void setPcStampWhenNotStored() {
        @Nullable
        Date _pcStamp = getPcStampWithDate();
        if (_pcStamp == null || _pcStamp.getTime() == 0) {
            setPcStampWithDate(new Date());
            setRandom6ForPcStamp(ACEParameterUtil.getRandomNumber6Length());
        }
    }
    //endregion PcStamp

    //region PcStamp random
    @Nullable
    public String getRandom6ForPcStamp() {
        if (_dic.containsKey(ACOneConstantVt.KeyRandom6ForPcStamp)) {
            return (String)_dic.get(ACOneConstantVt.KeyRandom6ForPcStamp);
        }
        else {
            return null;
        }
    }

    public void setRandom6ForPcStamp(@Nullable String value) {
        if (!TextUtils.isEmpty(value)) {
            _dic.put(ACOneConstantVt.KeyRandom6ForPcStamp, value);
        }
    }
    //endregion PcStamp random

    public void setVT(@Nullable ACEntityForVT value) {
        if (value != null) {
            _dic.clear();

            setVTS(value.getVTS());
            setRandom6ForVTS(value.getRandom6ForVTS());

            setVisitCount(value.getVisitCount());

            setBuyTimeTS(value.getBuyTimeTS());
            setRandom6ForBuyTimeTS(value.getRandom6ForBuyTimeTS());

            setBuyCount(value.getBuyCount());

            setPcStamp(value.getPcStamp());
            setRandom6ForPcStamp(value.getRandom6ForPcStamp());
        }
    }

    public void setVTByMap(@Nullable Map<String, Object> value) {
        try {
            if (value != null) {
                _dic.clear();
                _dic.putAll(value);
            }
        } catch (UnsupportedOperationException ex) {
            ex.printStackTrace();
        }
    }
    //endregion setter/getter

    //region utils
    public Map<String, Object> getMap() {
        return _dic;
    }

    @NonNull
    public JSONObject getJSONObjectSimpleStyle() throws JSONException {
        @NonNull String _vTS = getVTSGoldMaster();
        int _visitCount = getVisitCount();
        @NonNull String _buyTimeTS = getBuyTimeTSGoldMaster();
        int _buyCount = getBuyCount();
        @NonNull String _pcStamp = getPcStampGoldMaster();

        JSONObject _json = new JSONObject();
        _json.put("vts", _vTS);
        _json.put("visitCount", _visitCount);
        _json.put("buyTimeTS", _buyTimeTS);
        _json.put("buyCount", _buyCount);
        _json.put("pcStamp", _pcStamp);

        return _json;
    }

    @NonNull
    public JSONObject getJSONObject() {
        JSONObject _json = new JSONObject();
        try {
            if (_dic.containsKey(ACOneConstantVt.KeyVTS)) {
                _json.put(ACOneConstantVt.KeyVTS, _dic.get(ACOneConstantVt.KeyVTS));
            }
            else {
                _json.put(ACOneConstantVt.KeyVTS, ACOneConstantVt.DefaultTS);
            }

            if (_dic.containsKey(ACOneConstantVt.KeyRandom6ForVTS)) {
                _json.put(ACOneConstantVt.KeyRandom6ForVTS, _dic.get(ACOneConstantVt.KeyRandom6ForVTS));
            }
            else {
                _json.put(ACOneConstantVt.KeyRandom6ForVTS, "");
            }

            if (_dic.containsKey(ACOneConstantVt.KeyVisitCount)) {
                _json.put(ACOneConstantVt.KeyVisitCount, _dic.get(ACOneConstantVt.KeyVisitCount));
            }
            else {
                _json.put(ACOneConstantVt.KeyVisitCount, 0);
            }

            if (_dic.containsKey(ACOneConstantVt.KeyBuyTimeTS)) {
                _json.put(ACOneConstantVt.KeyBuyTimeTS, _dic.get(ACOneConstantVt.KeyBuyTimeTS));
            }
            else {
                _json.put(ACOneConstantVt.KeyBuyTimeTS, ACOneConstantVt.DefaultTS);
            }

            if (_dic.containsKey(ACOneConstantVt.KeyRandom6ForBuyTimeTS)) {
                _json.put(ACOneConstantVt.KeyRandom6ForBuyTimeTS, _dic.get(ACOneConstantVt.KeyRandom6ForBuyTimeTS));
            }
            else {
                _json.put(ACOneConstantVt.KeyRandom6ForBuyTimeTS, "");
            }

            if (_dic.containsKey(ACOneConstantVt.KeyBuyCount)) {
                _json.put(ACOneConstantVt.KeyBuyCount, _dic.get(ACOneConstantVt.KeyBuyCount));
            }
            else {
                _json.put(ACOneConstantVt.KeyBuyCount, 0);
            }

            if (_dic.containsKey(ACOneConstantVt.KeyPcStamp)) {
                _json.put(ACOneConstantVt.KeyPcStamp, _dic.get(ACOneConstantVt.KeyPcStamp));
            }
            else {
                _json.put(ACOneConstantVt.KeyPcStamp, ACOneConstantVt.DefaultTS);
            }

            if (_dic.containsKey(ACOneConstantVt.KeyRandom6ForPcStamp)) {
                _json.put(ACOneConstantVt.KeyRandom6ForPcStamp, _dic.get(ACOneConstantVt.KeyRandom6ForPcStamp));
            }
            else {
                _json.put(ACOneConstantVt.KeyRandom6ForPcStamp, "");
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }

        return _json;
    }
    //endregion utils
}
