package com.acecounter.android.acetm.acone.parameter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.ACProduct;
import com.acecounter.android.acetm.ACSDK;
import com.acecounter.android.acetm.ICallbackOfACE;
import com.acecounter.android.acetm.acone.config.ACEOneStaticConfig;
import com.acecounter.android.acetm.acone.config.ACEOneStaticConfig.ACEReducerForOneAPIParamKey;
import com.acecounter.android.acetm.acone.config.ACEOneStaticConfig.ACEofAPIForOne;
import com.acecounter.android.acetm.acone.config.ACEOneStaticConfig.ParamsOneEnum_Key;
import com.acecounter.android.acetm.common.config.ACECommonStaticConfig;
import com.acecounter.android.acetm.common.config.ACEPublicStaticConfig;
import com.acecounter.android.acetm.common.config.ACEStaticConfig;
import com.acecounter.android.acetm.common.config.ACEStaticConfig.ACEofAPI;
import com.acecounter.android.acetm.common.controltower.ACEControlTower;
import com.acecounter.android.acetm.common.logger.ACEDebugLog;
import com.acecounter.android.acetm.common.logger.ACELog;
import com.acecounter.android.acetm.common.parameter.ACEParameterUtil;
import com.acecounter.android.acetm.common.parameter.Task;
import com.acecounter.android.acetm.common.queue.ACEQueueManagerFactory;
import com.acecounter.android.acetm.common.queue.ACESendQueueManager;
import com.acecounter.android.acetm.common.util.StringUtils;

import org.json.JSONObject;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ACEReducerForOne {
    private static final String TAG = ACEReducerForOne.class.getSimpleName();

    @Nullable
    private static Task reduce(final int logSource,
                               @Nullable ConcurrentHashMap<String, Object> parameters,
                               @Nullable ICallbackOfACE doneWorkCallback) {
        if (logSource != ACEofAPI.POLICY) {
            if (ACEControlTower.isCompletePolicy() && !ACEControlTower.isSDKEnabled()) {
                ACELog.i(TAG, "disabled SDK.");
                return null;
            }
        }

        switch (logSource) {
            case ACEofAPI.POLICY: {
                return new APIForPolicy(logSource, parameters, doneWorkCallback);
            }
            case ACEofAPIForOne.AppearProduct: {
                return new APIForAppearProduct(logSource, parameters, doneWorkCallback);
            }
            case ACEofAPIForOne.AddInCart:
            case ACEofAPIForOne.DeleteInCart: {
                return new APIForCart(logSource, parameters, doneWorkCallback);
            }
            case ACEofAPIForOne.Buy: {
                return new APIForBuy(logSource, parameters, doneWorkCallback);
            }
            case ACEofAPI.DeepLinkAtRunningApp:
            case ACEofAPI.PushAtRunningApp:
            case ACEofAPI.InstallReferrer: {
                return new APIForPushReferrerDeeplink(logSource, parameters, doneWorkCallback);
            }
            case ACEofAPIForOne.PlWithPage: {
                return new APIForPL(logSource, parameters, doneWorkCallback);
            }
            case ACEofAPIForOne.Leave:
            case ACEofAPIForOne.Join: {
                return new APIForJoinLeave(logSource, parameters, doneWorkCallback);
            }
            case ACEofAPIForOne.Login: {
                return new APIForLogin(logSource, parameters, doneWorkCallback);
            }
//            case ACEofAPIForOne.JSONParamsSend: {
////                return new APIForJSON(identifier, parameters, doneWorkCallback);
//            }
            case ACEofAPI.FailedLogSend: {
                return new APIForFailedLogJSON(logSource, parameters, doneWorkCallback);
            }
            case ACEofAPI.ScriptRequestTask: {
                return new APIForHybrid(logSource, parameters, doneWorkCallback);
            }
//            case ACEofAPI.onPageFinished:
//            case ACEofAPI.PluginGetPVParameters: {
////                return new APIForHybrid(identifier, parameters, doneWorkCallback);
//            }
            case ACEofAPIForOne.Search: {
                return new APIForSearch(logSource, parameters, doneWorkCallback);
            }
            case ACEofAPIForOne.TrackLinkEvent:
            case ACEofAPIForOne.TrackTelEvent: {
                return new APIForLinkTel(logSource, parameters, doneWorkCallback);
            }
            default:
                ACEDebugLog.wtf(TAG, "not implementation Task.");
        }
        return null;
    }

    //region Policy
    public static void requestPolicy(@Nullable final Context context,
                                     @Nullable ICallbackOfACE doneWorkCallback) {
        ConcurrentHashMap<String, Object> _map = new ConcurrentHashMap<>();
        if (context != null) {
            _map.put(ACEReducerForOneAPIParamKey.CONTEXT, context);
        }

        ACESendQueueManager.getInstance().enqueue(
                ACEReducerForOne.reduce(
                        ACEofAPI.POLICY,
                        _map,
                        doneWorkCallback));
    }
    //endregion Policy

    //region Commerce
    public static void appearProduct(@Nullable final Context context,
                                     @Nullable final String pageName,
                                     @Nullable final String productName,
                                     @Nullable final String productCategoryName,
                                     @Nullable final String productPrice,
                                     @Nullable ICallbackOfACE doneWorkCallback) {
        ConcurrentHashMap <String, Object> _map = new ConcurrentHashMap<>();
        if (context != null) {
            _map.put(ACEReducerForOneAPIParamKey.CONTEXT, context);
        }
        if (!StringUtils.isNull(pageName)) {
            _map.put(ACEReducerForOneAPIParamKey.PAGE_NAME, pageName);
        }
        if (!StringUtils.isNull(productName)) {
            _map.put(ACEReducerForOneAPIParamKey.PRODUCT_NAME, productName);
        }
        if (!StringUtils.isNull(productCategoryName)) {
            _map.put(ACEReducerForOneAPIParamKey.PRODUCT_CATEGORY, productCategoryName);
        }
        if (!StringUtils.isNull(productPrice)) {
            _map.put(ACEReducerForOneAPIParamKey.PRODUCT_PRICE, productPrice);
        }

        ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (queueManagerFactory != null) {
            queueManagerFactory
                    .getQueueManager()
                    .enqueue(ACEReducerForOne.reduce(
                            ACEofAPIForOne.AppearProduct,
                            _map,
                            doneWorkCallback));
        }
    }

    public static void buy(@Nullable final Context context,
                           @Nullable final String pageName,
                           @Nullable final String paymentMethod,
                           @Nullable final String orderNumber,
                           @Nullable final List<ACProduct> products,
                           @Nullable ICallbackOfACE doneWorkCallback) {
        ConcurrentHashMap<String, Object> _map = new ConcurrentHashMap<>();
        if (context != null) {
            _map.put(ACEReducerForOneAPIParamKey.CONTEXT, context);
        }
        if (!StringUtils.isNull(pageName)) {
            _map.put(ACEReducerForOneAPIParamKey.PAGE_NAME, pageName);
        }
        if (!StringUtils.isNull(paymentMethod)) {
            _map.put(ACEReducerForOneAPIParamKey.PAYMENT_METHOD, paymentMethod);
        }
        if (!StringUtils.isNull(orderNumber)) {
            _map.put(ACEReducerForOneAPIParamKey.ORDER_NUMBER, orderNumber);
        }
        if (products != null) {
            _map.put(ACEReducerForOneAPIParamKey.PRODUCT, products);
        }

        ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (queueManagerFactory != null) {
            queueManagerFactory
                    .getQueueManager()
                    .enqueue(ACEReducerForOne.reduce(
                            ACEOneStaticConfig.ACEofAPIForOne.Buy,
                            _map,
                            doneWorkCallback));
        }
    }

    public static void cart(final int logSource,
                            @Nullable final Context context,
                            @Nullable final List<ACProduct> products,
                            @Nullable ICallbackOfACE doneWorkCallback) {
        ConcurrentHashMap<String, Object> _map = new ConcurrentHashMap<>();
        if (context != null) {
            _map.put(ACEReducerForOneAPIParamKey.CONTEXT, context);
        }
//        if (!StringUtils.isNull(orderNumber)) {
//            _map.put(ACEReducerForOneAPIParamKey.ORDER_NUMBER, orderNumber);
//        }
        if (products != null) {
            _map.put(ACEReducerForOneAPIParamKey.PRODUCT, products);
        }

        ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (queueManagerFactory != null) {
            queueManagerFactory
                    .getQueueManager()
                    .enqueue(ACEReducerForOne.reduce(
                            logSource,
                            _map,
                            doneWorkCallback));
        }
    }

    public static void link(@Nullable final Context context,
                            @Nullable final String pageName,
                            @Nullable final String linkName,
                            @Nullable ICallbackOfACE doneWorkCallback) {
        ConcurrentHashMap <String, Object> _map = new ConcurrentHashMap<>();
        if (context != null) {
            _map.put(ACEReducerForOneAPIParamKey.CONTEXT, context);
        }
        if (!StringUtils.isNull(pageName)) {
            _map.put(ACEReducerForOneAPIParamKey.PAGE_NAME, pageName);
        }
        if (!StringUtils.isNull(linkName)) {
            _map.put(ACEReducerForOneAPIParamKey.LinkName, linkName);
        }

        ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (queueManagerFactory != null) {
            queueManagerFactory
                    .getQueueManager()
                    .enqueue(ACEReducerForOne.reduce(
                            ACEofAPIForOne.TrackLinkEvent,
                            _map,
                            doneWorkCallback));
        }
    }

    public static void search(@Nullable final Context context,
                              @Nullable final String pageName,
                              @Nullable final String keyword,
                              @Nullable ICallbackOfACE doneWorkCallback) {
        ConcurrentHashMap <String, Object> _map = new ConcurrentHashMap<>();
        if (context != null) {
            _map.put(ACEReducerForOneAPIParamKey.CONTEXT, context);
        }
        if (!StringUtils.isNull(keyword)) {
            _map.put(ACEReducerForOneAPIParamKey.KEYWORD, keyword);
        }
        if (!StringUtils.isNull(pageName)) {
            _map.put(ACEReducerForOneAPIParamKey.PAGE_NAME, pageName);
        }

        ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (queueManagerFactory != null) {
            queueManagerFactory
                    .getQueueManager()
                    .enqueue(ACEReducerForOne.reduce(
                            ACEofAPIForOne.Search,
                            _map,
                            doneWorkCallback));
        }
    }

    public static void tel(@Nullable final Context context,
                           @Nullable final String pageName,
                           @Nullable final String tel,
                           @Nullable ICallbackOfACE doneWorkCallback) {
        ConcurrentHashMap <String, Object> _map = new ConcurrentHashMap<>();
        if (context != null) {
            _map.put(ACEReducerForOneAPIParamKey.CONTEXT, context);
        }
        if (!StringUtils.isNull(pageName)) {
            _map.put(ACEReducerForOneAPIParamKey.PAGE_NAME, pageName);
        }
        if (!StringUtils.isNull(tel)) {
            _map.put(ACEReducerForOneAPIParamKey.Tel, tel);
        }

        ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (queueManagerFactory != null) {
            queueManagerFactory
                    .getQueueManager()
                    .enqueue(ACEReducerForOne.reduce(
                            ACEofAPIForOne.TrackTelEvent,
                            _map,
                            doneWorkCallback));
        }
    }
    //endregion Commerce

    //region deeplink, push, install referrer
    public static void referrer(@NonNull Map<String, String> map,
                                @Nullable ICallbackOfACE doneWorkCallback) {
        ConcurrentHashMap<String, Object> _map = new ConcurrentHashMap<>();
        if (map.containsKey(ParamsOneEnum_Key.KW)) {
            String _kw = map.get(ParamsOneEnum_Key.KW);
            if (!StringUtils.isNull(_kw)) {
                _map.put(ACEReducerForOneAPIParamKey.KW, _kw);
            }

            ACEQueueManagerFactory _queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
            if (_queueManagerFactory != null) {
                _queueManagerFactory
                        .getQueueManager()
                        .enqueue(ACEReducerForOne.reduce(
                                ACEofAPI.InstallReferrer,
                                _map,
                                doneWorkCallback));
            }
        }
        else {
            ACELog.d(TAG, "not contained " + ParamsOneEnum_Key.KW + " key.");
        }
    }

    private static void deeplinkOrPush(@Nullable Intent intent,
                                       @Nullable ICallbackOfACE doneWorkCallback) {
        if (intent == null) {
            ACELog.w(TAG, "intent is null.");
            return;
        }

        ConcurrentHashMap<String, Object> _map = new ConcurrentHashMap<>();
        int _identifier = ACEofAPI.Unknown;
        // push
        Bundle bundle = intent.getExtras();
        if (bundle != null) {
            if (bundle.containsKey(ParamsOneEnum_Key.KW)) {
                @Nullable String _push = bundle.getString(ParamsOneEnum_Key.KW);
                if (!TextUtils.isEmpty(_push)) {
                    _map.put(ACEReducerForOneAPIParamKey.KW, _push);
                    _identifier = ACEStaticConfig.ACEofAPI.PushAtRunningApp;
                }
                else {
                    ACELog.d(TAG, "_push is empty.");
                }
            }
            else {
                ACELog.d(TAG, "not contain " + ParamsOneEnum_Key.KW + " key in bundle.");
            }
        }
        else {
            ACELog.d(TAG, "bundle is null.");
        }

        // deeplink
        if (_identifier == ACEofAPI.Unknown) {
            Uri _uri = intent.getData();
            if (_uri != null) {
                String _query = _uri.getQuery();
                if (!TextUtils.isEmpty(_query)) {
                    @NonNull Map<String, String> map = ACEParameterUtil.getURLToMap(_query);
                    if (map.containsKey(ParamsOneEnum_Key.KW)) {
                        String _kw = map.get(ParamsOneEnum_Key.KW);
                        if (!StringUtils.isNull(_kw)) {
                            _map.put(ACEReducerForOneAPIParamKey.KW, _kw);
                        }
                    }
                    else {
                        ACELog.d(TAG, "not contain " + ParamsOneEnum_Key.KW + " key in map.");
                    }
                    _identifier = ACEStaticConfig.ACEofAPI.DeepLinkAtRunningApp;
                }
                else {
                    ACELog.d(TAG, "_query is empty.");
                }
            }
            else {
                ACELog.d(TAG, "_uri is null.");
            }
        }

        if (_identifier == ACEofAPI.Unknown) {
            ACELog.d(TAG, "_identifier is unknown.");
            return;
        }

        ACEQueueManagerFactory _queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (_queueManagerFactory != null) {
            _queueManagerFactory
                    .getQueueManager()
                    .enqueue(ACEReducerForOne.reduce(
                            _identifier,
                            _map,
                            doneWorkCallback));
        }
    }

    public static void onNewIntentByDeeplinkOrPush(@Nullable Intent intent,
                                                   @Nullable ICallbackOfACE doneWorkCallback) {
        deeplinkOrPush(
                intent,
                doneWorkCallback);
    }

    public static void onCreateByDeeplinkOrPush(final @NonNull Context context,
                                                boolean isGather,
                                                @Nullable ICallbackOfACE doneWorkCallback) {
        if (context instanceof Activity) {
            Activity activity = (Activity) context;
            Intent intent = activity.getIntent();
            deeplinkOrPush(
                    intent,
                    doneWorkCallback);
        }

        if (isGather) {
            ACSDK.send(new IACParamsTrackEvent() {
                @NonNull
                @Override
                public String getEventName() {
                    return ACEParameterUtil.getContextName(context);
                }

                @NonNull
                @Override
                public Context getContext() {
                    return context;
                }
            });
        }
    }
    //endregion deeplink, push, install referrer

    //region hybrid
    public static void requestAtScript(@Nullable JSONObject jsonObject,
                                       @Nullable ICallbackOfACE doneWorkCallback) {
        ConcurrentHashMap <String, Object> _map = new ConcurrentHashMap<>();
        if (jsonObject != null) {
            _map.put(ACEReducerForOneAPIParamKey.JSON_OBJECT, jsonObject);
        }

        ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (queueManagerFactory != null) {
            queueManagerFactory
                    .getQueueManager()
                    .enqueue(ACEReducerForOne.reduce(
                            ACEofAPI.ScriptRequestTask,
                            _map,
                            doneWorkCallback));
        }
    }
    //endregion hybrid

    //region JSON
    public static void failedLogSend(@Nullable final Context context,
                                     @Nullable JSONObject jsonObject,
                                     @Nullable ICallbackOfACE doneWorkCallback) {
        ConcurrentHashMap <String, Object> _map = new ConcurrentHashMap<>();
        if (context != null) {
            _map.put(ACEReducerForOneAPIParamKey.CONTEXT, context);
        }
        if (jsonObject != null) {
            _map.put(ACEReducerForOneAPIParamKey.JSON_OBJECT, jsonObject);
        }

        ACESendQueueManager.getInstance()
                .enqueue(ACEReducerForOne.reduce(
                        ACEStaticConfig.ACEofAPI.FailedLogSend,
                        _map,
                        doneWorkCallback));
    }
    //endregion JSON

    //region login, leave, join
    public static void login(@Nullable final Context context,
                             @Nullable final String pageName,
                             @Nullable final String userId,
                             @Nullable final Integer userAge,
                             @Nullable final ACEPublicStaticConfig.ACEGender userGender,
                             @Nullable final ACEPublicStaticConfig.ACEMaritalStatus userMaritalStatus,
                             @Nullable ICallbackOfACE doneWorkCallback) {
        ConcurrentHashMap <String, Object> _map = new ConcurrentHashMap<>();
        if (context != null) {
            _map.put(ACEReducerForOneAPIParamKey.CONTEXT, context);
        }
        if (!StringUtils.isNull(pageName)) {
            _map.put(ACEReducerForOneAPIParamKey.PAGE_NAME, pageName);
        }
        if (!StringUtils.isNull(userId)) {
            _map.put(ACEReducerForOneAPIParamKey.USER_ID, userId);
        }
        if (userAge != null) {
            _map.put(ACEReducerForOneAPIParamKey.AGE, userAge);
        }
        if (userGender != null) {
            _map.put(ACEReducerForOneAPIParamKey.GENDER, userGender);
        }
        if (userMaritalStatus != null) {
            _map.put(ACEReducerForOneAPIParamKey.MARITAL_STATUS, userMaritalStatus);
        }
        ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (queueManagerFactory != null) {
            queueManagerFactory
                    .getQueueManager()
                    .enqueue(ACEReducerForOne.reduce(
                            ACEofAPIForOne.Login,
                            _map,
                            doneWorkCallback));
        }
    }

    public static void leave(@Nullable final Context context,
                             @Nullable final String pageName,
                             @Nullable final String userId,
                             @Nullable ICallbackOfACE doneWorkCallback) {
        ConcurrentHashMap <String, Object> _map = new ConcurrentHashMap<>();
        if (context != null) {
            _map.put(ACEReducerForOneAPIParamKey.CONTEXT, context);
        }
        if (!StringUtils.isNull(pageName)) {
            _map.put(ACEReducerForOneAPIParamKey.PAGE_NAME, pageName);
        }
        if (!StringUtils.isNull(userId)) {
            _map.put(ACEReducerForOneAPIParamKey.USER_ID, userId);
        }

        ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (queueManagerFactory != null) {
            queueManagerFactory
                    .getQueueManager()
                    .enqueue(ACEReducerForOne.reduce(
                            ACEofAPIForOne.Leave,
                            _map,
                            doneWorkCallback));
        }
    }

    public static void join(@Nullable final Context context,
                            @Nullable final String pageName,
                            @Nullable final String userId,
                            @Nullable ICallbackOfACE doneWorkCallback) {
        ConcurrentHashMap <String, Object> _map = new ConcurrentHashMap<>();
        if (context != null) {
            _map.put(ACEReducerForOneAPIParamKey.CONTEXT, context);
        }
        if (!StringUtils.isNull(pageName)) {
            _map.put(ACEReducerForOneAPIParamKey.PAGE_NAME, pageName);
        }
        if (!StringUtils.isNull(userId)) {
            _map.put(ACEReducerForOneAPIParamKey.USER_ID, userId);
        }

        ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (queueManagerFactory != null) {
            queueManagerFactory
                    .getQueueManager()
                    .enqueue(ACEReducerForOne.reduce(
                            ACEofAPIForOne.Join,
                            _map,
                            doneWorkCallback));
        }
    }
    //endregion login, deactivate, join

    //region PL
    public static void plWithPage(@Nullable final Context context,
                                  @Nullable final String pageName,
                                  @Nullable ICallbackOfACE doneWorkCallback) {
        ConcurrentHashMap <String, Object> _map = new ConcurrentHashMap<>();
        if (context != null) {
            _map.put(ACEReducerForOneAPIParamKey.CONTEXT, context);
        }
        if (!StringUtils.isNull(pageName)) {
            _map.put(ACEReducerForOneAPIParamKey.PAGE_NAME, pageName);
        }

        ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (queueManagerFactory != null) {
            queueManagerFactory
                    .getQueueManager()
                    .enqueue(ACEReducerForOne.reduce(
                            ACEofAPIForOne.PlWithPage,
                            _map,
                            doneWorkCallback));
        }
    }

    public static void getSingleUsePvParameters(int logsource,
                                                @Nullable final Context context,
                                                @Nullable final String pageName,
                                                @Nullable final ICallbackOfACE doneWorkCallback) {
        ConcurrentHashMap <String, Object> _map = new ConcurrentHashMap<>();
        if (context != null) {
            _map.put(ACEReducerForOneAPIParamKey.CONTEXT, context);
        }
        if (!StringUtils.isNull(pageName)) {
            _map.put(ACEReducerForOneAPIParamKey.PAGE_NAME, pageName);
        }

        ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (queueManagerFactory != null) {
            Task _task = ACEReducerForOne.reduce(
                    logsource,
                    _map,
                    doneWorkCallback);

            if (_task == null) {
                ACELog.d(TAG, "task object is null");
                return;
            }

            ACESendQueueManager.getInstance().enqueue(_task);
        }
    }
    //endregion PV
}
