package com.acecounter.android.acetm.acone.parameter;

import android.content.Context;
import android.text.TextUtils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.acone.config.ACEOneStaticConfig;
import com.acecounter.android.acetm.common.config.ACEStaticConfig;
import com.acecounter.android.acetm.common.logger.ACELog;
import com.acecounter.android.acetm.common.parameter.IACECommonAPI;

import org.json.JSONObject;

public final class ACEInternalAPIForOne implements IACECommonAPI {
    private static final String TAG = ACEInternalAPIForOne.class.getSimpleName();

    @Override
    public void onCreateByDeeplinkOrPush(@NonNull Context context, boolean isGather) {
        ACEReducerForOne.onCreateByDeeplinkOrPush(
                context,
                isGather,
                null);
    }

    @Override
    public void requestPolicy(@Nullable Context context) {
        ACEReducerForOne.requestPolicy(context, null);
    }

    @Override
    public void send(int logSource, @Nullable String params) {
        @Nullable String _desc = this.getDescriptionForAPI(logSource);
        if (TextUtils.isEmpty(_desc)) {
            _desc = "not implementation logSource";
        }
        else {
            ACELog.d(TAG, "logSource desc: " + _desc);
        }

        switch (logSource) {
            case ACEStaticConfig.ACEofAPI.SendByHybridAPI:
                break;
            default:
                ACELog.d(TAG, "not implementation API in send.");
        }
    }

    @Override
    public void send(int logSource, @Nullable Context context, @Nullable JSONObject jsonObject) {
        @Nullable String _desc = this.getDescriptionForAPI(logSource);
        if (TextUtils.isEmpty(_desc)) {
            _desc = "not implementation logSource";
        }
        else {
            ACELog.d(TAG, "logSource desc: " + _desc);
        }

        switch (logSource) {
            case ACEStaticConfig.ACEofAPI.FailedLogSend:
                ACEReducerForOne.failedLogSend(
                        context,
                        jsonObject,
                        null);
                break;
            default:
                ACELog.d(TAG, "not implementation API in send.");
        }
    }

    @Nullable
    @Override
    public String getDescriptionForAPI(int logSource) {
        @Nullable String description = ACEOneStaticConfig.getDescriptionAtACEofAPIForOne(logSource);
        if (TextUtils.isEmpty(description)) {
            description = ACEStaticConfig.getDescriptionAtACEofAPI(logSource);
        }
        return description;
    }
}
