package com.acecounter.android.acetm.acone.controltower;

import com.acecounter.android.acetm.common.config.ACECommonStaticConfig;
import com.acecounter.android.acetm.common.controltower.ACEControlTower;
import com.acecounter.android.acetm.common.logger.ACELog;
import com.acecounter.android.acetm.common.queue.ACEQueueManagerFactory;
import com.acecounter.android.acetm.common.queue.ACEWaitQueueManager;

public final class ACEControlTowerForOne extends ACEControlTower {
    private static final String TAG = ACEControlTowerForOne.class.getSimpleName();

    @Override
    public synchronized void setInstallReferrerWaitDone(Boolean isInstallReferrerDone) {
        // TODO
        // 에카1은 install referrer 를 대기하지 않아도 됨
    }

    @Override
    public synchronized void setIsCompletePolicy(Boolean isCompletePolicy,
                                                 Boolean isSucceedRequestPolicy) {
        ACELog.d(TAG, "params isCompletePolicy: " + isCompletePolicy +
                ", isSucceedRequestPolicy: " + isSucceedRequestPolicy);

        if (isDisabled()) {
            return;
        }

        if (isCompletePolicy && isSucceedRequestPolicy) {
            ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
            if (queueManagerFactory != null) {
                ACELog.d(TAG, "request clean waiting queue.");
                ACEWaitQueueManager.getInstance().enqueueStop();
            }
        }
        else if (!isSucceedRequestPolicy) {
            ACELog.d(TAG, "failed receive policy will disable SDK.");
        }

        if (!isSucceedRequestPolicy) {
            this._isSDKEnabled = isSucceedRequestPolicy;
        }
        this._isCompletePolicy = isCompletePolicy;
    }
}
