package com.acecounter.android.acetm;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.webkit.WebView;

import androidx.annotation.Keep;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.acplus.parameter.ACEReducerForPlus;
import com.acecounter.android.acetm.common.config.ACECommonStaticConfig;
import com.acecounter.android.acetm.common.config.ACEPublicStaticConfig;
import com.acecounter.android.acetm.common.config.ACEStaticConfig;
import com.acecounter.android.acetm.common.logger.ACELog;
import com.acecounter.android.acetm.installreferrer.ACEInstallReferrerUtil;

import java.util.List;
import java.util.Locale;
import java.util.Map;

import static com.acecounter.android.acetm.common.util.ThreadUtil.runOnUiThread;

public final class AceTM extends IAC {
    private static final String TAG = AceTM.class.getSimpleName();

    //region 초기화
    @Keep
    @Deprecated
    @MainThread
    public static void initialize(@NonNull final AceConfiguration configuration) {
        AceTM.configure(configuration);
    }

    @Keep
    @MainThread
    public static void configure(@NonNull final AceConfiguration configuration) {
        AceTM.configureWithCallback(
                configuration,
                null);
    }

    @MainThread
    public static void configureWithCallback(@NonNull final AceConfiguration configuration,
                                              @Nullable final ICallbackOfACE doneWorkCallback) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                switch (configuration.getPlatform()) {
                    case ACEPublicStaticConfig.ACEPlatform.ACPlus:
                        AceTM._configure(
                                configuration,
                                doneWorkCallback);
                        break;
                    default: {
                        ACELog.w(TAG, "Please check the 'class'.");
                        ACELog.w(TAG, "Only use '" + TAG + "'.");
                    }
                }
            }
        });
    }

    @MainThread
    private static void _configure(@NonNull final AceConfiguration configuration,
                                   @Nullable final ICallbackOfACE doneWorkCallback) {
        // AceConfiguration [S]
        ACELog.i(TAG, "Initialize to '" + TAG + "'.");
        ACECommonStaticConfig.configure(
                configuration,
                doneWorkCallback);
        // AceConfiguration [E]
    }
    //endregion 초기화

    //region Commerce
    @Keep
    @MainThread
    public static void addCart(@Nullable final Context context,
                               @NonNull final AceProduct product) {
        ACEReducerForPlus.addCart(product);
    }

    @Keep
    @MainThread
    public static void bannerClick(@Nullable final Context context,
                                   final int promotionCode,
                                   final int bannerCode) {
        ACEReducerForPlus.bannerClick(
                promotionCode,
                bannerCode);
    }

    @Keep
    @MainThread
    public static void bannerView(@Nullable final Context context,
                                  final int promotionCode,
                                  final int bannerCode) {
        ACEReducerForPlus.bannerView(
                promotionCode,
                bannerCode);
    }

    @Keep
    @MainThread
    public static void buyList(@Nullable final Context context,
                               @Nullable final String paymentMethod,
                               @Nullable final String orderNumber,
                               final double totalPrice,
                               @NonNull final AceProduct product) {
        ACEReducerForPlus.buyList(
                paymentMethod,
                orderNumber,
                totalPrice,
                product);
    }

    @Keep
    @MainThread
    public static void buyList(@Nullable final Context context,
                               @Nullable final String paymentMethod,
                               @Nullable final String orderNumber,
                               final double totalPrice,
                               @NonNull final List<AceProduct> products) {
        ACEReducerForPlus.buyLists(
                paymentMethod,
                orderNumber,
                totalPrice,
                products);
    }

    @Keep
    @MainThread
    public static void buyNow(@Nullable final Context context,
                              @NonNull final AceProduct product) {
        ACEReducerForPlus.buyNow(product);
    }

    @Keep
    @MainThread
    public static void customerClick(@Nullable final Context context,
                                     @Nullable final String clickName) {
        ACEReducerForPlus.customerClick(clickName);
    }

    @Keep
    @MainThread
    public static void detailView(@NonNull final Context context,
                                  @Nullable final String productNumber,
                                  @Nullable final String productName,
                                  final double productPrice,
                                  @Nullable final String productCategory,
                                  @Nullable final String productImageUrl) {
        ACEReducerForPlus.detailView(
                context,
                productNumber,
                productName,
                productPrice,
                productCategory,
                productImageUrl);
    }

    @Keep
    @MainThread
    public static void detailView(@NonNull final Context context,
                                  @Nullable final String pageName,
                                  @Nullable final String productNumber,
                                  @Nullable final String productName,
                                  final double productPrice,
                                  @Nullable final String productCategory,
                                  @Nullable final String productImageUrl) {
        ACEReducerForPlus.detailView(
                context,
                pageName,
                productNumber,
                productName,
                productPrice,
                productCategory,
                productImageUrl);
    }

    @Keep
    @MainThread
    public static void pay(@Nullable final Context context,
                           @Nullable final String payName,
                           @NonNull final AceProduct product) {
        ACEReducerForPlus.pay(
                payName,
                product);
    }

    @Keep
    @MainThread
    public static void pay(@Nullable final Context context,
                           @Nullable final String payName,
                           @NonNull final List<AceProduct> products) {
        ACEReducerForPlus.paies(
                payName,
                products);
    }

    @Keep
    @MainThread
    public static void review(@Nullable final Context context,
                              @Nullable final String productNumber,
                              @Nullable final String reviewContents,
                              final int score) {
        ACEReducerForPlus.review(
                productNumber,
                reviewContents,
                score);
    }

    @Keep
    @MainThread
    public static void sns(@Nullable final Context context,
                           @Nullable final String productNumber,
                           @Nullable final String sns) {
        ACEReducerForPlus.sns(
                productNumber,
                sns);
    }

    @Keep
    @MainThread
    public static void tel(@Nullable final Context context,
                           @Nullable final String phoneNumber) {
        ACEReducerForPlus.tel(phoneNumber);
    }

    @Keep
    @MainThread
    public static void wishList(@Nullable final Context context,
                                @NonNull final AceProduct product) {
        ACEReducerForPlus.wishList(product);
    }
    //endregion Commerce

    //region Deeplink, push
    @Keep
    @MainThread
    public static void initPushExtraData(@NonNull Intent intent,
                                         @Nullable Bundle data) {
        if (data != null && data.containsKey(ACEStaticConfig.ACECONSTANT.ACP_PUSH)) {
            ACELog.v(TAG, String.format(Locale.getDefault(), "%s: %s",
                    ACEStaticConfig.ACECONSTANT.ACP_PUSH, data.getString(ACEStaticConfig.ACECONSTANT.ACP_PUSH)));
            intent.putExtra(ACEStaticConfig.ACECONSTANT.ACP_PUSH, data.getString(ACEStaticConfig.ACECONSTANT.ACP_PUSH));
        }
    }

    @Keep
    @MainThread
    public static void initPushExtraData(@NonNull Intent intent,
                                         @Nullable Map<String, String> data) {
        if (data != null && data.containsKey(ACEStaticConfig.ACECONSTANT.ACP_PUSH)) {
            ACELog.v(TAG,
                    String.format(Locale.getDefault(), "%s: %s",
                            ACEStaticConfig.ACECONSTANT.ACP_PUSH,
                            data.get(ACEStaticConfig.ACECONSTANT.ACP_PUSH)));
            intent.putExtra(
                    ACEStaticConfig.ACECONSTANT.ACP_PUSH,
                    data.get(ACEStaticConfig.ACECONSTANT.ACP_PUSH));
        }
    }

    @Keep
    @MainThread
    public static void setNewIntent(@NonNull Context context,
                                    @Nullable Intent intent) {
        ACEReducerForPlus.onNewIntentByDeeplinkOrPush(
                context,
                intent);
    }

    @Keep
    public static void setInstallReferrer(@Nullable String referrer) {
        ACEInstallReferrerUtil.setInstallReferrer(referrer);
    }
    //endregion Deeplink, push

    //region Error
    @Keep
    @MainThread
    public static void codeErr(@NonNull final Context context,
                               final int errCode,
                               @Nullable final String reason) {
        ACEReducerForPlus.codeErr(
                context,
                errCode,
                reason);
    }

    @Keep
    @MainThread
    public static void pageErr(@NonNull final Context context,
                               @Nullable final String pageName) {
        ACEReducerForPlus.pageErr(
                context,
                pageName);
    }

    @Keep
    @MainThread
    public static void pageErr(@NonNull final Context context) {
        ACEReducerForPlus.pageErr(
                context,
                null);
    }
    //endregion Error

    //region Hybrid
    @Keep
    @MainThread
    public static void onPageFinished(@NonNull WebView webView) {
        ACEReducerForPlus.onPageFinished(webView);
    }
    //endregion Hybrid

    //region Login
    @Keep
    @MainThread
    public static void deactivate(@NonNull final Context context,
                                  @NonNull final String userId) {
        ACEReducerForPlus.deactivate(
                context,
                userId);
    }

    public enum Gender {
        MAN("5"), WOMAN("6"), UNKNOWN("");
        private String value;

        Gender(String value) {
            this.value = value;
        }

        @NonNull
        @Override
        public String toString() {
            return value;
        }
    }

    @Keep
    @MainThread
    public static void join(@NonNull final Context context,
                            @Nullable final String userId,
                            final int userValue) {
        ACEReducerForPlus.join(
                context,
                userId,
                userValue);
    }

    @Keep
    @MainThread
    public static void login(@NonNull final Context context,
                             @Nullable final String userId,
                             final int userAge,
                             @Nullable final AceTM.Gender userGender,
                             final int group1,
                             final int group2,
                             final int group3,
                             final int group4,
                             final int group5) {
        ACEReducerForPlus.login(
                context,
                null,
                userId,
                userAge,
                userGender,
                group1,
                group2,
                group3,
                group4,
                group5);
    }

    @Keep
    @MainThread
    public static void login(@NonNull final Context context,
                             @Nullable final String pageName,
                             @Nullable final String userId,
                             final int userAge,
                             @Nullable final AceTM.Gender userGender,
                             final int group1,
                             final int group2,
                             final int group3,
                             final int group4,
                             final int group5) {
        ACEReducerForPlus.login(
                context,
                pageName,
                userId,
                userAge,
                userGender,
                group1,
                group2,
                group3,
                group4,
                group5);
    }

    @Keep
    @MainThread
    public static void login(@NonNull final Context context,
                             @Nullable final String userId,
                             final int userAge,
                             @Nullable final AceTM.Gender userGender) {
        ACEReducerForPlus.login(
                context,
                null,
                userId,
                userAge,
                userGender,
                0,
                0,
                0,
                0,
                0);
    }

    @Keep
    @MainThread
    public static void login(@NonNull final Context context,
                             @Nullable final String pageName,
                             @Nullable final String userId,
                             final int userAge,
                             @Nullable final AceTM.Gender userGender) {
        ACEReducerForPlus.login(
                context,
                pageName,
                userId,
                userAge,
                userGender,
                0,
                0,
                0,
                0,
                0);
    }
    //endregion Login

    //region Plugin
    @Keep
    public static void getPVParameters(@NonNull final Context context,
                                       @Nullable final String pageName,
                                       @Nullable final ICallbackOfACE doneWorkCallback) {
        if (!ACEStaticConfig.isIgnoreCase(context)) {
            ACEReducerForPlus.getSingleUsePvParameters(
                    ACEStaticConfig.ACEofAPI.PluginGetPVParameters,
                    context,
                    pageName,
                    doneWorkCallback);
        } else {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%s 는 PageView 전송이 제한된 항목입니다.", context.getClass().getSimpleName()));
        }
    }
    //endregion Plugin

    //region PV
    @Keep
    @MainThread
    public static void pv(@NonNull final Context context) {
        if (!ACEStaticConfig.isIgnoreCase(context)) {
            ACEReducerForPlus.pv(context);
        } else {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(), "%s 는 PageView 전송이 제한된 항목입니다.",
                            context.getClass().getSimpleName()));
        }
    }

    @MainThread
    @Keep
    public static void pv(@NonNull final Context context,
                          @Nullable final String pageName) {
        if (!ACEStaticConfig.isIgnoreCase(context)) {
            ACEReducerForPlus.pvWithPage(context, pageName);
        } else {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(), "%s 는 PageView 전송이 제한된 항목입니다.",
                            context.getClass().getSimpleName()));
        }
    }
    //endregion PV

    //region Search
    @Keep
    @MainThread
    public static void innerSearch(@NonNull final Context context,
                                   @Nullable final String keyword) {
        ACEReducerForPlus.innerSearch(
                context,
                null,
                keyword);
    }

    @Keep
    @MainThread
    public static void innerSearch(@NonNull final Context context,
                                   @Nullable final String pageName,
                                   @Nullable final String keyword) {
        ACEReducerForPlus.innerSearch(
                context,
                pageName,
                keyword);
    }
    //endregion Search
}


