package com.acecounter.android.acetm;

import android.app.Application;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.common.config.ACEPublicStaticConfig;

import java.util.HashSet;

public abstract class AceConfigurationBuilder {
    @NonNull
    protected Application _application;
    protected boolean _debug = true;
    protected boolean _isGather = true;
    @NonNull
    protected HashSet<String> _ignoreCaseActivityClassNameSet;
    @Nullable
    protected String _key;
    protected @ACEPublicStaticConfig.ACEPlatform int _platform;

    public boolean getDebug() {
        return this._debug;
    }

    protected void setDebugAtParent(boolean value) {
        this._debug = value;
    }

    @Nullable
    public String getKey() {
        return this._key;
    }
    protected void setKeyAtParent(@Nullable String value) {
        this._key = value;
    }

    public boolean getGather() {
        return this._isGather;
    }
    protected void setGatherAtParent(boolean value) {
        this._isGather = value;
    }

    abstract AceConfiguration build();
}
