package com.acecounter.android.acetm;

import android.text.TextUtils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.acone.config.ACEOneStaticConfig;
import com.acecounter.android.acetm.common.util.TypeUtil;

import java.io.UnsupportedEncodingException;
import java.util.Locale;

public final class ACProduct {
    @Nullable
    private String name;
    @Nullable
    private String category;
    @Nullable
    private String price;
    @Nullable
    private Integer quantity;

    @Nullable
    private String productId;
    @Nullable
    private String optionCodeName;

    public ACProduct(@Nullable String name,
                     @Nullable String category,
                     @Nullable String price,
                     @Nullable Integer quantity,
                     @Nullable String productId,
                     @Nullable String optionCodeName) {
        this.name = name;
        this.category = category;
        this.price = price;
        this.quantity = quantity;

        this.productId = productId;
        this.optionCodeName = optionCodeName;
    }

    @NonNull
    public String getName() {
        if (TextUtils.isEmpty(this.name)) {
            this.name = "";
        }
        return this.name;
    }

    @NonNull
    public String getCategory() {
        if (TextUtils.isEmpty(this.category)) {
            this.category = "";
        }
        return this.category;
    }

    @NonNull
    public String getPrice() {
        if (TextUtils.isEmpty(this.price)) {
            this.price = "";
        }
        return this.price;
    }

    @NonNull
    public Integer getQuantity() {
        if (this.quantity == null) {
            this.quantity = 0;
        }

        return this.quantity;
    }

    @NonNull
    public String getProductId() {
        if (TextUtils.isEmpty(this.productId)) {
            this.productId = "";
        }
        return this.productId;
    }

    @NonNull
    public String getOptionCodeName() {
        if (TextUtils.isEmpty(this.optionCodeName)) {
            this.optionCodeName = "";
        }
        return this.optionCodeName;
    }

    @NonNull
    private String encodedName() {
        try {
            return TypeUtil.encodeUTF8(getName());
        }
        catch (UnsupportedEncodingException e) {
            return getName();
        }
    }

    @NonNull
    private String encodedCategory() {
        try {
            return TypeUtil.encodeUTF8(getCategory());
        }
        catch (UnsupportedEncodingException e) {
            return getName();
        }
    }

    @NonNull
    private String encodedPrice() {
        try {
            return TypeUtil.encodeUTF8(getPrice());
        }
        catch (UnsupportedEncodingException e) {
            return getName();
        }
    }

    @NonNull
    private String encodedProductId() {
        try {
            return TypeUtil.encodeUTF8(getProductId());
        }
        catch (UnsupportedEncodingException e) {
            return getProductId();
        }
    }

    @NonNull
    private String encodedOptionCodeName() {
        try {
            return TypeUtil.encodeUTF8(getOptionCodeName());
        }
        catch (UnsupportedEncodingException e) {
            return getOptionCodeName();
        }
    }

    public String toString(int apiIdentity) {
        if (apiIdentity == ACEOneStaticConfig.ACEofAPIForOne.Buy) {
            return String.format(
                    Locale.getDefault(),
                    "%s@%s@%s@%d@%s@%s", encodedName(), encodedCategory(), encodedPrice(), getQuantity(), encodedProductId(), encodedOptionCodeName());
        }
        else {
            return String.format(
                    Locale.getDefault(),
                    "%s@%s@%s@%d", encodedName(), encodedCategory(), encodedPrice(), getQuantity());
        }

    }
}
