/*
 * Decompiled with CFR 0.152.
 */
package com.abtingramian.purrty.util;

import android.content.Context;
import android.graphics.DashPathEffect;
import android.support.annotation.ArrayRes;
import android.support.annotation.NonNull;
import com.abtingramian.purrty.util.DimensionUtil;
import com.abtingramian.purrty.util.R;
import java.util.ArrayList;
import java.util.List;

public class PathEffectUtil {

    public static class DashPathEffectBuilder {
        private Context context;
        private List<Float> intervalsList = new ArrayList<Float>();
        private float phase = 0.0f;

        public DashPathEffectBuilder(@NonNull Context context) {
            this.context = context;
        }

        public DashPathEffectBuilder addInterval(float intervalLength) {
            this.intervalsList.add(Float.valueOf(intervalLength));
            return this;
        }

        public DashPathEffectBuilder intervalsFromDimenResIdArray(@ArrayRes int arrayResId) {
            int[] intervals;
            for (int i : intervals = this.context.getResources().getIntArray(arrayResId)) {
                this.intervalsList.add(Float.valueOf(DimensionUtil.dpToPx(this.context, i)));
            }
            return this;
        }

        public DashPathEffect build() {
            if (this.intervalsList.isEmpty()) {
                this.intervalsList.add(Float.valueOf(this.context.getResources().getDimension(R.dimen.purrty_util_dash_interval_on)));
                this.intervalsList.add(Float.valueOf(this.context.getResources().getDimension(R.dimen.purrty_util_dash_interval_off)));
            }
            if (this.intervalsList.size() < 2 || this.intervalsList.size() % 2 != 0) {
                throw new IllegalArgumentException("A DashPathEffect requires at least 2 and an even number of interval length entries!");
            }
            float[] intervalsArray = new float[this.intervalsList.size()];
            for (int i = 0; i < this.intervalsList.size(); ++i) {
                intervalsArray[i] = this.intervalsList.get(i).floatValue();
            }
            return new DashPathEffect(intervalsArray, this.phase);
        }
    }
}

