/*
 * Decompiled with CFR 0.152.
 */
package com.abtingramian.purrty.util;

import android.graphics.Color;
import android.support.v4.graphics.ColorUtils;

public class ColorUtil {
    public static int applyAlpha(int color, int alpha) {
        return Color.argb((int)alpha, (int)Color.red((int)color), (int)Color.green((int)color), (int)Color.blue((int)color));
    }

    public static int adjustAlpha(int color, float factor) {
        int alpha = Math.round((float)Color.alpha((int)color) * factor);
        int red = Color.red((int)color);
        int green = Color.green((int)color);
        int blue = Color.blue((int)color);
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    public static int stripAlpha(int color) {
        int red = Color.red((int)color);
        int green = Color.green((int)color);
        int blue = Color.blue((int)color);
        return Color.rgb((int)red, (int)green, (int)blue);
    }

    public static boolean isBright(int color) {
        return ColorUtils.calculateLuminance((int)color) > 0.5;
    }

    public static int darken(int color, float factor) {
        int a = Color.alpha((int)color);
        int r = Color.red((int)color);
        int g = Color.green((int)color);
        int b = Color.blue((int)color);
        return Color.argb((int)a, (int)Math.max((int)((float)r * (1.0f - factor)), 0), (int)Math.max((int)((float)g * (1.0f - factor)), 0), (int)Math.max((int)((float)b * (1.0f - factor)), 0));
    }

    public static int percentTo255Scale(int percent) {
        if (percent >= 100) {
            return 255;
        }
        double factor = (double)percent / 100.0;
        return (int)(255.0 * factor);
    }

    public static int lightenColorByAmount(int color, float amount) {
        int alpha = (int)Math.min((float)Color.alpha((int)color) + amount, 255.0f);
        int red = (int)Math.min((float)Color.red((int)color) + amount, 255.0f);
        int green = (int)Math.min((float)Color.green((int)color) + amount, 255.0f);
        int blue = (int)Math.min((float)Color.blue((int)color) + amount, 255.0f);
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    public static int lightenColorByAmount(int color, float amount, boolean zeroToOneScale) {
        return ColorUtil.lightenColorByAmount(color, zeroToOneScale ? 255.0f * amount : amount);
    }

    public static int darkenColorByAmount(int color, float amount) {
        int alpha = (int)Math.max((float)Color.alpha((int)color) - amount, 0.0f);
        int red = (int)Math.max((float)Color.red((int)color) - amount, 0.0f);
        int green = (int)Math.max((float)Color.green((int)color) - amount, 0.0f);
        int blue = (int)Math.max((float)Color.blue((int)color) - amount, 0.0f);
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    public static int darkenColorByAmount(int color, float amount, boolean zeroToOneScale) {
        return ColorUtil.darkenColorByAmount(color, zeroToOneScale ? 255.0f * amount : amount);
    }
}

