/*
 * Decompiled with CFR 0.152.
 */
package com.abtingramian.purrty.util;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.view.ViewCompat;
import android.view.View;
import com.abtingramian.purrty.shapedrawablewithborder.ShapeDrawableWithBorder;
import com.abtingramian.purrty.util.ColorUtil;
import com.abtingramian.purrty.util.R;

public class RippleUtil {
    public static void setBackgroundCompat(View view, int colorMain, int colorBorder, int colorRipple, float cornerRadius, int borderWidth) {
        RippleUtil.setBackgroundCompat(view, null, null, colorMain, colorBorder, colorRipple, cornerRadius, borderWidth, 1.0f);
    }

    public static void setBackgroundCompat(View view, ShapeDrawableWithBorder shapeDrawable, int colorMain, int colorRipple) {
        RippleUtil.setBackgroundCompat(view, shapeDrawable, null, colorMain, colorMain, colorRipple, -1.0f, -1, 1.0f);
    }

    public static void setBackgroundCompat(View view, LayerDrawable layerDrawable, int colorMain, int colorRipple) {
        RippleUtil.setBackgroundCompat(view, null, layerDrawable, colorMain, colorMain, colorRipple, -1.0f, -1, 1.0f);
    }

    public static void setBackgroundCompat(View view, ShapeDrawableWithBorder shapeDrawable, LayerDrawable layerDrawable, int colorMain, int colorBorder, int colorRipple, float cornerRadius, int borderWidth, float alpha) {
        Drawable drawable = RippleUtil.getBackgroundCompat(view.getContext(), shapeDrawable, layerDrawable, colorMain, colorBorder, colorRipple, cornerRadius, borderWidth, alpha);
        ViewCompat.setBackground((View)view, (Drawable)drawable);
    }

    private static Drawable getBackgroundCompat(Context context, ShapeDrawableWithBorder shapeDrawable, LayerDrawable layerDrawable, int colorMain, int colorBorder, int colorRipple, float cornerRadius, int borderWidth, float alpha) {
        Drawable backgroundDrawableHighlighted;
        ShapeDrawableWithBorder backgroundDrawable;
        if (colorRipple == -1) {
            colorRipple = ContextCompat.getColor((Context)context, (int)(ColorUtil.isBright(colorMain) ? R.color.purrty_util_ripple_dark : R.color.purrty_util_ripple_light));
        }
        if (alpha != 1.0f) {
            colorMain = ColorUtil.adjustAlpha(colorMain, alpha);
            colorBorder = ColorUtil.adjustAlpha(colorBorder, alpha);
            colorRipple = ColorUtil.adjustAlpha(colorRipple, alpha);
        }
        if (shapeDrawable != null) {
            backgroundDrawable = shapeDrawable;
            shapeDrawable.getPaint().setColor(colorMain);
            if (borderWidth != -1) {
                shapeDrawable.setStrokeWidth(borderWidth);
                shapeDrawable.setStrokeColor(colorBorder);
            }
        } else if (layerDrawable != null) {
            backgroundDrawable = layerDrawable;
            ShapeDrawableWithBorder shapeDrawableWithBorder = (ShapeDrawableWithBorder)layerDrawable.getDrawable(1);
            shapeDrawableWithBorder.getPaint().setColor(colorMain);
            if (borderWidth != -1) {
                shapeDrawableWithBorder.setStrokeWidth(borderWidth);
                shapeDrawableWithBorder.setStrokeColor(colorBorder);
            }
        } else {
            backgroundDrawable = new GradientDrawable();
            ((GradientDrawable)backgroundDrawable).setShape(0);
            if (cornerRadius != -1.0f) {
                ((GradientDrawable)backgroundDrawable).setCornerRadius(cornerRadius);
            }
            ((GradientDrawable)backgroundDrawable).setColor(colorMain);
            if (borderWidth != -1) {
                ((GradientDrawable)backgroundDrawable).setStroke(borderWidth, colorBorder);
            }
        }
        if (Build.VERSION.SDK_INT >= 21) {
            return new RippleDrawable(ColorStateList.valueOf((int)colorRipple), (Drawable)backgroundDrawable, null);
        }
        Drawable drawable = backgroundDrawableHighlighted = Build.VERSION.SDK_INT > 16 ? backgroundDrawable.getConstantState().newDrawable() : DrawableCompat.wrap((Drawable)backgroundDrawable.getConstantState().newDrawable());
        if (backgroundDrawableHighlighted instanceof ShapeDrawable) {
            ((ShapeDrawable)backgroundDrawableHighlighted.mutate()).getPaint().setColor(ColorUtil.isBright(colorMain) ? ColorUtil.darkenColorByAmount(colorMain, Float.parseFloat(context.getResources().getString(R.string.purrty_util_ripple_pressed_lighten_darken_amount)), true) : ColorUtil.lightenColorByAmount(colorMain, Float.parseFloat(context.getResources().getString(R.string.purrty_util_ripple_pressed_lighten_darken_amount)), true));
        } else if (backgroundDrawableHighlighted instanceof GradientDrawable) {
            ((GradientDrawable)backgroundDrawableHighlighted.mutate()).setColor(ColorUtil.isBright(colorMain) ? ColorUtil.darkenColorByAmount(colorMain, Float.parseFloat(context.getResources().getString(R.string.purrty_util_ripple_pressed_lighten_darken_amount)), true) : ColorUtil.lightenColorByAmount(colorMain, Float.parseFloat(context.getResources().getString(R.string.purrty_util_ripple_pressed_lighten_darken_amount)), true));
        }
        StateListDrawable states = new StateListDrawable();
        states.addState(new int[]{16842919}, backgroundDrawableHighlighted);
        states.addState(new int[0], (Drawable)backgroundDrawable);
        return states;
    }
}

