/*
 * Decompiled with CFR 0.152.
 */
package com.ableneo.liferay.portal.setup.upgrade;

import com.ableneo.liferay.portal.setup.LiferaySetup;
import com.ableneo.liferay.portal.setup.MarshallUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URISyntaxException;

public abstract class BasicSetupUpgradeProcess
extends UpgradeProcess {
    private static final Log LOG = LogFactoryUtil.getLog(BasicSetupUpgradeProcess.class);

    public final void upgrade() throws UpgradeException {
        String[] fileNames;
        for (String fileName : fileNames = this.getSetupFileNames()) {
            try {
                File configurationFile = new File(BasicSetupUpgradeProcess.class.getClassLoader().getResource(fileName).toURI());
                LiferaySetup.setup(MarshallUtil.unmarshall(configurationFile));
            }
            catch (FileNotFoundException | URISyntaxException e) {
                throw new UpgradeException(String.format("Failed to process liferay setup configuration (%1$s)", fileName), (Throwable)e);
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)String.format("Upgraded database with liferay setup configuration: %1$s", fileName));
        }
    }

    protected void doUpgrade() throws Exception {
        this.upgrade();
    }

    protected abstract String[] getSetupFileNames();
}

