/*
 * Decompiled with CFR 0.152.
 */
package com.ableneo.liferay.portal.setup.core.util;

import com.ableneo.liferay.portal.setup.SetupConfigurationThreadLocal;
import com.ableneo.liferay.portal.setup.core.util.ResolverUtil;
import com.ableneo.liferay.portal.setup.domain.Article;
import com.ableneo.liferay.portal.setup.domain.Tag;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.journal.model.JournalArticle;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TaggingUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TaggingUtil.class);

    private TaggingUtil() {
    }

    public static void associateTagsAndCategories(long groupId, Article article, JournalArticle journalArticle) {
        List<Tag> tags = article.getTag();
        String[] tagNames = null;
        if (tags != null) {
            tagNames = (String[])tags.stream().map(Tag::getName).toArray(String[]::new);
        }
        long[] categoryIds = article.getCategory().stream().map(category -> ResolverUtil.lookupAll(groupId, journalArticle.getCompanyId(), category.getUuid(), article.getPath())).filter(Validator::isNumber).mapToLong(Long::parseLong).toArray();
        try {
            AssetEntry entry = AssetEntryLocalServiceUtil.getEntry((String)JournalArticle.class.getName(), (long)journalArticle.getResourcePrimKey());
            AssetEntryLocalServiceUtil.updateEntry((long)SetupConfigurationThreadLocal.getRunAsUserId(), (long)groupId, (String)JournalArticle.class.getName(), (long)entry.getClassPK(), (long[])categoryIds, (String[])tagNames);
        }
        catch (PortalException e) {
            LOG.warn("Unable to associate tags ({}) and categories ({}) with article: {}", new Object[]{tagNames, categoryIds, article.getTitle(), e});
        }
    }
}

