/*
 * Decompiled with CFR 0.152.
 */
package com.ableneo.liferay.portal.setup.core.util;

import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

public class ServiceTrackerBuilder<T> {
    private final Class hostClass;
    private final Class<T> clazz;

    public ServiceTrackerBuilder(Class<T> serviceClass, Class hostClass) {
        this.clazz = serviceClass;
        this.hostClass = hostClass;
    }

    public ServiceTracker<T, T> build() {
        Bundle bundle = FrameworkUtil.getBundle((Class)this.hostClass);
        if (bundle != null) {
            ServiceTracker serviceTracker = new ServiceTracker(bundle.getBundleContext(), this.clazz, null);
            serviceTracker.open();
            return serviceTracker;
        }
        throw new IllegalStateException(String.format("Host bundle not found for class %s. It is not possible to reliably track service %s instances without host bundle. It's best to use bundle containing class that needs the tracker to track the service.", this.hostClass.getName(), this.clazz.getName()));
    }

    public ServiceTracker<T, T> build(String filter) {
        Bundle bundle = FrameworkUtil.getBundle((Class)this.hostClass);
        String filterWithClass = String.format("(&(objectClass=%s)%s)", this.clazz.getName(), filter);
        Filter serviceFilter = null;
        try {
            serviceFilter = bundle.getBundleContext().createFilter(filterWithClass);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException(String.format("Invalid filter syntax: %s", filterWithClass), e);
        }
        if (bundle != null) {
            ServiceTracker serviceTracker = new ServiceTracker(bundle.getBundleContext(), serviceFilter, null);
            serviceTracker.open();
            return serviceTracker;
        }
        throw new IllegalStateException(String.format("Host bundle not found for class %s. It is not possible to reliably track service %s instances without host bundle. It's best to use bundle containing class that needs the tracker to track the service.", this.hostClass.getName(), this.clazz.getName()));
    }
}

