/*
 * Decompiled with CFR 0.152.
 */
package com.ableneo.liferay.portal.setup.core.util;

import com.ableneo.liferay.portal.setup.SetupConfigurationThreadLocal;
import com.liferay.portal.kernel.util.FileUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.osgi.framework.Bundle;

public class ResourcesUtil {
    private ResourcesUtil() {
    }

    public static InputStream getFileStream(String path) {
        ClassLoader cl = ResourcesUtil.class.getClassLoader();
        InputStream fileStream = cl.getResourceAsStream(path);
        if (fileStream == null) {
            Bundle callerBundle = SetupConfigurationThreadLocal.getCallerBundle();
            if (callerBundle == null) {
                throw new RuntimeException("Can not load file, does it exist? path:[" + path + "]");
            }
            URL url = callerBundle.getEntry(path);
            if (url != null) {
                try {
                    fileStream = url.openStream();
                }
                catch (IOException e) {
                    throw new RuntimeException("Error loading file from bundle:" + callerBundle.getSymbolicName() + ", path:[" + path + "]", e);
                }
            } else {
                throw new RuntimeException("Can not load file from bundle:" + callerBundle.getSymbolicName() + ", does it exist? path:[" + path + "]");
            }
        }
        return fileStream;
    }

    public static byte[] getFileBytes(String path) throws IOException {
        return FileUtil.getBytes((InputStream)ResourcesUtil.getFileStream(path));
    }

    public static String getFileContent(String path) throws IOException {
        byte[] bytes = ResourcesUtil.getFileBytes(path);
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

