/*
 * Decompiled with CFR 0.152.
 */
package com.ableneo.liferay.portal.setup.core.util;

import java.util.HashMap;

public final class MimeTypeMapper {
    public static final String X_WORLD_X_3_DMF = "x-world/x-3dmf";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final String TEXT_HTML = "text/html";
    private static final String APPLICATION_POSTSCRIPT = "application/postscript";
    private static final String AUDIO_AIFF = "audio/aiff";
    private static final String AUDIO_X_AIFF = "audio/x-aiff";
    private static final String APPLICATION_X_BSH = "application/x-bsh";
    private static final String TEXT_PLAIN = "text/plain";
    private static final String TEXT_X_C = "text/x-c";
    private static final String APPLICATION_X_X_509_CA_CERT = "application/x-x509-ca-cert";
    private static final String CLASS = ".class";
    private static final String APPLICATION_X_DIRECTOR = "application/x-director";
    private static final String APPLICATION_MSWORD = "application/msword";
    private static final String IMAGE_VND_DWG = "image/vnd.dwg";
    private static final String IMAGE_X_DWG = "image/x-dwg";
    private static final String TEXT_X_FORTRAN = "text/x-fortran";
    private static final String AUDIO_MAKE = "audio/make";
    private static final String APPLICATION_X_COMPRESSED = "application/x-compressed";
    private static final String APPLICATION_VND_HP_HPGL = "application/vnd.hp-hpgl";
    private static final String IMAGE_JPEG = "image/jpeg";
    private static final String IMAGE_PJPEG = "image/pjpeg";
    private static final String AUDIO_MIDI = "audio/midi";
    private static final String VIDEO_MPEG = "video/mpeg";
    private static final String AUDIO_MPEG = "audio/mpeg";
    private static final String MESSAGE_RFC_822 = "message/rfc822";
    private static final String APPLICATION_X_MIDI = "application/x-midi";
    private static final String VIDEO_QUICKTIME = "video/quicktime";
    private static final String APPLICATION_X_PROJECT = "application/x-project";
    private static final String APPLICATION_MSPOWERPOINT = "application/mspowerpoint";
    private static final String MIDI = ".midi";
    private static final String APPLICATION_VND_MS_POWERPOINT = "application/vnd.ms-powerpoint";
    private static final String IMAGE_X_QUICKTIME = "image/x-quicktime";
    private static final String AUDIO_X_PN_REALAUDIO = "audio/x-pn-realaudio";
    private static final String AUDIO_X_PN_REALAUDIO_PLUGIN = "audio/x-pn-realaudio-plugin";
    private static final String APPLICATION_X_TROFF = "application/x-troff";
    private static final String TEXT_RICHTEXT = "text/richtext";
    private static final String APPLICATION_X_KOAN = "application/x-koan";
    private static final String TEXT_URI_LIST = "text/uri-list";
    private static final String VRML = ".vrml";
    private static final String MODEL_VRML = "model/vrml";
    private static final String X_WORLD_X_VRML = "x-world/x-vrml";
    private static final String APPLICATION_X_VISIO = "application/x-visio";
    private static final String APPLICATION_WORDPERFECT = "application/wordperfect";
    private static final String APPLICATION_EXCEL = "application/excel";
    private static final String APPLICATION_X_EXCEL = "application/x-excel";
    private static final String APPLICATION_X_MSEXCEL = "application/x-msexcel";
    private static final String APPLICATION_VND_MS_EXCEL = "application/vnd.ms-excel";
    private static MimeTypeMapper instance = null;
    private HashMap mimeToExtension = new HashMap();
    private HashMap extensionToMimeType = new HashMap();

    private MimeTypeMapper() {
        this.init();
    }

    public static MimeTypeMapper getInstance() {
        if (instance == null) {
            instance = new MimeTypeMapper();
        }
        return instance;
    }

    public String getExtension(String mimeType) {
        String extension = "";
        if (this.mimeToExtension.containsKey(mimeType)) {
            extension = (String)this.mimeToExtension.get(mimeType);
        }
        return extension;
    }

    public String getMimeType(String extension) {
        String dottedExtension = this.getDottedExtension(extension);
        String mime = "";
        if (this.extensionToMimeType.containsKey(dottedExtension)) {
            mime = (String)this.extensionToMimeType.get(dottedExtension);
        }
        return mime;
    }

    private String getDottedExtension(String extension) {
        if (!extension.startsWith(".")) {
            return String.format(".%1$s", extension);
        }
        return extension;
    }

    private void addEntry(String extension, String mime) {
        this.mimeToExtension.put(mime, extension);
        this.extensionToMimeType.put(extension, mime);
    }

    private void init() {
        this.addEntry(".3dm", X_WORLD_X_3_DMF);
        this.addEntry(".3dmf", X_WORLD_X_3_DMF);
        this.addEntry(".a", APPLICATION_OCTET_STREAM);
        this.addEntry(".aab", "application/x-authorware-bin");
        this.addEntry(".aam", "application/x-authorware-map");
        this.addEntry(".aas", "application/x-authorware-seg");
        this.addEntry(".abc", "text/vnd.abc");
        this.addEntry(".acgi", TEXT_HTML);
        this.addEntry(".afl", "video/animaflex");
        this.addEntry(".ai", APPLICATION_POSTSCRIPT);
        this.addEntry(".aif", AUDIO_AIFF);
        this.addEntry(".aif", AUDIO_X_AIFF);
        this.addEntry(".aifc", AUDIO_AIFF);
        this.addEntry(".aifc", AUDIO_X_AIFF);
        this.addEntry(".aiff", AUDIO_AIFF);
        this.addEntry(".aiff", AUDIO_X_AIFF);
        this.addEntry(".aim", "application/x-aim");
        this.addEntry(".aip", "text/x-audiosoft-intra");
        this.addEntry(".ani", "application/x-navi-animation");
        this.addEntry(".aos", "application/x-nokia-9000-communicator-add-on-software");
        this.addEntry(".aps", "application/mime");
        this.addEntry(".arc", APPLICATION_OCTET_STREAM);
        this.addEntry(".arj", "application/arj");
        this.addEntry(".arj", APPLICATION_OCTET_STREAM);
        this.addEntry(".art", "image/x-jg");
        this.addEntry(".asf", "video/x-ms-asf");
        this.addEntry(".asm", "text/x-asm");
        this.addEntry(".asp", "text/asp");
        this.addEntry(".asx", "application/x-mplayer2");
        this.addEntry(".asx", "video/x-ms-asf");
        this.addEntry(".asx", "video/x-ms-asf-plugin");
        this.addEntry(".au", "audio/basic");
        this.addEntry(".au", "audio/x-au");
        this.addEntry(".avi", "application/x-troff-msvideo");
        this.addEntry(".avi", "video/avi");
        this.addEntry(".avi", "video/msvideo");
        this.addEntry(".avi", "video/x-msvideo");
        this.addEntry(".avs", "video/avs-video");
        this.addEntry(".bcpio", "application/x-bcpio");
        this.addEntry(".bin", "application/mac-binary");
        this.addEntry(".bin", "application/macbinary");
        this.addEntry(".bin", APPLICATION_OCTET_STREAM);
        this.addEntry(".bin", "application/x-binary");
        this.addEntry(".bin", "application/x-macbinary");
        this.addEntry(".bm", "image/bmp");
        this.addEntry(".bmp", "image/bmp");
        this.addEntry(".bmp", "image/x-windows-bmp");
        this.addEntry(".boo", "application/book");
        this.addEntry(".book", "application/book");
        this.addEntry(".boz", "application/x-bzip2");
        this.addEntry(".bsh", APPLICATION_X_BSH);
        this.addEntry(".bz", "application/x-bzip");
        this.addEntry(".bz2", "application/x-bzip2");
        this.addEntry(".c", TEXT_PLAIN);
        this.addEntry(".c", TEXT_X_C);
        this.addEntry(".c++", TEXT_PLAIN);
        this.addEntry(".cat", "application/vnd.ms-pki.seccat");
        this.addEntry(".cc", TEXT_PLAIN);
        this.addEntry(".cc", TEXT_X_C);
        this.addEntry(".ccad", "application/clariscad");
        this.addEntry(".cco", "application/x-cocoa");
        this.addEntry(".cdf", "application/cdf");
        this.addEntry(".cdf", "application/x-cdf");
        this.addEntry(".cdf", "application/x-netcdf");
        this.addEntry(".cer", "application/pkix-cert");
        this.addEntry(".cer", APPLICATION_X_X_509_CA_CERT);
        this.addEntry(".cha", "application/x-chat");
        this.addEntry(".chat", "application/x-chat");
        this.addEntry(CLASS, "application/java");
        this.addEntry(CLASS, "application/java-byte-code");
        this.addEntry(CLASS, "application/x-java-class");
        this.addEntry(".com", APPLICATION_OCTET_STREAM);
        this.addEntry(".com", TEXT_PLAIN);
        this.addEntry(".conf", TEXT_PLAIN);
        this.addEntry(".cpio", "application/x-cpio");
        this.addEntry(".cpp", TEXT_X_C);
        this.addEntry(".cpt", "application/mac-compactpro");
        this.addEntry(".cpt", "application/x-compactpro");
        this.addEntry(".cpt", "application/x-cpt");
        this.addEntry(".crl", "application/pkcs-crl");
        this.addEntry(".crl", "application/pkix-crl");
        this.addEntry(".crt", "application/pkix-cert");
        this.addEntry(".crt", APPLICATION_X_X_509_CA_CERT);
        this.addEntry(".crt", "application/x-x509-user-cert");
        this.addEntry(".csh", "application/x-csh");
        this.addEntry(".csh", "text/x-script.csh");
        this.addEntry(".css", "application/x-pointplus");
        this.addEntry(".css", "text/css");
        this.addEntry(".csv", "text/csv");
        this.addEntry(".cxx", TEXT_PLAIN);
        this.addEntry(".dcr", APPLICATION_X_DIRECTOR);
        this.addEntry(".deepv", "application/x-deepv");
        this.addEntry(".def", TEXT_PLAIN);
        this.addEntry(".der", APPLICATION_X_X_509_CA_CERT);
        this.addEntry(".dif", "video/x-dv");
        this.addEntry(".dir", APPLICATION_X_DIRECTOR);
        this.addEntry(".dl", "video/dl");
        this.addEntry(".dl", "video/x-dl");
        this.addEntry(".doc", APPLICATION_MSWORD);
        this.addEntry(".dot", APPLICATION_MSWORD);
        this.addEntry(".dp", "application/commonground");
        this.addEntry(".drw", "application/drafting");
        this.addEntry(".dump", APPLICATION_OCTET_STREAM);
        this.addEntry(".dv", "video/x-dv");
        this.addEntry(".dvi", "application/x-dvi");
        this.addEntry(".dwf", "drawing/x-dwf (old)");
        this.addEntry(".dwf", "model/vnd.dwf");
        this.addEntry(".dwg", "application/acad");
        this.addEntry(".dwg", IMAGE_VND_DWG);
        this.addEntry(".dwg", IMAGE_X_DWG);
        this.addEntry(".dxf", "application/dxf");
        this.addEntry(".dxf", IMAGE_VND_DWG);
        this.addEntry(".dxf", IMAGE_X_DWG);
        this.addEntry(".dxr", APPLICATION_X_DIRECTOR);
        this.addEntry(".el", "text/x-script.elisp");
        this.addEntry(".elc", "application/x-bytecode.elisp (compiled elisp)");
        this.addEntry(".elc", "application/x-elc");
        this.addEntry(".env", "application/x-envoy");
        this.addEntry(".eps", APPLICATION_POSTSCRIPT);
        this.addEntry(".es", "application/x-esrehber");
        this.addEntry(".etx", "text/x-setext");
        this.addEntry(".evy", "application/envoy");
        this.addEntry(".evy", "application/x-envoy");
        this.addEntry(".exe", APPLICATION_OCTET_STREAM);
        this.addEntry(".f", TEXT_PLAIN);
        this.addEntry(".f", TEXT_X_FORTRAN);
        this.addEntry(".f77", TEXT_X_FORTRAN);
        this.addEntry(".f90", TEXT_PLAIN);
        this.addEntry(".f90", TEXT_X_FORTRAN);
        this.addEntry(".fdf", "application/vnd.fdf");
        this.addEntry(".fif", "application/fractals");
        this.addEntry(".fif", "image/fif");
        this.addEntry(".fli", "video/fli");
        this.addEntry(".fli", "video/x-fli");
        this.addEntry(".flo", "image/florian");
        this.addEntry(".flx", "text/vnd.fmi.flexstor");
        this.addEntry(".fmf", "video/x-atomic3d-feature");
        this.addEntry(".for", TEXT_PLAIN);
        this.addEntry(".for", TEXT_X_FORTRAN);
        this.addEntry(".fpx", "image/vnd.fpx");
        this.addEntry(".fpx", "image/vnd.net-fpx");
        this.addEntry(".frl", "application/freeloader");
        this.addEntry(".funk", AUDIO_MAKE);
        this.addEntry(".g", TEXT_PLAIN);
        this.addEntry(".g3", "image/g3fax");
        this.addEntry(".gif", "image/gif");
        this.addEntry(".gl", "video/gl");
        this.addEntry(".gl", "video/x-gl");
        this.addEntry(".gsd", "audio/x-gsm");
        this.addEntry(".gsm", "audio/x-gsm");
        this.addEntry(".gsp", "application/x-gsp");
        this.addEntry(".gss", "application/x-gss");
        this.addEntry(".gtar", "application/x-gtar");
        this.addEntry(".gz", APPLICATION_X_COMPRESSED);
        this.addEntry(".gz", "application/x-gzip");
        this.addEntry(".gzip", "application/x-gzip");
        this.addEntry(".gzip", "multipart/x-gzip");
        this.addEntry(".h", TEXT_PLAIN);
        this.addEntry(".h", "text/x-h");
        this.addEntry(".hdf", "application/x-hdf");
        this.addEntry(".help", "application/x-helpfile");
        this.addEntry(".hgl", APPLICATION_VND_HP_HPGL);
        this.addEntry(".hh", TEXT_PLAIN);
        this.addEntry(".hh", "text/x-h");
        this.addEntry(".hlb", "text/x-script");
        this.addEntry(".hlp", "application/hlp");
        this.addEntry(".hlp", "application/x-helpfile");
        this.addEntry(".hlp", "application/x-winhelp");
        this.addEntry(".hpg", APPLICATION_VND_HP_HPGL);
        this.addEntry(".hpgl", APPLICATION_VND_HP_HPGL);
        this.addEntry(".hqx", "application/binhex");
        this.addEntry(".hqx", "application/binhex4");
        this.addEntry(".hqx", "application/mac-binhex");
        this.addEntry(".hqx", "application/mac-binhex40");
        this.addEntry(".hqx", "application/x-binhex40");
        this.addEntry(".hqx", "application/x-mac-binhex40");
        this.addEntry(".hta", "application/hta");
        this.addEntry(".htc", "text/x-component");
        this.addEntry(".htm", TEXT_HTML);
        this.addEntry(".html", TEXT_HTML);
        this.addEntry(".htmls", TEXT_HTML);
        this.addEntry(".htt", "text/webviewhtml");
        this.addEntry(".htx", TEXT_HTML);
        this.addEntry(".ice", "x-conference/x-cooltalk");
        this.addEntry(".ico", "image/x-icon");
        this.addEntry(".idc", TEXT_PLAIN);
        this.addEntry(".ief", "image/ief");
        this.addEntry(".iefs", "image/ief");
        this.addEntry(".iges", "application/iges");
        this.addEntry(".iges", "model/iges");
        this.addEntry(".igs", "application/iges");
        this.addEntry(".igs", "model/iges");
        this.addEntry(".ima", "application/x-ima");
        this.addEntry(".imap", "application/x-httpd-imap");
        this.addEntry(".inf", "application/inf");
        this.addEntry(".ins", "application/x-internett-signup");
        this.addEntry(".ip", "application/x-ip2");
        this.addEntry(".isu", "video/x-isvideo");
        this.addEntry(".it", "audio/it");
        this.addEntry(".iv", "application/x-inventor");
        this.addEntry(".ivr", "i-world/i-vrml");
        this.addEntry(".ivy", "application/x-livescreen");
        this.addEntry(".jam", "audio/x-jam");
        this.addEntry(".jav", TEXT_PLAIN);
        this.addEntry(".jav", "text/x-java-source");
        this.addEntry(".java", TEXT_PLAIN);
        this.addEntry(".java", "text/x-java-source");
        this.addEntry(".jcm", "application/x-java-commerce");
        this.addEntry(".jfif", IMAGE_JPEG);
        this.addEntry(".jfif", IMAGE_PJPEG);
        this.addEntry(".jfif-tbnl", IMAGE_JPEG);
        this.addEntry(".jpe", IMAGE_JPEG);
        this.addEntry(".jpe", IMAGE_PJPEG);
        this.addEntry(".jpeg", IMAGE_JPEG);
        this.addEntry(".jpeg", IMAGE_PJPEG);
        this.addEntry(".jpg", IMAGE_JPEG);
        this.addEntry(".jpg", IMAGE_PJPEG);
        this.addEntry(".jps", "image/x-jps");
        this.addEntry(".js", "application/x-javascript");
        this.addEntry(".jut", "image/jutvision");
        this.addEntry(".kar", AUDIO_MIDI);
        this.addEntry(".kar", "music/x-karaoke");
        this.addEntry(".ksh", "application/x-ksh");
        this.addEntry(".ksh", "text/x-script.ksh");
        this.addEntry(".la", "audio/nspaudio");
        this.addEntry(".la", "audio/x-nspaudio");
        this.addEntry(".lam", "audio/x-liveaudio");
        this.addEntry(".latex", "application/x-latex");
        this.addEntry(".lha", "application/lha");
        this.addEntry(".lha", APPLICATION_OCTET_STREAM);
        this.addEntry(".lha", "application/x-lha");
        this.addEntry(".lhx", APPLICATION_OCTET_STREAM);
        this.addEntry(".list", TEXT_PLAIN);
        this.addEntry(".lma", "audio/nspaudio");
        this.addEntry(".lma", "audio/x-nspaudio");
        this.addEntry(".log", TEXT_PLAIN);
        this.addEntry(".lsp", "application/x-lisp");
        this.addEntry(".lsp", "text/x-script.lisp");
        this.addEntry(".lst", TEXT_PLAIN);
        this.addEntry(".lsx", "text/x-la-asf");
        this.addEntry(".ltx", "application/x-latex");
        this.addEntry(".lzh", APPLICATION_OCTET_STREAM);
        this.addEntry(".lzh", "application/x-lzh");
        this.addEntry(".lzx", "application/lzx");
        this.addEntry(".lzx", APPLICATION_OCTET_STREAM);
        this.addEntry(".lzx", "application/x-lzx");
        this.addEntry(".m", TEXT_PLAIN);
        this.addEntry(".m", "text/x-m");
        this.addEntry(".m1v", VIDEO_MPEG);
        this.addEntry(".m2a", AUDIO_MPEG);
        this.addEntry(".m2v", VIDEO_MPEG);
        this.addEntry(".m3u", "audio/x-mpequrl");
        this.addEntry(".man", "application/x-troff-man");
        this.addEntry(".map", "application/x-navimap");
        this.addEntry(".mar", TEXT_PLAIN);
        this.addEntry(".mbd", "application/mbedlet");
        this.addEntry(".mc$", "application/x-magic-cap-package-1.0");
        this.addEntry(".mcd", "application/mcad");
        this.addEntry(".mcd", "application/x-mathcad");
        this.addEntry(".mcf", "image/vasa");
        this.addEntry(".mcf", "text/mcf");
        this.addEntry(".mcp", "application/netmc");
        this.addEntry(".me", "application/x-troff-me");
        this.addEntry(".mht", MESSAGE_RFC_822);
        this.addEntry(".mhtml", MESSAGE_RFC_822);
        this.addEntry(".mid", APPLICATION_X_MIDI);
        this.addEntry(".mid", AUDIO_MIDI);
        this.addEntry(".mid", "audio/x-mid");
        this.addEntry(".mid", "audio/x-midi");
        this.addEntry(".mid", "music/crescendo");
        this.addEntry(".mid", "x-music/x-midi");
        this.addEntry(MIDI, APPLICATION_X_MIDI);
        this.addEntry(MIDI, AUDIO_MIDI);
        this.addEntry(MIDI, "audio/x-mid");
        this.addEntry(MIDI, "audio/x-midi");
        this.addEntry(MIDI, "music/crescendo");
        this.addEntry(MIDI, "x-music/x-midi");
        this.addEntry(".mif", "application/x-frame");
        this.addEntry(".mif", "application/x-mif");
        this.addEntry(".mime", MESSAGE_RFC_822);
        this.addEntry(".mime", "www/mime");
        this.addEntry(".mjf", "audio/x-vnd.audioexplosion.mjuicemediafile");
        this.addEntry(".mjpg", "video/x-motion-jpeg");
        this.addEntry(".mm", "application/base64");
        this.addEntry(".mm", "application/x-meme");
        this.addEntry(".mme", "application/base64");
        this.addEntry(".mod", "audio/mod");
        this.addEntry(".mod", "audio/x-mod");
        this.addEntry(".moov", VIDEO_QUICKTIME);
        this.addEntry(".mov", VIDEO_QUICKTIME);
        this.addEntry(".movie", "video/x-sgi-movie");
        this.addEntry(".mp2", AUDIO_MPEG);
        this.addEntry(".mp2", "audio/x-mpeg");
        this.addEntry(".mp2", VIDEO_MPEG);
        this.addEntry(".mp2", "video/x-mpeg");
        this.addEntry(".mp2", "video/x-mpeq2a");
        this.addEntry(".mp3", "audio/mpeg3");
        this.addEntry(".mp3", "audio/x-mpeg-3");
        this.addEntry(".mp3", VIDEO_MPEG);
        this.addEntry(".mp3", "video/x-mpeg");
        this.addEntry(".mpa", AUDIO_MPEG);
        this.addEntry(".mpa", VIDEO_MPEG);
        this.addEntry(".mpc", APPLICATION_X_PROJECT);
        this.addEntry(".mpe", VIDEO_MPEG);
        this.addEntry(".mpeg", VIDEO_MPEG);
        this.addEntry(".mpg", AUDIO_MPEG);
        this.addEntry(".mpg", VIDEO_MPEG);
        this.addEntry(".mpga", AUDIO_MPEG);
        this.addEntry(".mpp", "application/vnd.ms-project");
        this.addEntry(".mpt", APPLICATION_X_PROJECT);
        this.addEntry(".mpv", APPLICATION_X_PROJECT);
        this.addEntry(".mpx", APPLICATION_X_PROJECT);
        this.addEntry(".mrc", "application/marc");
        this.addEntry(".ms", "application/x-troff-ms");
        this.addEntry(".mv", "video/x-sgi-movie");
        this.addEntry(".my", AUDIO_MAKE);
        this.addEntry(".mzz", "application/x-vnd.audioexplosion.mzz");
        this.addEntry(".nap", "image/naplps");
        this.addEntry(".naplps", "image/naplps");
        this.addEntry(".nc", "application/x-netcdf");
        this.addEntry(".ncm", "application/vnd.nokia.configuration-message");
        this.addEntry(".nif", "image/x-niff");
        this.addEntry(".niff", "image/x-niff");
        this.addEntry(".nix", "application/x-mix-transfer");
        this.addEntry(".nsc", "application/x-conference");
        this.addEntry(".nvd", "application/x-navidoc");
        this.addEntry(".o", APPLICATION_OCTET_STREAM);
        this.addEntry(".oda", "application/oda");
        this.addEntry(".omc", "application/x-omc");
        this.addEntry(".omcd", "application/x-omcdatamaker");
        this.addEntry(".omcr", "application/x-omcregerator");
        this.addEntry(".p", "text/x-pascal");
        this.addEntry(".p10", "application/pkcs10");
        this.addEntry(".p10", "application/x-pkcs10");
        this.addEntry(".p12", "application/pkcs-12");
        this.addEntry(".p12", "application/x-pkcs12");
        this.addEntry(".p7a", "application/x-pkcs7-signature");
        this.addEntry(".p7c", "application/pkcs7-mime");
        this.addEntry(".p7c", "application/x-pkcs7-mime");
        this.addEntry(".p7m", "application/pkcs7-mime");
        this.addEntry(".p7m", "application/x-pkcs7-mime");
        this.addEntry(".p7r", "application/x-pkcs7-certreqresp");
        this.addEntry(".p7s", "application/pkcs7-signature");
        this.addEntry(".part", "application/pro_eng");
        this.addEntry(".pas", "text/pascal");
        this.addEntry(".pbm", "image/x-portable-bitmap");
        this.addEntry(".pcl", "application/vnd.hp-pcl");
        this.addEntry(".pcl", "application/x-pcl");
        this.addEntry(".pct", "image/x-pict");
        this.addEntry(".pcx", "image/x-pcx");
        this.addEntry(".pdb", "chemical/x-pdb");
        this.addEntry(".pdf", "application/pdf");
        this.addEntry(".pfunk", AUDIO_MAKE);
        this.addEntry(".pfunk", "audio/make.my.funk");
        this.addEntry(".pgm", "image/x-portable-graymap");
        this.addEntry(".pgm", "image/x-portable-greymap");
        this.addEntry(".pic", "image/pict");
        this.addEntry(".pict", "image/pict");
        this.addEntry(".pkg", "application/x-newton-compatible-pkg");
        this.addEntry(".pko", "application/vnd.ms-pki.pko");
        this.addEntry(".pl", TEXT_PLAIN);
        this.addEntry(".pl", "text/x-script.perl");
        this.addEntry(".plx", "application/x-pixclscript");
        this.addEntry(".pm", "image/x-xpixmap");
        this.addEntry(".pm", "text/x-script.perl-module");
        this.addEntry(".pm4", "application/x-pagemaker");
        this.addEntry(".pm5", "application/x-pagemaker");
        this.addEntry(".png", "image/png");
        this.addEntry(".pnm", "application/x-portable-anymap");
        this.addEntry(".pnm", "image/x-portable-anymap");
        this.addEntry(".pot", APPLICATION_MSPOWERPOINT);
        this.addEntry(".pot", APPLICATION_VND_MS_POWERPOINT);
        this.addEntry(".pov", "model/x-pov");
        this.addEntry(".ppa", APPLICATION_VND_MS_POWERPOINT);
        this.addEntry(".ppm", "image/x-portable-pixmap");
        this.addEntry(".pps", APPLICATION_MSPOWERPOINT);
        this.addEntry(".pps", APPLICATION_VND_MS_POWERPOINT);
        this.addEntry(".ppt", APPLICATION_MSPOWERPOINT);
        this.addEntry(".ppt", "application/powerpoint");
        this.addEntry(".ppt", APPLICATION_VND_MS_POWERPOINT);
        this.addEntry(".ppt", "application/x-mspowerpoint");
        this.addEntry(".ppz", APPLICATION_MSPOWERPOINT);
        this.addEntry(".pre", "application/x-freelance");
        this.addEntry(".prt", "application/pro_eng");
        this.addEntry(".ps", APPLICATION_POSTSCRIPT);
        this.addEntry(".psd", APPLICATION_OCTET_STREAM);
        this.addEntry(".pvu", "paleovu/x-pv");
        this.addEntry(".pwz", APPLICATION_VND_MS_POWERPOINT);
        this.addEntry(".py", "text/x-script.phyton");
        this.addEntry(".pyc", "applicaiton/x-bytecode.python");
        this.addEntry(".qcp", "audio/vnd.qcelp");
        this.addEntry(".qd3", X_WORLD_X_3_DMF);
        this.addEntry(".qd3d", X_WORLD_X_3_DMF);
        this.addEntry(".qif", IMAGE_X_QUICKTIME);
        this.addEntry(".qt", VIDEO_QUICKTIME);
        this.addEntry(".qtc", "video/x-qtc");
        this.addEntry(".qti", IMAGE_X_QUICKTIME);
        this.addEntry(".qtif", IMAGE_X_QUICKTIME);
        this.addEntry(".ra", AUDIO_X_PN_REALAUDIO);
        this.addEntry(".ra", AUDIO_X_PN_REALAUDIO_PLUGIN);
        this.addEntry(".ra", "audio/x-realaudio");
        this.addEntry(".ram", AUDIO_X_PN_REALAUDIO);
        this.addEntry(".ras", "application/x-cmu-raster");
        this.addEntry(".ras", "image/cmu-raster");
        this.addEntry(".ras", "image/x-cmu-raster");
        this.addEntry(".rast", "image/cmu-raster");
        this.addEntry(".rexx", "text/x-script.rexx");
        this.addEntry(".rf", "image/vnd.rn-realflash");
        this.addEntry(".rgb", "image/x-rgb");
        this.addEntry(".rm", "application/vnd.rn-realmedia");
        this.addEntry(".rm", AUDIO_X_PN_REALAUDIO);
        this.addEntry(".rmi", "audio/mid");
        this.addEntry(".rmm", AUDIO_X_PN_REALAUDIO);
        this.addEntry(".rmp", AUDIO_X_PN_REALAUDIO);
        this.addEntry(".rmp", AUDIO_X_PN_REALAUDIO_PLUGIN);
        this.addEntry(".rng", "application/ringing-tones");
        this.addEntry(".rng", "application/vnd.nokia.ringing-tone");
        this.addEntry(".rnx", "application/vnd.rn-realplayer");
        this.addEntry(".roff", APPLICATION_X_TROFF);
        this.addEntry(".rp", "image/vnd.rn-realpix");
        this.addEntry(".rpm", AUDIO_X_PN_REALAUDIO_PLUGIN);
        this.addEntry(".rt", TEXT_RICHTEXT);
        this.addEntry(".rt", "text/vnd.rn-realtext");
        this.addEntry(".rtf", "application/rtf");
        this.addEntry(".rtf", "application/x-rtf");
        this.addEntry(".rtf", TEXT_RICHTEXT);
        this.addEntry(".rtx", "application/rtf");
        this.addEntry(".rtx", TEXT_RICHTEXT);
        this.addEntry(".rv", "video/vnd.rn-realvideo");
        this.addEntry(".s", "text/x-asm");
        this.addEntry(".s3m", "audio/s3m");
        this.addEntry(".saveme", APPLICATION_OCTET_STREAM);
        this.addEntry(".sbk", "application/x-tbook");
        this.addEntry(".scm", "application/x-lotusscreencam");
        this.addEntry(".scm", "text/x-script.guile");
        this.addEntry(".scm", "text/x-script.scheme");
        this.addEntry(".scm", "video/x-scm");
        this.addEntry(".sdml", TEXT_PLAIN);
        this.addEntry(".sdp", "application/sdp");
        this.addEntry(".sdp", "application/x-sdp");
        this.addEntry(".sdr", "application/sounder");
        this.addEntry(".sea", "application/sea");
        this.addEntry(".sea", "application/x-sea");
        this.addEntry(".set", "application/set");
        this.addEntry(".sgm", "text/sgml");
        this.addEntry(".sgm", "text/x-sgml");
        this.addEntry(".sgml", "text/sgml");
        this.addEntry(".sgml", "text/x-sgml");
        this.addEntry(".sh", APPLICATION_X_BSH);
        this.addEntry(".sh", "application/x-sh");
        this.addEntry(".sh", "application/x-shar");
        this.addEntry(".sh", "text/x-script.sh");
        this.addEntry(".shar", APPLICATION_X_BSH);
        this.addEntry(".shar", "application/x-shar");
        this.addEntry(".shtml", TEXT_HTML);
        this.addEntry(".shtml", "text/x-server-parsed-html");
        this.addEntry(".sid", "audio/x-psid");
        this.addEntry(".sit", "application/x-sit");
        this.addEntry(".sit", "application/x-stuffit");
        this.addEntry(".skd", APPLICATION_X_KOAN);
        this.addEntry(".skm", APPLICATION_X_KOAN);
        this.addEntry(".skp", APPLICATION_X_KOAN);
        this.addEntry(".skt", APPLICATION_X_KOAN);
        this.addEntry(".sl", "application/x-seelogo");
        this.addEntry(".smi", "application/smil");
        this.addEntry(".smil", "application/smil");
        this.addEntry(".snd", "audio/basic");
        this.addEntry(".snd", "audio/x-adpcm");
        this.addEntry(".sol", "application/solids");
        this.addEntry(".spc", "application/x-pkcs7-certificates");
        this.addEntry(".spc", "text/x-speech");
        this.addEntry(".spl", "application/futuresplash");
        this.addEntry(".spr", "application/x-sprite");
        this.addEntry(".sprite", "application/x-sprite");
        this.addEntry(".src", "application/x-wais-source");
        this.addEntry(".ssi", "text/x-server-parsed-html");
        this.addEntry(".ssm", "application/streamingmedia");
        this.addEntry(".sst", "application/vnd.ms-pki.certstore");
        this.addEntry(".step", "application/step");
        this.addEntry(".stl", "application/sla");
        this.addEntry(".stl", "application/vnd.ms-pki.stl");
        this.addEntry(".stl", "application/x-navistyle");
        this.addEntry(".stp", "application/step");
        this.addEntry(".sv4cpio", "application/x-sv4cpio");
        this.addEntry(".sv4crc", "application/x-sv4crc");
        this.addEntry(".svf", IMAGE_VND_DWG);
        this.addEntry(".svf", IMAGE_X_DWG);
        this.addEntry(".svr", "application/x-world");
        this.addEntry(".svr", "x-world/x-svr");
        this.addEntry(".swf", "application/x-shockwave-flash");
        this.addEntry(".t", APPLICATION_X_TROFF);
        this.addEntry(".talk", "text/x-speech");
        this.addEntry(".tar", "application/x-tar");
        this.addEntry(".tbk", "application/toolbook");
        this.addEntry(".tbk", "application/x-tbook");
        this.addEntry(".tcl", "application/x-tcl");
        this.addEntry(".tcl", "text/x-script.tcl");
        this.addEntry(".tcsh", "text/x-script.tcsh");
        this.addEntry(".tex", "application/x-tex");
        this.addEntry(".texi", "application/x-texinfo");
        this.addEntry(".texinfo", "application/x-texinfo");
        this.addEntry(".text", "application/plain");
        this.addEntry(".text", TEXT_PLAIN);
        this.addEntry(".tgz", "application/gnutar");
        this.addEntry(".tgz", APPLICATION_X_COMPRESSED);
        this.addEntry(".tif", "image/tiff");
        this.addEntry(".tif", "image/x-tiff");
        this.addEntry(".tiff", "image/tiff");
        this.addEntry(".tiff", "image/x-tiff");
        this.addEntry(".tr", APPLICATION_X_TROFF);
        this.addEntry(".tsi", "audio/tsp-audio");
        this.addEntry(".tsp", "application/dsptype");
        this.addEntry(".tsp", "audio/tsplayer");
        this.addEntry(".tsv", "text/tab-separated-values");
        this.addEntry(".turbot", "image/florian");
        this.addEntry(".txt", TEXT_PLAIN);
        this.addEntry(".uil", "text/x-uil");
        this.addEntry(".uni", TEXT_URI_LIST);
        this.addEntry(".unis", TEXT_URI_LIST);
        this.addEntry(".unv", "application/i-deas");
        this.addEntry(".uri", TEXT_URI_LIST);
        this.addEntry(".uris", TEXT_URI_LIST);
        this.addEntry(".ustar", "application/x-ustar");
        this.addEntry(".ustar", "multipart/x-ustar");
        this.addEntry(".uu", APPLICATION_OCTET_STREAM);
        this.addEntry(".uu", "text/x-uuencode");
        this.addEntry(".uue", "text/x-uuencode");
        this.addEntry(".vcd", "application/x-cdlink");
        this.addEntry(".vcs", "text/x-vcalendar");
        this.addEntry(".vda", "application/vda");
        this.addEntry(".vdo", "video/vdo");
        this.addEntry(".vew", "application/groupwise");
        this.addEntry(".viv", "video/vivo");
        this.addEntry(".viv", "video/vnd.vivo");
        this.addEntry(".vivo", "video/vivo");
        this.addEntry(".vivo", "video/vnd.vivo");
        this.addEntry(".vmd", "application/vocaltec-media-desc");
        this.addEntry(".vmf", "application/vocaltec-media-file");
        this.addEntry(".voc", "audio/voc");
        this.addEntry(".voc", "audio/x-voc");
        this.addEntry(".vos", "video/vosaic");
        this.addEntry(".vox", "audio/voxware");
        this.addEntry(".vqe", "audio/x-twinvq-plugin");
        this.addEntry(".vqf", "audio/x-twinvq");
        this.addEntry(".vql", "audio/x-twinvq-plugin");
        this.addEntry(VRML, "application/x-vrml");
        this.addEntry(VRML, MODEL_VRML);
        this.addEntry(VRML, X_WORLD_X_VRML);
        this.addEntry(".vrt", "x-world/x-vrt");
        this.addEntry(".vsd", APPLICATION_X_VISIO);
        this.addEntry(".vst", APPLICATION_X_VISIO);
        this.addEntry(".vsw", APPLICATION_X_VISIO);
        this.addEntry(".w60", "application/wordperfect6.0");
        this.addEntry(".w61", "application/wordperfect6.1");
        this.addEntry(".w6w", APPLICATION_MSWORD);
        this.addEntry(".wav", "audio/wav");
        this.addEntry(".wav", "audio/x-wav");
        this.addEntry(".wb1", "application/x-qpro");
        this.addEntry(".wbmp", "image/vnd.wap.wbmp");
        this.addEntry(".web", "application/vnd.xara");
        this.addEntry(".wiz", APPLICATION_MSWORD);
        this.addEntry(".wk1", "application/x-123");
        this.addEntry(".wmf", "windows/metafile");
        this.addEntry(".wml", "text/vnd.wap.wml");
        this.addEntry(".wmlc", "application/vnd.wap.wmlc");
        this.addEntry(".wmls", "text/vnd.wap.wmlscript");
        this.addEntry(".wmlsc", "application/vnd.wap.wmlscriptc");
        this.addEntry(".word", APPLICATION_MSWORD);
        this.addEntry(".wp", APPLICATION_WORDPERFECT);
        this.addEntry(".wp5", APPLICATION_WORDPERFECT);
        this.addEntry(".wp5", "application/wordperfect6.0");
        this.addEntry(".wp6", APPLICATION_WORDPERFECT);
        this.addEntry(".wpd", APPLICATION_WORDPERFECT);
        this.addEntry(".wpd", "application/x-wpwin");
        this.addEntry(".wq1", "application/x-lotus");
        this.addEntry(".wri", "application/mswrite");
        this.addEntry(".wri", "application/x-wri");
        this.addEntry(".wrl", "application/x-world");
        this.addEntry(".wrl", MODEL_VRML);
        this.addEntry(".wrl", X_WORLD_X_VRML);
        this.addEntry(".wrz", MODEL_VRML);
        this.addEntry(".wrz", X_WORLD_X_VRML);
        this.addEntry(".wsc", "text/scriplet");
        this.addEntry(".wsrc", "application/x-wais-source");
        this.addEntry(".wtk", "application/x-wintalk");
        this.addEntry(".xbm", "image/x-xbitmap");
        this.addEntry(".xbm", "image/x-xbm");
        this.addEntry(".xbm", "image/xbm");
        this.addEntry(".xdr", "video/x-amt-demorun");
        this.addEntry(".xgz", "xgl/drawing");
        this.addEntry(".xif", "image/vnd.xiff");
        this.addEntry(".xl", APPLICATION_EXCEL);
        this.addEntry(".xla", APPLICATION_EXCEL);
        this.addEntry(".xla", APPLICATION_X_EXCEL);
        this.addEntry(".xla", APPLICATION_X_MSEXCEL);
        this.addEntry(".xlb", APPLICATION_EXCEL);
        this.addEntry(".xlb", APPLICATION_VND_MS_EXCEL);
        this.addEntry(".xlb", APPLICATION_X_EXCEL);
        this.addEntry(".xlc", APPLICATION_EXCEL);
        this.addEntry(".xlc", APPLICATION_VND_MS_EXCEL);
        this.addEntry(".xlc", APPLICATION_X_EXCEL);
        this.addEntry(".xld", APPLICATION_EXCEL);
        this.addEntry(".xld", APPLICATION_X_EXCEL);
        this.addEntry(".xlk", APPLICATION_EXCEL);
        this.addEntry(".xlk", APPLICATION_X_EXCEL);
        this.addEntry(".xll", APPLICATION_EXCEL);
        this.addEntry(".xll", APPLICATION_VND_MS_EXCEL);
        this.addEntry(".xll", APPLICATION_X_EXCEL);
        this.addEntry(".xlm", APPLICATION_EXCEL);
        this.addEntry(".xlm", APPLICATION_VND_MS_EXCEL);
        this.addEntry(".xlm", APPLICATION_X_EXCEL);
        this.addEntry(".xls", APPLICATION_VND_MS_EXCEL);
        this.addEntry(".xls", APPLICATION_X_EXCEL);
        this.addEntry(".xls", APPLICATION_X_MSEXCEL);
        this.addEntry(".xls", APPLICATION_EXCEL);
        this.addEntry(".xlt", APPLICATION_EXCEL);
        this.addEntry(".xlt", APPLICATION_X_EXCEL);
        this.addEntry(".xlv", APPLICATION_EXCEL);
        this.addEntry(".xlv", APPLICATION_X_EXCEL);
        this.addEntry(".xlw", APPLICATION_EXCEL);
        this.addEntry(".xlw", APPLICATION_VND_MS_EXCEL);
        this.addEntry(".xlw", APPLICATION_X_EXCEL);
        this.addEntry(".xlw", APPLICATION_X_MSEXCEL);
        this.addEntry(".xm", "audio/xm");
        this.addEntry(".xml", "application/xml");
        this.addEntry(".xml", "text/xml");
        this.addEntry(".xmz", "xgl/movie");
        this.addEntry(".xpix", "application/x-vnd.ls-xpix");
        this.addEntry(".xpm", "image/x-xpixmap");
        this.addEntry(".xpm", "image/xpm");
        this.addEntry(".x-png", "image/png");
        this.addEntry(".xsr", "video/x-amt-showrun");
        this.addEntry(".xwd", "image/x-xwd");
        this.addEntry(".xwd", "image/x-xwindowdump");
        this.addEntry(".xyz", "chemical/x-pdb");
        this.addEntry(".z", "application/x-compress");
        this.addEntry(".z", APPLICATION_X_COMPRESSED);
        this.addEntry(".zip", APPLICATION_X_COMPRESSED);
        this.addEntry(".zip", "application/x-zip-compressed");
        this.addEntry(".zip", "application/zip");
        this.addEntry(".zip", "multipart/x-zip");
        this.addEntry(".zoo", APPLICATION_OCTET_STREAM);
        this.addEntry(".zsh", "text/x-script.zsh");
        this.addEntry(".docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        this.addEntry(".dotx", "application/vnd.openxmlformats-officedocument.wordprocessingml.template");
        this.addEntry(".docm", "application/vnd.ms-word.document.macroEnabled.12");
        this.addEntry(".dotm", "application/vnd.ms-word.template.macroEnabled.12");
        this.addEntry(".xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        this.addEntry(".xltx", "application/vnd.openxmlformats-officedocument.spreadsheetml.template");
        this.addEntry(".xlsm", "application/vnd.ms-excel.sheet.macroEnabled.12");
        this.addEntry(".xltm", "application/vnd.ms-excel.template.macroEnabled.12");
        this.addEntry(".xlam", "application/vnd.ms-excel.addin.macroEnabled.12");
        this.addEntry(".xlsb", "application/vnd.ms-excel.sheet.binary.macroEnabled.12");
        this.addEntry(".pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
        this.addEntry(".potx", "application/vnd.openxmlformats-officedocument.presentationml.template");
        this.addEntry(".ppsx", "application/vnd.openxmlformats-officedocument.presentationml.slideshow");
        this.addEntry(".ppam", "application/vnd.ms-powerpoint.addin.macroEnabled.12");
        this.addEntry(".pptm", "application/vnd.ms-powerpoint.presentation.macroEnabled.12");
        this.addEntry(".potm", "application/vnd.ms-powerpoint.template.macroEnabled.12");
        this.addEntry(".ppsm", "application/vnd.ms-powerpoint.slideshow.macroEnabled.12");
    }
}

