/*
 * Decompiled with CFR 0.152.
 */
package com.ableneo.liferay.portal.setup.core.util;

import com.ableneo.liferay.portal.setup.SetupConfigurationThreadLocal;
import com.ableneo.liferay.portal.setup.core.SetupPermissions;
import com.ableneo.liferay.portal.setup.core.SetupWebFolders;
import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.service.DLAppLocalServiceUtil;
import com.liferay.journal.model.JournalFolder;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.ServiceContext;

public final class FolderUtil {
    private static final Log LOG = LogFactoryUtil.getLog(FolderUtil.class);

    private FolderUtil() {
    }

    public static Folder findFolder(long groupId, long repoId, String name, boolean createIfNotExists) {
        String[] folderPath = name.split("/");
        Folder foundFolder = null;
        Long parentId = 0L;
        for (int count = 0; count < folderPath.length; ++count) {
            String folder = folderPath[count];
            if (folder.equals("")) continue;
            foundFolder = FolderUtil.findFolder(groupId, parentId, folder);
            if (foundFolder == null && createIfNotExists) {
                foundFolder = FolderUtil.createDocumentFolder(groupId, repoId, parentId, folder);
                long company = SetupConfigurationThreadLocal.getRunInCompanyId();
                if (foundFolder != null) {
                    String locationHint = String.format("Folder %1$s, creating folder segment %2$s", name, folder);
                    SetupPermissions.updatePermission(locationHint, company, foundFolder.getFolderId(), JournalFolder.class, null, SetupWebFolders.getDefaultPermissions());
                }
            }
            if (foundFolder == null) break;
            parentId = foundFolder.getFolderId();
        }
        return foundFolder;
    }

    public static Folder findFolder(Long groupId, Long parentFolderId, String name) {
        Folder dir = null;
        try {
            dir = DLAppLocalServiceUtil.getFolder((long)groupId, (long)parentFolderId, (String)name);
        }
        catch (NoSuchFolderException nsfe) {
            LOG.info((Object)String.format("Folder not found: %1$s", name));
        }
        catch (PortalException e) {
            LOG.error((Object)String.format("Error while trying to get folder: %1$s", name), (Throwable)e);
        }
        return dir;
    }

    public static Folder createDocumentFolder(long groupId, long repoId, Long pFolderId, String folderName) {
        Folder folder = null;
        try {
            folder = FolderUtil.findFolder(groupId, pFolderId, folderName);
            if (folder == null) {
                folder = DLAppLocalServiceUtil.addFolder(null, (long)SetupConfigurationThreadLocal.getRunAsUserId(), (long)repoId, (long)pFolderId, (String)folderName, (String)folderName, (ServiceContext)new ServiceContext());
            }
        }
        catch (PortalException | SystemException e) {
            LOG.error(e);
        }
        return folder;
    }
}

