/*
 * Decompiled with CFR 0.152.
 */
package com.ableneo.liferay.portal.setup.core;

import com.ableneo.liferay.portal.setup.SetupConfigurationThreadLocal;
import com.ableneo.liferay.portal.setup.core.util.RolePermissionBuilder;
import com.ableneo.liferay.portal.setup.core.util.WebFolderUtil;
import com.ableneo.liferay.portal.setup.domain.ArticleFolder;
import com.ableneo.liferay.portal.setup.domain.Site;
import com.liferay.journal.model.JournalFolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class SetupWebFolders {
    private static final Map<String, List<String>> DEFAULT_PERMISSIONS;
    public static final String RP_KEY;

    private SetupWebFolders() {
    }

    public static Map<String, List<String>> getDefaultPermissions() {
        return DEFAULT_PERMISSIONS;
    }

    public static void setupWebFolders(Site group, long groupId) {
        long companyId = SetupConfigurationThreadLocal.getRunInCompanyId();
        for (ArticleFolder af : group.getArticleFolder()) {
            JournalFolder jf = WebFolderUtil.findArticleWebFolder(af, groupId);
            WebFolderUtil.updateFolderPermissions(jf, companyId, groupId, DEFAULT_PERMISSIONS, af.getRolePermissions());
        }
    }

    static {
        RP_KEY = SetupWebFolders.class.getSimpleName() + "_DEFAULT_PERMISSIONS";
        RolePermissionBuilder builder = RolePermissionBuilder.create();
        ArrayList<String> actionsOwner = new ArrayList<String>();
        actionsOwner.add("VIEW");
        actionsOwner.add("UPDATE");
        actionsOwner.add("PERMISSIONS");
        actionsOwner.add("DELETE");
        actionsOwner.add("ADD_SUBFOLDER");
        actionsOwner.add("ADD_ARTICLE");
        actionsOwner.add("SUBSCRIBE");
        actionsOwner.add("ACCESS");
        builder.add("Owner", actionsOwner);
        ArrayList<String> actionsUser = new ArrayList<String>();
        actionsUser.add("VIEW");
        builder.add("User", actionsUser);
        ArrayList<String> actionsGuest = new ArrayList<String>();
        actionsGuest.add("VIEW");
        builder.add("Guest", actionsGuest);
        ArrayList<String> actionsViewer = new ArrayList<String>();
        actionsViewer.add("VIEW");
        builder.add("Site Member", actionsViewer);
        builder.storeAsPreset(RP_KEY);
        DEFAULT_PERMISSIONS = builder.buildMapList();
    }
}

