/*
 * Decompiled with CFR 0.152.
 */
package com.ableneo.liferay.portal.setup.core;

import com.ableneo.liferay.portal.setup.SetupConfigurationThreadLocal;
import com.ableneo.liferay.portal.setup.core.util.CustomFieldSettingUtil;
import com.ableneo.liferay.portal.setup.domain.CustomFieldSetting;
import com.ableneo.liferay.portal.setup.domain.Organization;
import com.ableneo.liferay.portal.setup.domain.Role;
import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserGroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class SetupUsers {
    private static final Log LOG = LogFactoryUtil.getLog(SetupUsers.class);
    private static final int DEFAULT_BIRTHDAY_YEAR = 1970;

    private SetupUsers() {
    }

    public static void setupUsers(List<com.ableneo.liferay.portal.setup.domain.User> users) {
        for (com.ableneo.liferay.portal.setup.domain.User user : users) {
            User liferayUser = null;
            long runInCompanyId = SetupConfigurationThreadLocal.getRunInCompanyId();
            try {
                liferayUser = UserLocalServiceUtil.getUserByEmailAddress((long)runInCompanyId, (String)user.getEmailAddress());
                LOG.info((Object)String.format("User %1$s already exist, not creating...", liferayUser.getEmailAddress()));
            }
            catch (NoSuchUserException e) {
                liferayUser = SetupUsers.addUser(user);
            }
            catch (Exception e) {
                LOG.error((Object)String.format("Error by retrieving user %1$s", user.getEmailAddress()));
            }
            if (null != liferayUser) {
                SetupUsers.addUserToOrganizations(user, liferayUser);
                SetupUsers.addRolesToUser(user, liferayUser);
                SetupUsers.addGroupsToUser(user, liferayUser);
                if (user.getCustomFieldSetting() == null || user.getCustomFieldSetting().isEmpty()) continue;
                SetupUsers.setCustomFields(SetupConfigurationThreadLocal.getRunInGroupId(), runInCompanyId, liferayUser, user);
                continue;
            }
            LOG.warn((Object)String.format("Could not create user with screenName '%1$s'", user.getScreenName()));
        }
    }

    private static void setCustomFields(long groupId, long company, User liferayUser, com.ableneo.liferay.portal.setup.domain.User user) {
        Class<?> clazz = liferayUser.getClass();
        for (CustomFieldSetting cfs : user.getCustomFieldSetting()) {
            String resolverHint = "Custom value for user " + user.getScreenName() + ", " + user.getEmailAddress() + " Key " + cfs.getKey() + ", value " + cfs.getValue();
            CustomFieldSettingUtil.setExpandoValue(resolverHint, groupId, company, clazz, liferayUser.getUserId(), cfs.getKey(), cfs.getValue());
        }
    }

    private static User addUser(com.ableneo.liferay.portal.setup.domain.User setupUser) {
        LOG.info((Object)String.format("User %1$s not exists, creating...", setupUser.getEmailAddress()));
        User liferayUser = null;
        long creatorUserId = 0L;
        boolean autoPassword = false;
        String password1 = setupUser.getPassword();
        String password2 = setupUser.getPassword();
        boolean autoScreenName = false;
        boolean male = true;
        String emailAddress = setupUser.getEmailAddress();
        long facebookId = 0L;
        String jobTitle = "";
        String openId = "";
        Locale locale = Locale.US;
        String middleName = "";
        int prefixId = 0;
        int suffixId = 0;
        int birthdayMonth = 0;
        int birthdayDay = 1;
        int birthdayYear = 1970;
        long[] groupIds = new long[]{};
        long[] roleIds = new long[]{};
        long[] organizationIds = new long[]{};
        long[] userGroupIds = null;
        boolean sendEmail = false;
        ServiceContext serviceContext = new ServiceContext();
        int type = 1;
        try {
            liferayUser = UserLocalServiceUtil.addUser((long)creatorUserId, (long)SetupConfigurationThreadLocal.getRunInCompanyId(), (boolean)autoPassword, (String)password1, (String)password2, (boolean)autoScreenName, (String)setupUser.getScreenName(), (String)emailAddress, (Locale)locale, (String)setupUser.getFirstName(), (String)middleName, (String)setupUser.getLastName(), (long)prefixId, (long)suffixId, (boolean)male, (int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, (String)jobTitle, (int)type, (long[])groupIds, (long[])organizationIds, (long[])roleIds, userGroupIds, (boolean)sendEmail, (ServiceContext)serviceContext);
            LOG.info((Object)String.format("User %1$s created", setupUser.getEmailAddress()));
        }
        catch (Exception ex) {
            LOG.error((Object)String.format("Error by adding user %1$s", setupUser.getEmailAddress()), (Throwable)ex);
        }
        return liferayUser;
    }

    private static void addUserToOrganizations(com.ableneo.liferay.portal.setup.domain.User setupUser, User liferayUser) {
        try {
            for (Organization organization : setupUser.getOrganization()) {
                com.liferay.portal.kernel.model.Organization liferayOrganization = OrganizationLocalServiceUtil.getOrganization((long)SetupConfigurationThreadLocal.getRunInCompanyId(), (String)organization.getName());
                UserLocalServiceUtil.addOrganizationUsers((long)liferayOrganization.getOrganizationId(), (long[])new long[]{liferayUser.getUserId()});
                LOG.info((Object)String.format("Adding user %1$s to Organization %2$s", setupUser.getEmailAddress(), liferayOrganization.getName()));
            }
        }
        catch (PortalException | SystemException e) {
            LOG.error((Object)"cannot add users");
        }
    }

    private static void addGroupsToUser(com.ableneo.liferay.portal.setup.domain.User setupUser, User liferayUser) {
        for (com.ableneo.liferay.portal.setup.domain.UserGroup setupGroup : setupUser.getUserGroup()) {
            try {
                long runInCompanyId = SetupConfigurationThreadLocal.getRunInCompanyId();
                UserGroup userGroup = UserGroupLocalServiceUtil.getUserGroup((long)runInCompanyId, (String)setupGroup.getName());
                UserGroupLocalServiceUtil.addUserUserGroup((long)liferayUser.getUserId(), (UserGroup)userGroup);
                LOG.info((Object)String.format("Added user(%1$s) to group(%2$s)", setupUser.getEmailAddress(), setupGroup.getName()));
            }
            catch (PortalException | SystemException e) {
                LOG.error((Object)String.format("Error in adding user(%1$s) to group(%2$s)", setupUser.getEmailAddress(), setupGroup.getName()), e);
            }
        }
    }

    private static void addRolesToUser(com.ableneo.liferay.portal.setup.domain.User setupUser, User liferayUser) {
        try {
            block11: for (Role userRole : setupUser.getRole()) {
                String roleType;
                long runInCompanyId = SetupConfigurationThreadLocal.getRunInCompanyId();
                com.liferay.portal.kernel.model.Role role = RoleLocalServiceUtil.getRole((long)runInCompanyId, (String)userRole.getName());
                long[] roleIds = new long[]{role.getRoleId()};
                switch (roleType = userRole.getType()) {
                    case "portal": {
                        RoleLocalServiceUtil.addUserRoles((long)liferayUser.getUserId(), (long[])roleIds);
                        LOG.info((Object)String.format("Adding regular role %1$s to user %2$s", userRole.getName(), liferayUser.getEmailAddress()));
                        continue block11;
                    }
                    case "site": 
                    case "organization": {
                        Group group = GroupLocalServiceUtil.getGroup((long)runInCompanyId, (String)userRole.getSite());
                        UserGroupRoleLocalServiceUtil.addUserGroupRoles((long)liferayUser.getUserId(), (long)group.getGroupId(), (long[])roleIds);
                        LOG.info((Object)("Adding " + roleType + " role " + userRole.getName() + " to user " + liferayUser.getEmailAddress()));
                        continue block11;
                    }
                }
                LOG.error((Object)String.format("unknown role type %1$s", roleType));
            }
        }
        catch (PortalException | SystemException e) {
            LOG.error((Object)String.format("Error in adding roles to user %1$s", setupUser.getEmailAddress()), e);
        }
    }

    public static void deleteUsers(List<com.ableneo.liferay.portal.setup.domain.User> users, String deleteMethod) {
        switch (deleteMethod) {
            case "excludeListed": {
                Map<String, com.ableneo.liferay.portal.setup.domain.User> usersMap = SetupUsers.convertUserListToHashMap(users);
                List allUsers = UserLocalServiceUtil.getUsers((int)-1, (int)-1);
                for (User user : allUsers) {
                    if (usersMap.containsKey(user.getEmailAddress()) || user.isDefaultUser() || PortalUtil.isOmniadmin((long)user.getUserId())) {
                        LOG.info((Object)String.format("Skipping deletion of system user %1$s", user.getEmailAddress()));
                        continue;
                    }
                    SetupUsers.deteleUser(user);
                }
                break;
            }
            case "onlyListed": {
                for (com.ableneo.liferay.portal.setup.domain.User user : users) {
                    try {
                        String email = user.getEmailAddress();
                        User u = UserLocalServiceUtil.getUserByEmailAddress((long)SetupConfigurationThreadLocal.getRunInCompanyId(), (String)email);
                        UserLocalServiceUtil.deleteUser((User)u);
                        LOG.info((Object)String.format("Deleting User %1$s", email));
                    }
                    catch (PortalException e) {
                        LOG.error((Object)"Unable to delete user.", (Throwable)e);
                    }
                }
                break;
            }
            default: {
                LOG.error((Object)String.format("Unknown delete method : %1$s", deleteMethod));
            }
        }
    }

    private static void deteleUser(User user) {
        try {
            UserLocalServiceUtil.deleteUser((long)user.getUserId());
            LOG.info((Object)String.format("Deleted User %1$s", user.getEmailAddress()));
        }
        catch (PortalException | SystemException e) {
            LOG.error((Object)String.format("Unable to delete user: %1$s", user.getEmailAddresses()), e);
        }
    }

    private static Map<String, com.ableneo.liferay.portal.setup.domain.User> convertUserListToHashMap(List<com.ableneo.liferay.portal.setup.domain.User> objects) {
        HashMap<String, com.ableneo.liferay.portal.setup.domain.User> map = new HashMap<String, com.ableneo.liferay.portal.setup.domain.User>();
        for (com.ableneo.liferay.portal.setup.domain.User user : objects) {
            map.put(user.getEmailAddress(), user);
        }
        return map;
    }
}

