/*
 * Decompiled with CFR 0.152.
 */
package com.ableneo.liferay.portal.setup.core;

import com.ableneo.liferay.portal.setup.SetupConfigurationThreadLocal;
import com.ableneo.liferay.portal.setup.core.util.CustomFieldSettingUtil;
import com.ableneo.liferay.portal.setup.domain.CustomFieldSetting;
import com.ableneo.liferay.portal.setup.domain.Role;
import com.ableneo.liferay.portal.setup.domain.UserAsMember;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserGroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetupUserGroups {
    private static final Logger LOG = LoggerFactory.getLogger(SetupUserGroups.class);

    private SetupUserGroups() {
    }

    public static void setupUserGroups(List<com.ableneo.liferay.portal.setup.domain.UserGroup> userGroups) {
        long userId = SetupConfigurationThreadLocal.getRunAsUserId();
        for (com.ableneo.liferay.portal.setup.domain.UserGroup userGroup : userGroups) {
            UserGroup liferayUserGroup = null;
            long liferayUserGroupId = -1L;
            long companyId = SetupConfigurationThreadLocal.getRunInCompanyId();
            try {
                liferayUserGroup = UserGroupLocalServiceUtil.getUserGroup((long)companyId, (String)userGroup.getName());
                liferayUserGroupId = liferayUserGroup.getUserGroupId();
            }
            catch (PortalException e) {
                LOG.info(String.format("UserGroup does not exists, creating new one for name: %1$s", userGroup.getName()));
            }
            if (liferayUserGroupId == -1L) {
                try {
                    liferayUserGroup = UserGroupLocalServiceUtil.addUserGroup((long)userId, (long)companyId, (String)userGroup.getName(), (String)userGroup.getDescription(), (ServiceContext)new ServiceContext());
                }
                catch (PortalException e) {
                    LOG.error(String.format("Can not create UserGroup with name: %1$s", userGroup.getName()), (Throwable)e);
                    continue;
                }
            }
            if (userGroup.getCustomFieldSetting() != null && !userGroup.getCustomFieldSetting().isEmpty()) {
                SetupUserGroups.setCustomFields(liferayUserGroup, userGroup.getCustomFieldSetting(), userGroup);
            }
            if (!userGroup.getRole().isEmpty() && liferayUserGroup != null) {
                LOG.info("Setting Roles for UserGroup.");
                SetupUserGroups.addRolesToUserGroup(userGroup, liferayUserGroup);
            }
            if (userGroup.getUserAsMember().isEmpty() || liferayUserGroup == null) continue;
            LOG.info("Setting User Members.");
            SetupUserGroups.addUsersToUserGroup(userGroup.getUserAsMember(), liferayUserGroup);
        }
    }

    private static void addUsersToUserGroup(List<UserAsMember> usersAsMember, UserGroup liferayUserGroup) {
        long companyId = SetupConfigurationThreadLocal.getRunInCompanyId();
        for (UserAsMember member : usersAsMember) {
            User user = UserLocalServiceUtil.fetchUserByScreenName((long)companyId, (String)member.getScreenName());
            if (Objects.isNull(user)) {
                LOG.error(String.format("Can not set user %1$s as member of UserGroup. User does not exists...", member.getScreenName()));
                continue;
            }
            try {
                UserGroupLocalServiceUtil.addUserUserGroup((long)user.getUserId(), (long)liferayUserGroup.getUserGroupId());
            }
            catch (PortalException e) {
                LOG.warn("Failed to setup user {} as member of userGroup {}", new Object[]{user.getScreenName(), liferayUserGroup.getName(), e});
            }
            LOG.info(String.format("User %1$s successfully added as a member to UserGroup %2$s", user.getScreenName(), liferayUserGroup.getName()));
        }
    }

    private static void setCustomFields(UserGroup liferayUserGroup, List<CustomFieldSetting> customFieldSettings, com.ableneo.liferay.portal.setup.domain.UserGroup userGroup) {
        if (liferayUserGroup == null) {
            return;
        }
        Class<UserGroup> clazz = UserGroup.class;
        for (CustomFieldSetting cfs : customFieldSettings) {
            String resolverHint = "Custom value for userGroup " + userGroup.getName() + ",  Key " + cfs.getKey() + ", value " + cfs.getValue();
            long company = SetupConfigurationThreadLocal.getRunInCompanyId();
            CustomFieldSettingUtil.setExpandoValue(resolverHint, liferayUserGroup.getUserGroupId(), company, clazz, liferayUserGroup.getUserGroupId(), cfs.getKey(), cfs.getValue());
        }
    }

    private static void addRolesToUserGroup(com.ableneo.liferay.portal.setup.domain.UserGroup userGroup, UserGroup liferayUserGroup) {
        try {
            block12: for (Role role : userGroup.getRole()) {
                String roleType;
                long companyId = SetupConfigurationThreadLocal.getRunInCompanyId();
                com.liferay.portal.kernel.model.Role liferayRole = RoleLocalServiceUtil.getRole((long)companyId, (String)role.getName());
                switch (roleType = role.getType()) {
                    case "regular": 
                    case "portal": {
                        GroupLocalServiceUtil.addRoleGroup((long)liferayRole.getRoleId(), (long)liferayUserGroup.getGroupId());
                        LOG.info(String.format("Adding role %1$s to userGroup %2$s", liferayRole.getDescriptiveName(), liferayUserGroup.getName()));
                        continue block12;
                    }
                    case "site": 
                    case "organization": {
                        LOG.error("Adding site or organization roles to UserGroup is not supported. Bind userGroups to Site Roles within the Site elemennt.");
                        continue block12;
                    }
                }
                LOG.error(String.format("unknown role type %1$s", roleType));
            }
        }
        catch (PortalException | SystemException e) {
            LOG.error(String.format("Error in adding roles to userGroup %1$s", userGroup.getName()), e);
        }
    }
}

