/*
 * Decompiled with CFR 0.152.
 */
package com.ableneo.liferay.portal.setup.core;

import com.ableneo.liferay.portal.setup.SetupConfigurationThreadLocal;
import com.ableneo.liferay.portal.setup.core.SetupArticles;
import com.ableneo.liferay.portal.setup.core.SetupCategorization;
import com.ableneo.liferay.portal.setup.core.SetupDocumentFolders;
import com.ableneo.liferay.portal.setup.core.SetupDocuments;
import com.ableneo.liferay.portal.setup.core.SetupMenus;
import com.ableneo.liferay.portal.setup.core.SetupPages;
import com.ableneo.liferay.portal.setup.core.SetupWebFolders;
import com.ableneo.liferay.portal.setup.core.util.CustomFieldSettingUtil;
import com.ableneo.liferay.portal.setup.core.util.TranslationMapUtil;
import com.ableneo.liferay.portal.setup.domain.CustomFieldSetting;
import com.ableneo.liferay.portal.setup.domain.Membership;
import com.ableneo.liferay.portal.setup.domain.Site;
import com.ableneo.liferay.portal.setup.domain.Staging;
import com.ableneo.liferay.portal.setup.domain.UserAsMember;
import com.ableneo.liferay.portal.setup.domain.UserGroupAsMember;
import com.liferay.exportimport.kernel.service.StagingLocalServiceUtil;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserGroupGroupRoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SetupSites {
    private static final String UNIPARAM_DEFAULT_SITE_ROLE_IDS = "defaultSiteRoleIds";
    private static final Log LOG = LogFactoryUtil.getLog(SetupSites.class);

    private SetupSites() {
    }

    public static void setupSites(List<Site> siteList, Group parentGroup) throws PortalException {
        long companyId = SetupConfigurationThreadLocal.getRunInCompanyId();
        for (Site site : siteList) {
            Group liferayGroup = SetupSites.setupSite(parentGroup, companyId, site);
            List<Site> sites = site.getSite();
            SetupSites.setupSites(sites, liferayGroup);
        }
    }

    private static Group setupSite(Group parentGroup, long companyId, Site site) throws PortalException {
        Group liferayGroup = null;
        long groupId = -1L;
        if (site.isDefault()) {
            liferayGroup = GroupLocalServiceUtil.getGroup((long)companyId, (String)"Guest");
            LOG.info((Object)String.format("Setup: default site. Group ID: %1$s", groupId));
        } else if (site.getName() == null) {
            liferayGroup = GroupLocalServiceUtil.getCompanyGroup((long)companyId);
            LOG.info((Object)String.format("Setup: global site. Group ID: %1$s", groupId));
        } else {
            try {
                liferayGroup = GroupLocalServiceUtil.getGroup((long)companyId, (String)site.getName());
                LOG.info((Object)String.format("Setup: Site %1$s already exists in system, not creating... (pk=%2$s,gid=%3$s)", site.getName(), liferayGroup.getPrimaryKey(), liferayGroup.getGroupId()));
            }
            catch (PortalException e) {
                LOG.debug((Object)"Site does not exist.", (Throwable)e);
            }
        }
        ServiceContext serviceContext = new ServiceContext();
        if (liferayGroup == null) {
            LOG.info((Object)String.format("Setup: Group (Site) %1$s does not exist in system, creating...", site.getName()));
            liferayGroup = GroupLocalServiceUtil.addGroup((long)SetupConfigurationThreadLocal.getRunAsUserId(), (long)0L, (String)Group.class.getName(), (long)0L, (long)0L, TranslationMapUtil.getTranslationMap(site.getNameTranslation(), groupId, site.getName(), site.getName()), null, (int)site.getMembershipType(), (boolean)true, (int)0, (String)site.getSiteFriendlyUrl(), (boolean)true, (boolean)true, (ServiceContext)serviceContext);
            LOG.info((Object)String.format("New site created.", new Object[0]));
        } else {
            LOG.info((Object)String.format("Updating site: %1$s", site.getName()));
            GroupLocalServiceUtil.updateFriendlyURL((long)liferayGroup.getGroupId(), (String)site.getSiteFriendlyUrl());
        }
        groupId = liferayGroup.getGroupId();
        LOG.info((Object)String.format(" - Group ID: %1$s", groupId));
        SetupSites.setSitePropertiesTo(site, liferayGroup);
        if (parentGroup != null && liferayGroup != null && site.isMaintainSiteHierarchy()) {
            liferayGroup.setParentGroupId(parentGroup.getGroupId());
            GroupLocalServiceUtil.updateGroup((Group)liferayGroup);
        } else if (liferayGroup != null && site.isMaintainSiteHierarchy()) {
            liferayGroup.setParentGroupId(0L);
            GroupLocalServiceUtil.updateGroup((Group)liferayGroup);
        }
        if (liferayGroup == null) {
            LOG.error((Object)String.format("Failed to create or update site (not found): %1$s", site.getName()));
            return null;
        }
        LOG.info((Object)"Setting site content...");
        SetupConfigurationThreadLocal.configureGroupExecutionContext(liferayGroup);
        long userId = SetupConfigurationThreadLocal.getRunAsUserId();
        SetupSites.setStaging(userId, liferayGroup, site.getStaging());
        Group stagingGroup = liferayGroup.getStagingGroup();
        if (Objects.nonNull(stagingGroup)) {
            groupId = stagingGroup.getGroupId();
        }
        SetupDocumentFolders.setupDocumentFolders(site, groupId);
        LOG.info((Object)"Document Folders setting finished.");
        SetupDocuments.setupSiteDocuments(site, groupId);
        LOG.info((Object)"Documents setting finished.");
        SetupArticles.setupSiteStructuresAndTemplates(site, groupId);
        LOG.info((Object)"Site DDM structures and templates setting finished.");
        SetupPages.setupSitePages(site, groupId);
        LOG.info((Object)"Site Pages setting finished.");
        SetupWebFolders.setupWebFolders(site, groupId);
        LOG.info((Object)"Web folders setting finished.");
        SetupCategorization.setupVocabularies(site.getVocabulary(), groupId);
        LOG.info((Object)"Site Categories setting finished.");
        SetupArticles.setupSiteArticles(site.getArticle(), site.getAdt(), site.getDdlRecordset(), groupId);
        LOG.info((Object)"Site Articles setting finished.");
        SetupSites.setCustomFields(groupId, site.getCustomFieldSetting());
        LOG.info((Object)"Site custom fields set up.");
        SetupMenus.setMenus(groupId, site.getMenu());
        LOG.info((Object)"Site menus set up.");
        SetupPages.setupSitePortlets(site, groupId);
        LOG.info((Object)"Site Portlets setting finished.");
        SetupSites.setMembership(site.getMembership(), companyId, groupId);
        return liferayGroup;
    }

    private static void setSitePropertiesTo(Site site, Group liferayGroup) {
        if (site.getSitePreferences() != null) {
            UnicodeProperties props = liferayGroup.getTypeSettingsProperties();
            if (props == null) {
                props = new UnicodeProperties();
                liferayGroup.setTypeSettingsProperties(props);
            }
            if (site.getSitePreferences().isMentionsEnabled() != null) {
                props.setProperty("mentionsEnabled", site.getSitePreferences().isMentionsEnabled().toString());
            }
            if (site.getSitePreferences().isSharingEnabled() != null) {
                props.setProperty("sharingEnabled", site.getSitePreferences().isSharingEnabled().toString());
            }
            if (site.getSitePreferences().isInheritLocales() != null) {
                props.setProperty("inheritLocales", site.getSitePreferences().isInheritLocales().toString());
            }
            if (site.getSitePreferences().getLanguageId() != null) {
                props.setProperty("languageId", site.getSitePreferences().getLanguageId().toString());
            }
            if (site.getSitePreferences().getLocales() != null && !site.getSitePreferences().getLocales().isEmpty()) {
                props.setProperty("locales", StringUtil.merge(site.getSitePreferences().getLocales(), (String)","));
            }
        }
    }

    private static void setMembership(Membership membership, long companyId, long groupId) {
        if (Objects.isNull(membership)) {
            return;
        }
        List<UserGroupAsMember> memberGroups = membership.getUserGroupAsMember();
        SetupSites.assignMemberGroups(memberGroups, companyId, groupId);
        List<UserAsMember> memberUsers = membership.getUserAsMember();
        SetupSites.assignMemberUsers(memberUsers, companyId, groupId);
        List<com.ableneo.liferay.portal.setup.domain.Role> memberRoles = membership.getRole();
        SetupSites.assignMemberRoles(memberRoles, companyId, groupId);
    }

    private static void assignMemberUsers(List<UserAsMember> memberUsers, long companyId, long groupId) {
        if (Objects.isNull(memberUsers) || memberUsers.isEmpty()) {
            return;
        }
        for (UserAsMember memberUser : memberUsers) {
            User user = UserLocalServiceUtil.fetchUserByScreenName((long)companyId, (String)memberUser.getScreenName());
            if (Objects.isNull(user)) {
                LOG.error((Object)String.format("User with screenName %1$s does not exists. Won't be assigned as site member.", memberUser.getScreenName()));
                continue;
            }
            try {
                Group liferayGroup = GroupLocalServiceUtil.getGroup((long)groupId);
                GroupLocalServiceUtil.addUserGroup((long)user.getUserId(), (long)liferayGroup.getGroupId());
                LOG.info((Object)String.format("User %1$s was assigned as member of site %2$s", user.getScreenName(), liferayGroup.getDescriptiveName()));
                SetupSites.assignUserMemberRoles(memberUser.getRole(), companyId, liferayGroup, user);
            }
            catch (PortalException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private static void assignUserMemberRoles(List<com.ableneo.liferay.portal.setup.domain.Role> membershipRoles, long companyId, Group liferayGroup, User liferayUser) {
        if (Objects.isNull(membershipRoles) || membershipRoles.isEmpty()) {
            return;
        }
        for (com.ableneo.liferay.portal.setup.domain.Role membershipRole : membershipRoles) {
            try {
                Role liferayRole = RoleLocalServiceUtil.getRole((long)companyId, (String)membershipRole.getName());
                UserGroupRoleLocalServiceUtil.addUserGroupRoles((long)liferayUser.getUserId(), (long)liferayGroup.getGroupId(), (long[])new long[]{liferayRole.getRoleId()});
                StringBuilder sb = new StringBuilder("Role ").append(liferayRole.getDescriptiveName()).append(" assigned to User ").append(liferayUser.getScreenName()).append(" for site ").append(liferayGroup.getDescriptiveName());
                LOG.info((Object)sb.toString());
            }
            catch (PortalException e) {
                LOG.error((Object)String.format("Can not add role with name%1$s does not exists. Will not be assigned.", membershipRole.getName()));
            }
        }
    }

    private static void assignMemberRoles(List<com.ableneo.liferay.portal.setup.domain.Role> membershipRoles, long companyId, long groupId) {
        if (Objects.isNull(membershipRoles) || membershipRoles.isEmpty()) {
            return;
        }
        HashSet<String> roles = new HashSet<String>();
        for (com.ableneo.liferay.portal.setup.domain.Role membershipRole : membershipRoles) {
            try {
                Role liferayRole = RoleLocalServiceUtil.getRole((long)companyId, (String)membershipRole.getName());
                roles.add(String.valueOf(liferayRole.getRoleId()));
            }
            catch (PortalException e) {
                LOG.error((Object)String.format("Can not get role with name%1$s does not exists. Will not be assigned.", membershipRole.getName()));
            }
        }
        if (roles.isEmpty()) {
            LOG.info((Object)("NO new roles to be assigned to site " + groupId));
            return;
        }
        try {
            String roleIds;
            Group liferayGroup = GroupLocalServiceUtil.getGroup((long)groupId);
            UnicodeProperties siteGroupProps = liferayGroup.getTypeSettingsProperties();
            if (siteGroupProps == null) {
                siteGroupProps = new UnicodeProperties();
            }
            if ((roleIds = siteGroupProps.getProperty(UNIPARAM_DEFAULT_SITE_ROLE_IDS)) != null && roleIds.length() > 1) {
                String[] roleIdArr = roleIds.split("[,;]+");
                roles.addAll(Arrays.asList(roleIdArr));
            }
            roleIds = StringUtil.merge(roles, (String)",");
            siteGroupProps.setProperty(UNIPARAM_DEFAULT_SITE_ROLE_IDS, roleIds);
            liferayGroup.setTypeSettingsProperties(siteGroupProps);
            GroupLocalServiceUtil.updateGroup((Group)liferayGroup);
            StringBuilder sb = new StringBuilder("Roles ").append(roleIds).append(" assigned to site-group ").append(liferayGroup.getDescriptiveName());
            LOG.info((Object)sb.toString());
        }
        catch (Exception e) {
            LOG.error((Object)("Can not set roles to site-group (" + roles + ")=>" + groupId), (Throwable)e);
        }
    }

    private static void assignMemberGroups(List<UserGroupAsMember> memberGroups, long companyId, long groupId) {
        if (Objects.isNull(memberGroups) || memberGroups.isEmpty()) {
            return;
        }
        for (UserGroupAsMember memberGroup : memberGroups) {
            try {
                UserGroup liferayUserGroup = UserGroupLocalServiceUtil.getUserGroup((long)companyId, (String)memberGroup.getUserGroupName());
                Group liferayGroup = GroupLocalServiceUtil.getGroup((long)groupId);
                GroupLocalServiceUtil.addUserGroupGroup((long)liferayUserGroup.getUserGroupId(), (Group)liferayGroup);
                LOG.info((Object)String.format("UserGroup %1$s was assigned as site member to %2$s", liferayUserGroup.getName(), liferayGroup.getDescriptiveName()));
                SetupSites.assignGroupMemberRoles(memberGroup.getRole(), companyId, liferayGroup, liferayUserGroup);
            }
            catch (PortalException e) {
                LOG.error((Object)String.format("Cannot find UserGroup with name: %1$s. Group won't be assigned to site.", memberGroup.getUserGroupName()), (Throwable)e);
            }
        }
    }

    private static void assignGroupMemberRoles(List<com.ableneo.liferay.portal.setup.domain.Role> membershipRoles, long companyId, Group liferayGroup, UserGroup liferayUserGroup) {
        if (Objects.isNull(membershipRoles) || membershipRoles.isEmpty()) {
            return;
        }
        for (com.ableneo.liferay.portal.setup.domain.Role membershipRole : membershipRoles) {
            try {
                Role liferayRole = RoleLocalServiceUtil.getRole((long)companyId, (String)membershipRole.getName());
                UserGroupGroupRoleLocalServiceUtil.addUserGroupGroupRoles((long)liferayUserGroup.getUserGroupId(), (long)liferayGroup.getGroupId(), (long[])new long[]{liferayRole.getRoleId()});
                StringBuilder sb = new StringBuilder("Role[").append(liferayRole.getTypeLabel()).append("] ").append(liferayRole.getDescriptiveName()).append(" assigned to UserGroup ").append(liferayUserGroup.getName()).append(" for site ").append(liferayGroup.getDescriptiveName());
                LOG.info((Object)sb.toString());
            }
            catch (PortalException e) {
                LOG.error((Object)String.format("Can not add role with name%1$s does not exists. Will not be assigned.", membershipRole.getName()));
            }
        }
    }

    static void setStaging(long userId, Group liveGroup, Staging staging) {
        if (Objects.isNull(staging)) {
            LOG.info((Object)"No staging configuration present for site.");
            return;
        }
        LOG.info((Object)String.format("Setting up staging for site: %1$s", liveGroup.getName()));
        try {
            ServiceContext serviceContext;
            if (staging.getType().equals("local")) {
                serviceContext = new ServiceContext();
                serviceContext.setAttribute("staged--staged-portlet_#--".replace("#", "com_liferay_dynamic_data_mapping_web_portlet_PortletDisplayTemplatePortlet"), (Serializable)Boolean.valueOf(staging.isStageAdt()));
                SetupSites.setStagingParam(staging.isStageAdt(), "com_liferay_dynamic_data_mapping_web_portlet_PortletDisplayTemplatePortlet", serviceContext);
                SetupSites.setStagingParam(staging.isStageBlogs(), "com_liferay_blogs_web_portlet_BlogsPortlet", serviceContext);
                SetupSites.setStagingParam(staging.isStageBookmarks(), "com_liferay_bookmarks_web_portlet_BookmarksPortlet", serviceContext);
                SetupSites.setStagingParam(staging.isStageCalendar(), "com_liferay_calendar_web_portlet_CalendarPortlet", serviceContext);
                SetupSites.setStagingParam(staging.isStageDdl(), "com_liferay_dynamic_data_lists_web_portlet_DDLPortlet", serviceContext);
                SetupSites.setStagingParam(staging.isStageDocumentLibrary(), "com_liferay_document_library_web_portlet_DLPortlet", serviceContext);
                SetupSites.setStagingParam(staging.isStageForms(), "com_liferay_dynamic_data_lists_form_web_portlet_DDLFormAdminPortlet", serviceContext);
                SetupSites.setStagingParam(staging.isStageMessageBoards(), "com_liferay_message_boards_web_portlet_MBAdminPortlet", serviceContext);
                SetupSites.setStagingParam(staging.isStageMobileRules(), "com_liferay_mobile_device_rules_web_portlet_MDRPortlet", serviceContext);
                SetupSites.setStagingParam(staging.isStagePolls(), "com_liferay_polls_web_portlet_PollsPortlet", serviceContext);
                SetupSites.setStagingParam(staging.isStageWebContent(), "com_liferay_journal_web_portlet_JournalPortlet", serviceContext);
                SetupSites.setStagingParam(staging.isStageWiki(), "com_liferay_wiki_web_portlet_WikiPortlet", serviceContext);
                StagingLocalServiceUtil.enableLocalStaging((long)userId, (Group)liveGroup, (boolean)staging.isBranchingPublic(), (boolean)staging.isBranchingPrivate(), (ServiceContext)serviceContext);
                LOG.info((Object)"Local staging switched on.");
            }
            if (staging.getType().equals("remote")) {
                LOG.error((Object)"Remote staging setup is not supported, yet. Staging not set up.");
            }
            if (staging.getType().equals("none") && liveGroup.hasLocalOrRemoteStagingGroup()) {
                serviceContext = new ServiceContext();
                serviceContext.setUserId(userId);
                serviceContext.setAttribute("forceDisable", (Serializable)Boolean.valueOf(true));
                StagingLocalServiceUtil.disableStaging((Group)liveGroup, (ServiceContext)serviceContext);
                LOG.info((Object)"Staging switched off.");
            }
        }
        catch (PortalException e) {
            LOG.error((Object)"Error while setting up staging.", (Throwable)e);
        }
    }

    private static void setStagingParam(boolean isParamOn, String portletId, ServiceContext serviceContext) {
        serviceContext.setAttribute("staged--staged-portlet_#--".replace("#", portletId), (Serializable)((Object)String.valueOf(isParamOn)));
    }

    static void setCustomFields(long groupId, List<CustomFieldSetting> customFieldSettings) {
        if (customFieldSettings == null || customFieldSettings.isEmpty()) {
            LOG.info((Object)"Site does has no Expando field settings.");
        } else {
            Class<Group> clazz = Group.class;
            String resolverHint = "Resolving customized value failed for key %1$s and value %2$s";
            for (CustomFieldSetting cfs : customFieldSettings) {
                String key = cfs.getKey();
                String value = cfs.getValue();
                CustomFieldSettingUtil.setExpandoValue(String.format(resolverHint, key, value), groupId, SetupConfigurationThreadLocal.getRunInCompanyId(), clazz, groupId, key, value);
            }
        }
    }

    public static void deleteSite(List<Site> sites, String deleteMethod) {
        switch (deleteMethod) {
            case "excludeListed": {
                Map<String, Site> toBeDeletedOrganisations = SetupSites.convertSiteListToHashMap(sites);
                try {
                    for (Group siteGroup : GroupLocalServiceUtil.getGroups((int)-1, (int)-1)) {
                        if (toBeDeletedOrganisations.containsKey(siteGroup.getName())) continue;
                        SetupSites.deleteLiferayGroup(siteGroup);
                    }
                    break;
                }
                catch (SystemException e) {
                    LOG.error((Object)"Error by retrieving sites!", (Throwable)e);
                    break;
                }
            }
            case "onlyListed": {
                for (Site site : sites) {
                    String name = site.getName();
                    try {
                        Group o = GroupLocalServiceUtil.getGroup((long)SetupConfigurationThreadLocal.getRunInGroupId(), (String)name);
                        GroupLocalServiceUtil.deleteGroup((Group)o);
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error by deleting Site !", (Throwable)e);
                    }
                    LOG.info((Object)String.format("Deleting Site %1$s", name));
                }
                break;
            }
            default: {
                LOG.error((Object)String.format("Unknown delete method : %1$s", deleteMethod));
            }
        }
    }

    private static void deleteLiferayGroup(Group siteGroup) {
        try {
            GroupLocalServiceUtil.deleteGroup((long)siteGroup.getGroupId());
            LOG.info((Object)String.format("Deleting Site %1$s", siteGroup.getName()));
        }
        catch (Exception e) {
            LOG.error((Object)"Error by deleting Site !", (Throwable)e);
        }
    }

    public static void addSiteUser(Group group, User user) {
        LOG.info((Object)String.format("Adding user with screenName: %1$sto group with name: %2$s", user.getScreenName(), group.getName()));
        GroupLocalServiceUtil.addUserGroup((long)user.getUserId(), (Group)group);
    }

    public static void addSiteUsers(Group group, User ... users) {
        for (int i = 0; i < users.length; ++i) {
            SetupSites.addSiteUser(group, users[i]);
        }
    }

    private static Map<String, Site> convertSiteListToHashMap(List<Site> objects) {
        HashMap<String, Site> map = new HashMap<String, Site>();
        for (Site site : objects) {
            map.put(site.getName(), site);
        }
        return map;
    }
}

