/*
 * Decompiled with CFR 0.152.
 */
package com.ableneo.liferay.portal.setup.core;

import com.ableneo.liferay.portal.setup.SetupConfigurationThreadLocal;
import com.ableneo.liferay.portal.setup.core.SetupCategorization;
import com.ableneo.liferay.portal.setup.domain.DeleteServiceAccessPolicy;
import com.ableneo.liferay.portal.setup.domain.ServiceAccessPolicies;
import com.ableneo.liferay.portal.setup.domain.ServiceAccessPolicy;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.security.service.access.policy.exception.NoSuchEntryException;
import com.liferay.portal.security.service.access.policy.model.SAPEntry;
import com.liferay.portal.security.service.access.policy.service.SAPEntryLocalServiceUtil;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetupServiceAccessPolicies {
    protected static final Pattern ALL_WHITE_SPACE_CHARACTERS = Pattern.compile("\\W");
    private static final Logger LOG = LoggerFactory.getLogger(SetupCategorization.class);

    public static void setupServiceAccessPolicies(ServiceAccessPolicies serviceAccessPolicies) {
        List<ServiceAccessPolicy> serviceAccessPolicyList = serviceAccessPolicies.getServiceAccessPolicy();
        Long runInCompanyId = SetupConfigurationThreadLocal.getRunInCompanyId();
        serviceAccessPolicyList.forEach(serviceAccessPolicyConfiguration -> {
            HashMap<Locale, String> titleMap = new HashMap<Locale, String>();
            serviceAccessPolicyConfiguration.getTitle().forEach(title -> titleMap.put(LocaleUtil.fromLanguageId((String)title.getLocale()), title.getText()));
            SAPEntry sapEntry = SetupServiceAccessPolicies.getSapEntry(runInCompanyId, serviceAccessPolicyConfiguration.getName());
            if (sapEntry == null) {
                SetupServiceAccessPolicies.addSAPEntry(serviceAccessPolicyConfiguration, titleMap);
            } else {
                sapEntry.setEnabled(serviceAccessPolicyConfiguration.isEnabled());
                sapEntry.setDefaultSAPEntry(serviceAccessPolicyConfiguration.isUnauthenticated());
                String allowedServiceSignatures = SetupServiceAccessPolicies.cleanUpAllowedServiceSignatures(serviceAccessPolicyConfiguration.getAllowedServiceSignatures());
                sapEntry.setAllowedServiceSignatures(allowedServiceSignatures);
                if (!titleMap.isEmpty()) {
                    sapEntry.setTitleMap(titleMap);
                }
                SetupServiceAccessPolicies.updateSAPEntry(sapEntry);
            }
        });
        List<DeleteServiceAccessPolicy> deleteServiceAccessPolicyList = serviceAccessPolicies.getDeleteServiceAccessPolicy();
        deleteServiceAccessPolicyList.forEach(deleteServiceAccessPolicy -> {
            SAPEntry sapEntry = SetupServiceAccessPolicies.getSapEntry(runInCompanyId, deleteServiceAccessPolicy.getName());
            if (sapEntry != null) {
                SetupServiceAccessPolicies.deleteSAPEntry(sapEntry);
            } else {
                LOG.warn("Tried to delete SAP Entry {} in company {} but the entry haven't been found.", (Object)deleteServiceAccessPolicy.getName(), (Object)runInCompanyId);
            }
        });
    }

    public static String cleanUpAllowedServiceSignatures(String allowedServiceSignatures) {
        if (allowedServiceSignatures == null || ALL_WHITE_SPACE_CHARACTERS.matcher(allowedServiceSignatures).replaceAll("").isEmpty()) {
            return "";
        }
        String normalizedMultilineConfiguration = new BufferedReader(new StringReader(allowedServiceSignatures)).lines().filter(line -> !line.trim().isEmpty()).reduce("", (result, element) -> result.concat(element.trim() + "\n"));
        return normalizedMultilineConfiguration.substring(0, normalizedMultilineConfiguration.length() - 1);
    }

    private static void deleteSAPEntry(SAPEntry sapEntry) {
        try {
            SAPEntryLocalServiceUtil.deleteSAPEntry((SAPEntry)sapEntry);
        }
        catch (PortalException e) {
            LOG.error("Unexpected exception when trying to delete SAP Entry {} in company {}", new Object[]{sapEntry.getName(), sapEntry.getCompanyId(), e});
        }
    }

    protected static void updateSAPEntry(SAPEntry sapEntry) {
        SAPEntryLocalServiceUtil.updateSAPEntry((SAPEntry)sapEntry);
    }

    protected static void addSAPEntry(ServiceAccessPolicy serviceAccessPolicyConfiguration, Map<Locale, String> titleMap) {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(SetupConfigurationThreadLocal.getRunInCompanyId().longValue());
        Long runAsUserId = SetupConfigurationThreadLocal.getRunAsUserId();
        try {
            SAPEntryLocalServiceUtil.addSAPEntry((long)runAsUserId, (String)serviceAccessPolicyConfiguration.getAllowedServiceSignatures(), (boolean)serviceAccessPolicyConfiguration.isUnauthenticated(), (boolean)serviceAccessPolicyConfiguration.isEnabled(), (String)serviceAccessPolicyConfiguration.getName(), titleMap, (ServiceContext)serviceContext);
        }
        catch (PortalException e) {
            LOG.error("Unexpected exception trying to add SAP Entry {} to company {} with a user {}", new Object[]{serviceAccessPolicyConfiguration.getName(), serviceContext.getCompanyId(), runAsUserId, e});
        }
    }

    protected static SAPEntry getSapEntry(Long companyId, String name) {
        try {
            return SAPEntryLocalServiceUtil.getSAPEntry((long)companyId, (String)name);
        }
        catch (NoSuchEntryException e) {
            LOG.debug("SAP Entry {} not found in company {}", (Object)name, (Object)companyId);
        }
        catch (PortalException e) {
            LOG.error("Unexpected exception when trying to fetch SAP Entry {} from company {}", (Object)name, (Object)companyId);
        }
        return null;
    }
}

