/*
 * Decompiled with CFR 0.152.
 */
package com.ableneo.liferay.portal.setup.core;

import com.ableneo.liferay.portal.setup.SetupConfigurationThreadLocal;
import com.ableneo.liferay.portal.setup.core.SetupPermissions;
import com.ableneo.liferay.portal.setup.core.util.ResolverUtil;
import com.ableneo.liferay.portal.setup.domain.DefinePermission;
import com.ableneo.liferay.portal.setup.domain.DefinePermissions;
import com.ableneo.liferay.portal.setup.domain.PermissionAction;
import com.ableneo.liferay.portal.setup.domain.Role;
import com.liferay.portal.kernel.dao.orm.ObjectNotFoundException;
import com.liferay.portal.kernel.exception.NoSuchRoleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.RequiredRoleException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class SetupRoles {
    private static final Log LOG = LogFactoryUtil.getLog(SetupRoles.class);
    public static final String SCOPE_INDIVIDUAL = "individual";
    public static final String SCOPE_SITE = "site";
    public static final String SCOPE_SITE_TEMPLATE = "site template";
    public static final String SCOPE_PORTAL = "portal";

    private SetupRoles() {
    }

    public static void setupRoles(List<Role> roles) {
        for (Role role : roles) {
            try {
                long companyId = SetupConfigurationThreadLocal.getRunInCompanyId();
                RoleLocalServiceUtil.getRole((long)companyId, (String)role.getName());
                LOG.info((Object)String.format("Setup: Role %s already exists in company %s, not creating...", role.getName(), companyId));
            }
            catch (ObjectNotFoundException | NoSuchRoleException e) {
                SetupRoles.addRole(role);
            }
            catch (PortalException | SystemException e) {
                LOG.error((Object)"error while setting up roles", e);
            }
            SetupRoles.addRolePermissions(role);
        }
    }

    private static void addRole(Role role) {
        HashMap<Locale, String> localeTitleMap = new HashMap<Locale, String>();
        localeTitleMap.put(Locale.ENGLISH, role.getName());
        try {
            int roleType = 1;
            if (role.getType() != null) {
                if (role.getType().equals(SCOPE_SITE)) {
                    roleType = 2;
                } else if (role.getType().equals("organization")) {
                    roleType = 3;
                }
            }
            long companyId = SetupConfigurationThreadLocal.getRunInCompanyId();
            long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
            RoleLocalServiceUtil.addRole((long)defaultUserId, null, (long)0L, (String)role.getName(), localeTitleMap, null, (int)roleType, null, null);
            LOG.info((Object)String.format("Setup: Role %s does not exist in company %s, adding...", role.getName(), companyId));
        }
        catch (PortalException | SystemException e) {
            LOG.error((Object)"error while adding up roles", e);
        }
    }

    public static void deleteRoles(List<Role> roles, String deleteMethod) {
        long companyId = SetupConfigurationThreadLocal.getRunInCompanyId();
        switch (deleteMethod) {
            case "excludeListed": {
                Map<String, Role> toBeDeletedRoles = SetupRoles.convertRoleListToHashMap(roles);
                try {
                    for (com.liferay.portal.kernel.model.Role role : RoleLocalServiceUtil.getRoles((int)-1, (int)-1)) {
                        String name = role.getName();
                        if (toBeDeletedRoles.containsKey(name)) continue;
                        try {
                            RoleLocalServiceUtil.deleteRole((com.liferay.portal.kernel.model.Role)RoleLocalServiceUtil.getRole((long)companyId, (String)name));
                            LOG.info((Object)String.format("Deleting Role %1$s", name));
                        }
                        catch (Exception e) {
                            LOG.info((Object)String.format("Skipping deletion fo system role %1$s", name));
                        }
                    }
                    break;
                }
                catch (SystemException e) {
                    LOG.error((Object)"problem with deleting roles", (Throwable)e);
                    break;
                }
            }
            case "onlyListed": {
                for (Role role : roles) {
                    String name = role.getName();
                    try {
                        RoleLocalServiceUtil.deleteRole((com.liferay.portal.kernel.model.Role)RoleLocalServiceUtil.getRole((long)companyId, (String)name));
                        LOG.info((Object)String.format("Deleting Role %1$s", name));
                    }
                    catch (RequiredRoleException e) {
                        LOG.info((Object)String.format("Skipping deletion fo system role %1$s", name));
                    }
                    catch (PortalException | SystemException e) {
                        LOG.error((Object)"Unable to delete role.", e);
                    }
                }
                break;
            }
            default: {
                LOG.error((Object)String.format("Unknown delete method : %1$s", deleteMethod));
            }
        }
    }

    private static void addRolePermissions(Role role) {
        if (role.getDefinePermissions() != null) {
            DefinePermissions permissions;
            String siteName = role.getSite();
            if (siteName != null && !siteName.equals("")) {
                LOG.warn((Object)String.format("Note, refering a site inside a role definition makes no sense and will be ignored! This is:%1$s; When doing so, it is necessary to refer a site!", "attribute is intended to be used for refering assigning a site role to an Liferay object, such as a user!", siteName));
            }
            if ((permissions = role.getDefinePermissions()).getDefinePermission() != null && !permissions.getDefinePermission().isEmpty()) {
                for (DefinePermission permission : permissions.getDefinePermission()) {
                    String permissionName = permission.getDefinePermissionName();
                    String resourcePrimKey = "0";
                    long companyId = SetupConfigurationThreadLocal.getRunInCompanyId();
                    if (permission.getElementPrimaryKey() != null) {
                        long groupId = SetupConfigurationThreadLocal.getRunInGroupId();
                        resourcePrimKey = ResolverUtil.lookupAll(groupId, companyId, permission.getElementPrimaryKey(), String.format("Role %1$s permission name %2$s", role.getName(), permissionName));
                    }
                    String type = role.getType();
                    int scope = 1;
                    if (type != null && type.equalsIgnoreCase(SCOPE_PORTAL)) {
                        scope = 1;
                    }
                    if (type != null && type.equalsIgnoreCase(SCOPE_SITE)) {
                        scope = 3;
                    }
                    if (type != null && type.equalsIgnoreCase("organization")) {
                        scope = 3;
                    }
                    if (scope == 1 && !resourcePrimKey.equals("0")) {
                        scope = 2;
                    }
                    if (scope == 1 && resourcePrimKey.equals("0")) {
                        resourcePrimKey = Long.toString(companyId);
                    }
                    if (permission.getScope() != null && !permission.getScope().equals("")) {
                        if (permission.getScope().equalsIgnoreCase(SCOPE_PORTAL)) {
                            scope = 1;
                        } else if (permission.getScope().equalsIgnoreCase(SCOPE_SITE_TEMPLATE)) {
                            scope = 3;
                        } else if (permission.getScope().equalsIgnoreCase(SCOPE_SITE)) {
                            scope = 2;
                        } else if (permission.getScope().equalsIgnoreCase(SCOPE_INDIVIDUAL)) {
                            scope = 4;
                        }
                    }
                    if (permission.getPermissionAction() == null || permission.getPermissionAction().isEmpty()) continue;
                    ArrayList<String> listOfActions = new ArrayList<String>();
                    for (PermissionAction pa : permission.getPermissionAction()) {
                        String actionname = pa.getActionName();
                        listOfActions.add(actionname);
                    }
                    String[] loa = new String[listOfActions.size()];
                    loa = listOfActions.toArray(loa);
                    try {
                        SetupPermissions.addPermission(role.getName(), permissionName, resourcePrimKey, scope, loa);
                    }
                    catch (SystemException e) {
                        LOG.error((Object)String.format("Error when defining permission %1$s for role %2$s", permissionName, role.getName()), (Throwable)e);
                    }
                }
            }
        }
    }

    private static Map<String, Role> convertRoleListToHashMap(List<Role> objects) {
        HashMap<String, Role> map = new HashMap<String, Role>();
        for (Role role : objects) {
            map.put(role.getName(), role);
        }
        return map;
    }
}

