/*
 * Decompiled with CFR 0.152.
 */
package com.ableneo.liferay.portal.setup.core;

import com.ableneo.liferay.portal.setup.SetupConfigurationThreadLocal;
import com.ableneo.liferay.portal.setup.domain.PermissionAction;
import com.ableneo.liferay.portal.setup.domain.ResourcePermissions;
import com.ableneo.liferay.portal.setup.domain.Role;
import com.ableneo.liferay.portal.setup.domain.RolePermissionType;
import com.ableneo.liferay.portal.setup.domain.RolePermissions;
import com.liferay.portal.kernel.exception.NestableException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class SetupPermissions {
    private static final String[] PERMISSION_RO = new String[]{"VIEW"};
    private static final String[] PERMISSION_RW = new String[]{"VIEW", "UPDATE"};
    private static final Log LOG = LogFactoryUtil.getLog(SetupPermissions.class);

    private SetupPermissions() {
    }

    public static void setupPortletPermissions(ResourcePermissions resourcePermissions) {
        for (ResourcePermissions.Resource resource : resourcePermissions.getResource()) {
            SetupPermissions.deleteAllPortletPermissions(resource);
            Map<String, Set<String>> actionsPerRole = SetupPermissions.getActionsPerRole(resource);
            for (Map.Entry<String, Set<String>> actionsPerRoleEntry : actionsPerRole.entrySet()) {
                String roleName = actionsPerRoleEntry.getKey();
                try {
                    long companyId = SetupConfigurationThreadLocal.getRunInCompanyId();
                    long roleId = RoleLocalServiceUtil.getRole((long)companyId, (String)roleName).getRoleId();
                    Set<String> actionStrings = actionsPerRoleEntry.getValue();
                    String[] actionIds = actionStrings.toArray(new String[actionStrings.size()]);
                    ResourcePermissionLocalServiceUtil.setResourcePermissions((long)companyId, (String)resource.getResourceId(), (int)4, (String)String.valueOf(companyId), (long)roleId, (String[])actionIds);
                    ResourcePermissionLocalServiceUtil.setResourcePermissions((long)companyId, (String)resource.getResourceId(), (int)1, (String)String.valueOf(companyId), (long)roleId, (String[])actionIds);
                    LOG.info((Object)String.format("Set permission for role: %1$s for action ids: %2$s", roleName, actionIds));
                }
                catch (NestableException e) {
                    LOG.error((Object)String.format("Could not set permission to resource :%1$s", resource.getResourceId()), (Throwable)e);
                }
            }
        }
    }

    private static Map<String, Set<String>> getActionsPerRole(ResourcePermissions.Resource resource) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (ResourcePermissions.Resource.ActionId actionId : resource.getActionId()) {
            for (Role role : actionId.getRole()) {
                String roleName = role.getName();
                result.computeIfAbsent(roleName, s -> new HashSet()).add(actionId.getName());
            }
        }
        return result;
    }

    public static void addReadRight(String roleName, String className, String primaryKey) {
        SetupPermissions.addPermission(roleName, className, primaryKey, PERMISSION_RO);
    }

    public static void addReadWrightRight(String roleName, String className, String primaryKey) {
        SetupPermissions.addPermission(roleName, className, primaryKey, PERMISSION_RW);
    }

    public static void removePermission(long companyId, String name, String primKey) throws PortalException {
        ResourcePermissionLocalServiceUtil.deleteResourcePermissions((long)companyId, (String)name, (int)4, (String)primKey);
    }

    public static void addPermission(String roleName, String name, String primaryKey, int scope, String[] permissions) {
        try {
            long companyId = SetupConfigurationThreadLocal.getRunInCompanyId();
            long roleId = RoleLocalServiceUtil.getRole((long)companyId, (String)roleName).getRoleId();
            ResourcePermissionLocalServiceUtil.setResourcePermissions((long)companyId, (String)name, (int)scope, (String)primaryKey, (long)roleId, (String[])permissions);
        }
        catch (Exception ex) {
            LOG.error((Object)("Error when adding permissions(" + Arrays.asList(permissions) + ") to role(" + roleName + "), name:(" + name + ")!"), (Throwable)ex);
        }
    }

    public static void addPermission(String roleName, String className, String primaryKey, String[] permission) {
        try {
            long companyId = SetupConfigurationThreadLocal.getRunInCompanyId();
            com.liferay.portal.kernel.model.Role role = RoleLocalServiceUtil.getRole((long)companyId, (String)roleName);
            if (role != null) {
                long roleId = role.getRoleId();
                ResourcePermissionLocalServiceUtil.setResourcePermissions((long)companyId, (String)className, (int)4, (String)primaryKey, (long)roleId, (String[])permission);
                LOG.info((Object)(" - [" + roleName + "] -> [" + primaryKey + "] ADD OK"));
            } else {
                LOG.warn((Object)(" - CANNOT SET ROLE[" + roleName + "] to key[" + primaryKey + "]"));
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)(" - CANNOT SET ROLE[" + roleName + "] to key[" + primaryKey + "]"));
        }
    }

    public static void removePermission(String roleName, String className, String primaryKey, String[] permission) {
        try {
            long companyId = SetupConfigurationThreadLocal.getRunInCompanyId();
            com.liferay.portal.kernel.model.Role role = RoleLocalServiceUtil.getRole((long)companyId, (String)roleName);
            if (role != null) {
                long roleId = role.getRoleId();
                for (String permissionAction : permission) {
                    ResourcePermissionLocalServiceUtil.removeResourcePermission((long)companyId, (String)className, (int)4, (String)primaryKey, (long)roleId, (String)permissionAction);
                    LOG.info((Object)(" - [" + roleName + ":" + permissionAction + "] X [" + primaryKey + "] RM OK"));
                }
            } else {
                LOG.warn((Object)(" - CANNOT REMOVE ROLE[" + roleName + "] FROM key[" + primaryKey + "]"));
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)(" - CANNOT REMOVE ROLE[" + roleName + "] to key[" + primaryKey + "], exception:" + ex.getMessage() + ";"));
        }
    }

    public static void addPermissionToPage(Role role, String primaryKey, String[] actionKeys) throws PortalException {
        long companyId = SetupConfigurationThreadLocal.getRunInCompanyId();
        long roleId = RoleLocalServiceUtil.getRole((long)companyId, (String)role.getName()).getRoleId();
        ResourcePermissionLocalServiceUtil.setResourcePermissions((long)companyId, (String)Layout.class.getName(), (int)4, (String)String.valueOf(primaryKey), (long)roleId, (String[])actionKeys);
    }

    private static void deleteAllPortletPermissions(ResourcePermissions.Resource resource) {
        try {
            long companyId = SetupConfigurationThreadLocal.getRunInCompanyId();
            List resourcePermissions = ResourcePermissionLocalServiceUtil.getResourcePermissions((long)companyId, (String)resource.getResourceId(), (int)1, (String)String.valueOf(companyId));
            for (ResourcePermission resourcePermission : resourcePermissions) {
                ResourcePermissionLocalServiceUtil.deleteResourcePermission((ResourcePermission)resourcePermission);
            }
        }
        catch (SystemException e) {
            LOG.error((Object)String.format("could not delete permissions for resource :%1$s", resource.getResourceId()), (Throwable)e);
        }
    }

    public static void clearPagePermissions(String primaryKey) throws PortalException {
        ResourcePermissionLocalServiceUtil.deleteResourcePermissions((long)SetupConfigurationThreadLocal.getRunInCompanyId(), (String)Layout.class.getName(), (int)4, (String)String.valueOf(primaryKey));
    }

    public static void updatePermission(String locationHint, long companyId, long elementId, Class clazz, RolePermissions rolePermissions, Map<String, List<String>> defaultPermissions) {
        SetupPermissions.updatePermission(locationHint, companyId, elementId, clazz.getName(), rolePermissions, defaultPermissions);
    }

    public static void updatePermission(String locationHint, long companyId, long elementId, String className, RolePermissions rolePermissions, Map<String, List<String>> defaultPermissions) {
        SetupPermissions.updatePermission(locationHint, companyId, Arrays.asList(elementId), className, rolePermissions, defaultPermissions);
    }

    public static void updatePermission(String locationHint, long companyId, List<Object> elementIdList, Class clazz, RolePermissions rolePermissions, Map<String, List<String>> defaultPermissions) {
        SetupPermissions.updatePermission(locationHint, companyId, elementIdList, clazz.getName(), rolePermissions, defaultPermissions);
    }

    public static void updatePermission(String locationHint, long companyId, List<Object> elementIdList, String className, RolePermissions rolePermissions, Map<String, List<String>> defaultPermissions) {
        boolean useDefaultPermissions = false;
        if (rolePermissions != null) {
            List<RolePermissionType> rolePermissionList;
            List<RolePermissionType> rmRolePermissionList;
            ArrayList<String> actions = new ArrayList<String>();
            if (rolePermissions.isClearPermissions()) {
                for (Object elementId : elementIdList) {
                    try {
                        SetupPermissions.removePermission(companyId, className, String.valueOf(elementId));
                    }
                    catch (PortalException | SystemException throwable) {
                        LOG.error((Object)String.format("Permissions for %1$s could not be cleared. (elId:%2$s)", locationHint, elementId), throwable);
                    }
                }
            }
            if ((rmRolePermissionList = rolePermissions.getRemoveRolePermission()) != null) {
                for (RolePermissionType rolePermissionType : rmRolePermissionList) {
                    actions.clear();
                    String roleName = rolePermissionType.getRoleName();
                    List<PermissionAction> roleActions = rolePermissionType.getPermissionAction();
                    for (PermissionAction pa : roleActions) {
                        String actionName = pa.getActionName();
                        actions.add(actionName);
                    }
                    for (Object elementId : elementIdList) {
                        try {
                            SetupPermissions.addPermission(roleName, className, String.valueOf(elementId), actions.toArray(new String[actions.size()]));
                        }
                        catch (SystemException e) {
                            LOG.error((Object)("Permissions for " + roleName + " for " + locationHint + " could not be removed, step add. "), (Throwable)e);
                        }
                        catch (NullPointerException e) {
                            LOG.error((Object)("Permissions for " + roleName + " for " + locationHint + " could not be removed, step add. Probably role not found! "), (Throwable)e);
                        }
                        try {
                            SetupPermissions.removePermission(roleName, className, String.valueOf(elementId), actions.toArray(new String[actions.size()]));
                        }
                        catch (SystemException e) {
                            LOG.error((Object)("Permissions for " + roleName + " for " + locationHint + " could not be removed, step rm. "), (Throwable)e);
                        }
                        catch (NullPointerException e) {
                            LOG.error((Object)("Permissions for " + roleName + " for " + locationHint + " could not be removed, step rm. Probably role not found! "), (Throwable)e);
                        }
                    }
                }
            }
            if ((rolePermissionList = rolePermissions.getRolePermission()) != null) {
                for (RolePermissionType rp : rolePermissionList) {
                    actions.clear();
                    String roleName = rp.getRoleName();
                    List<PermissionAction> roleActions = rp.getPermissionAction();
                    for (PermissionAction pa : roleActions) {
                        String actionName = pa.getActionName();
                        actions.add(actionName);
                    }
                    for (Object elementId : elementIdList) {
                        try {
                            SetupPermissions.addPermission(roleName, className, String.valueOf(elementId), actions.toArray(new String[actions.size()]));
                        }
                        catch (SystemException e) {
                            LOG.error((Object)("Permissions for " + roleName + " for " + locationHint + " could not be set. "), (Throwable)e);
                        }
                        catch (NullPointerException e) {
                            LOG.error((Object)("Permissions for " + roleName + " for " + locationHint + " could not be set. Probably role not found! "), (Throwable)e);
                        }
                    }
                }
            } else {
                useDefaultPermissions = true;
            }
        } else {
            useDefaultPermissions = true;
        }
        if (useDefaultPermissions) {
            Set<String> roles = defaultPermissions.keySet();
            for (String string : roles) {
                List<String> actions = defaultPermissions.get(string);
                for (Object elementId : elementIdList) {
                    try {
                        SetupPermissions.addPermission(string, className, String.valueOf(elementId), actions.toArray(new String[actions.size()]));
                    }
                    catch (SystemException e) {
                        LOG.error((Object)("Permissions for " + string + " for " + locationHint + " could not be defaulted. "), (Throwable)e);
                    }
                    catch (NullPointerException e) {
                        LOG.error((Object)("Permissions for " + string + " for " + locationHint + " could not be defaulted. Probably role not found! "), (Throwable)e);
                    }
                }
            }
        }
    }
}

