/*
 * Decompiled with CFR 0.152.
 */
package com.ableneo.liferay.portal.setup.core;

import com.ableneo.liferay.portal.setup.SetupConfigurationThreadLocal;
import com.ableneo.liferay.portal.setup.core.SetupArticles;
import com.ableneo.liferay.portal.setup.core.SetupPermissions;
import com.ableneo.liferay.portal.setup.core.util.CustomFieldSettingUtil;
import com.ableneo.liferay.portal.setup.core.util.ResolverUtil;
import com.ableneo.liferay.portal.setup.core.util.TranslationMapUtil;
import com.ableneo.liferay.portal.setup.domain.ArticleDisplayPortletType;
import com.ableneo.liferay.portal.setup.domain.AssetPublisherPortletType;
import com.ableneo.liferay.portal.setup.domain.CustomFieldSetting;
import com.ableneo.liferay.portal.setup.domain.MenuViewPortletType;
import com.ableneo.liferay.portal.setup.domain.PagePortletType;
import com.ableneo.liferay.portal.setup.domain.PageTemplate;
import com.ableneo.liferay.portal.setup.domain.PageTemplates;
import com.ableneo.liferay.portal.setup.domain.PageType;
import com.ableneo.liferay.portal.setup.domain.PagesType;
import com.ableneo.liferay.portal.setup.domain.PortletPreference;
import com.ableneo.liferay.portal.setup.domain.PropertyKeyValueType;
import com.ableneo.liferay.portal.setup.domain.RolePermissions;
import com.ableneo.liferay.portal.setup.domain.Site;
import com.ableneo.liferay.portal.setup.domain.Theme;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.journal.model.JournalArticle;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutTemplate;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.service.ClassNameLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutPrototypeLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutTemplateLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourceLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.site.navigation.model.SiteNavigationMenu;
import com.liferay.site.navigation.service.SiteNavigationMenuLocalServiceUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.portlet.ReadOnlyException;

public final class SetupPages {
    private static final Log LOG = LogFactoryUtil.getLog(SetupPages.class);
    private static final HashMap<String, List<String>> DEFAULT_PERMISSIONS_PUBLIC = new HashMap();
    private static final HashMap<String, List<String>> DEFAULT_PERMISSIONS_PRIVATE = new HashMap();
    private static final HashMap<String, List<String>> DEFAULT_PERMISSIONS_PORTLET_PUBLIC;
    private static final HashMap<String, List<String>> DEFAULT_PERMISSIONS_PORTLET_PRIVATE;
    private static final String LAYOUT_WAS_LOOKED_UP_IN_THEME = "Layout was looked up in theme %1$s";
    public static final Map<String, String> CONFIG_MENU_VIEW_PREFERENCES;

    private SetupPages() {
    }

    public static void setupSitePages(Site site, long groupId) throws PortalException {
        PagesType privatePages;
        PagesType publicPages = site.getPublicPages();
        long company = SetupConfigurationThreadLocal.getRunInCompanyId();
        long userid = SetupConfigurationThreadLocal.getRunAsUserId();
        if (publicPages != null) {
            if (publicPages.getTheme() != null) {
                SetupPages.setupTheme(groupId, publicPages.getTheme(), false);
            }
            if (publicPages.isDeleteExistingPages()) {
                LOG.info((Object)String.format("Setup: Deleting pages from site %1$s", site.getName()));
                SetupPages.deletePages(groupId, false);
            }
            SetupPages.addPages(publicPages.getPage(), publicPages.getDefaultLayout(), publicPages.getDefaultLayoutsThemeId(), groupId, false, 0L, company, userid);
            if (publicPages.getVirtualHost() != null) {
                TreeMap<String, String> hosts = SetupPages.buildVirtualHostNames(publicPages);
                LayoutSetLocalServiceUtil.updateVirtualHosts((long)groupId, (boolean)false, hosts);
            }
        }
        if ((privatePages = site.getPrivatePages()) != null) {
            if (privatePages.getTheme() != null) {
                SetupPages.setupTheme(groupId, privatePages.getTheme(), true);
            }
            if (privatePages.isDeleteExistingPages()) {
                LOG.info((Object)String.format("Setup: Deleting pages from site %1$s", site.getName()));
                SetupPages.deletePages(groupId, true);
            }
            SetupPages.addPages(privatePages.getPage(), privatePages.getDefaultLayout(), privatePages.getDefaultLayoutsThemeId(), groupId, true, 0L, company, userid);
            if (privatePages.getVirtualHost() != null) {
                TreeMap<String, String> hosts = SetupPages.buildVirtualHostNames(privatePages);
                LayoutSetLocalServiceUtil.updateVirtualHosts((long)groupId, (boolean)true, hosts);
            }
        }
    }

    private static TreeMap<String, String> buildVirtualHostNames(PagesType publicPages) {
        String languageId = SetupPages.getLanguageId(publicPages.getLanguageId());
        TreeMap<String, String> hosts = new TreeMap<String, String>();
        hosts.put(publicPages.getVirtualHost(), languageId);
        return hosts;
    }

    private static String getLanguageId(String languageId) {
        if (languageId != null) {
            return languageId;
        }
        return LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault());
    }

    public static void setupPageTemplates(PageTemplates pageTemplates) {
        try {
            for (PageTemplate pageTemplate : pageTemplates.getPageTemplate()) {
                LayoutPrototype lp;
                String name = pageTemplate.getName();
                if (name == null) continue;
                DynamicQuery dq = LayoutPrototypeLocalServiceUtil.dynamicQuery().add(PropertyFactoryUtil.forName((String)"name").like((Object)("%" + name + "%")));
                List listLayoutPrototype = LayoutPrototypeLocalServiceUtil.dynamicQuery((DynamicQuery)dq);
                long groupId = SetupConfigurationThreadLocal.getRunInGroupId();
                long userid = SetupConfigurationThreadLocal.getRunAsUserId();
                long company = SetupConfigurationThreadLocal.getRunInCompanyId();
                if (listLayoutPrototype != null && !listLayoutPrototype.isEmpty()) {
                    lp = (LayoutPrototype)listLayoutPrototype.get(0);
                } else {
                    Map<Locale, String> titleMap = TranslationMapUtil.getTranslationMap(pageTemplate.getTitleTranslation(), groupId, name, String.format(" Page template  %1$s", name));
                    Map<Locale, String> nameMap = TranslationMapUtil.getTranslationMap(pageTemplate.getTitleTranslation(), groupId, name, String.format(" Page template  %1$s", name));
                    lp = LayoutPrototypeLocalServiceUtil.addLayoutPrototype((long)userid, (long)company, titleMap, nameMap, (boolean)true, (ServiceContext)new ServiceContext());
                }
                if (lp != null) {
                    Layout layout = lp.getLayout();
                    if (pageTemplate.getPage() == null) continue;
                    PageType page = pageTemplate.getPage();
                    if (page.getFriendlyUrl() != null && !page.getFriendlyUrl().equals("")) {
                        LOG.error((Object)String.format("The page of page template %1$s may not have a friendly URL! Will ignore it!", name));
                    }
                    SetupPages.setupLiferayPage(layout, page, null, null, groupId, false, company, userid, name);
                    continue;
                }
                LOG.error((Object)String.format("Could not create or find the page template %1$s", name));
            }
        }
        catch (PortalException | SystemException e) {
            LOG.error((Object)"Problem during creating page templates ", e);
        }
    }

    private static void setupTheme(long groupId, Theme theme, boolean isPrivate) throws PortalException {
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        LayoutSet set = isPrivate ? group.getPrivateLayoutSet() : group.getPublicLayoutSet();
        set.setThemeId(theme.getName());
        set.setSettingsProperties(SetupPages.mergeConvertProperties(set.getSettingsProperties(), theme.getLayoutSetSettings()));
        LayoutSetLocalServiceUtil.updateLayoutSet((LayoutSet)set);
    }

    private static UnicodeProperties mergeConvertProperties(UnicodeProperties original, List<PropertyKeyValueType> props) {
        if (props == null || props.isEmpty()) {
            return original;
        }
        UnicodeProperties res = new UnicodeProperties();
        res.putAll((Map)original);
        for (PropertyKeyValueType kv : props) {
            res.put(kv.getKey(), kv.getValue());
        }
        return res;
    }

    private static void addPages(List<PageType> pages, String defaultLayout, String defaultLayoutContainedInThemeWithId, long groupId, boolean isPrivate, long parentLayoutId, long company, long userId) throws PortalException {
        for (PageType page : pages) {
            Layout layout = null;
            try {
                layout = LayoutLocalServiceUtil.getFriendlyURLLayout((long)groupId, (boolean)isPrivate, (String)page.getFriendlyUrl());
                LOG.info((Object)String.format("Setup: Page %1$s already exist, not creating...", page.getName()));
                if (layout != null && page.isDeleteExistingPages()) {
                    LayoutLocalServiceUtil.deleteLayout((Layout)layout);
                    layout = page.getLinkToUrl() == null || page.getLinkToUrl().equals("") ? SetupPages.createPage(groupId, page, parentLayoutId, isPrivate) : SetupPages.createLinkPage(page, groupId, parentLayoutId, userId);
                } else if (layout != null && page.getLinkToUrl() != null && !page.getLinkToUrl().equals("")) {
                    SetupPages.updateLinkPage(page, groupId);
                } else {
                    LOG.warn((Object)String.format("Setup: unhandled 'else' while creatng page[%1$s]/layout[%2$s]", page.getName(), page.getLayout()));
                }
            }
            catch (NoSuchLayoutException e) {
                layout = page.getLinkToUrl() == null || page.getLinkToUrl().equals("") ? SetupPages.createPage(groupId, page, parentLayoutId, isPrivate) : SetupPages.createLinkPage(page, groupId, parentLayoutId, userId);
                LOG.info((Object)String.format("Setup: Page %1$s created...", page.getName()));
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
            }
            if (page.getLayout() == null) {
                page.setLayout(defaultLayout);
                page.setLayoutThemeId(defaultLayoutContainedInThemeWithId);
            } else {
                defaultLayout = page.getLayout();
                defaultLayoutContainedInThemeWithId = page.getLayoutThemeId();
            }
            SetupPages.setupLiferayPage(layout, page, defaultLayout, defaultLayoutContainedInThemeWithId, groupId, isPrivate, company, userId, null);
        }
    }

    private static void setupLiferayPage(Layout layout, PageType page, String defaultLayout, String defaultLayoutContainedInThemeWithId, long groupId, boolean isPrivate, long company, long userId, String pageTemplateName) throws PortalException {
        List<PageType> subPages;
        if (page.getTheme() != null) {
            SetupPages.setPageTheme(layout, page);
        }
        if (page.getLayout() != null) {
            SetupPages.setLayoutTemplate(layout, page, userId);
        }
        SetupPages.setPageTarget(page, layout);
        List<PagePortletType> portlets = page.getPagePortlet();
        if (portlets != null && !portlets.isEmpty()) {
            ArrayList<PortletWithRuntimeData> deferredAdd = new ArrayList<PortletWithRuntimeData>();
            for (PagePortletType portlet : portlets) {
                SetupPages.addRuntimeInfo(deferredAdd, portlet, page, layout, company, groupId);
            }
            portlets.clear();
            portlets.addAll(deferredAdd);
        }
        if ((subPages = page.getPage()) != null && !subPages.isEmpty()) {
            if (pageTemplateName != null && !pageTemplateName.equals("")) {
                LOG.error((Object)String.format("Page template %1$s may not have any sub-pages! Will ignore them!", pageTemplateName));
            } else {
                SetupPages.addPages(subPages, defaultLayout, defaultLayoutContainedInThemeWithId, groupId, isPrivate, layout.getLayoutId(), company, userId);
            }
        }
        if (page.getCustomFieldSetting() != null && !page.getCustomFieldSetting().isEmpty()) {
            SetupPages.setCustomFields(groupId, company, page, layout);
        }
        SetupPermissions.updatePermission(String.format("Page %1$s", page.getFriendlyUrl()), company, layout.getPlid(), Layout.class, page.getRolePermissions(), SetupPages.getDefaultPermissions(isPrivate));
    }

    private static HashMap<String, List<String>> getDefaultPermissions(boolean isPrivate) {
        if (isPrivate) {
            return new HashMap<String, List<String>>(DEFAULT_PERMISSIONS_PRIVATE);
        }
        return new HashMap<String, List<String>>(DEFAULT_PERMISSIONS_PUBLIC);
    }

    private static HashMap<String, List<String>> getDefaultPortletPermissions(boolean isPrivate) {
        if (isPrivate) {
            return new HashMap<String, List<String>>(DEFAULT_PERMISSIONS_PORTLET_PRIVATE);
        }
        return new HashMap<String, List<String>>(DEFAULT_PERMISSIONS_PORTLET_PUBLIC);
    }

    private static Layout createLinkPage(PageType p, long groupId, long parentLayoutId, long userId) {
        String title = "my title";
        ServiceContext serviceContext = new ServiceContext();
        String layoutType = "url";
        boolean hidden = p.isHidden();
        String friendlyURL = p.getFriendlyUrl();
        Layout layout = null;
        try {
            layout = LayoutLocalServiceUtil.addLayout((long)userId, (long)groupId, (boolean)false, (long)parentLayoutId, (String)title, (String)title, (String)"", (String)layoutType, (boolean)hidden, (String)friendlyURL, (ServiceContext)serviceContext);
            String linkToPageUrl = p.getLinkToUrl();
            UnicodeProperties props = layout.getTypeSettingsProperties();
            props.put("url", linkToPageUrl);
            layout.setTypeSettingsProperties(props);
            LayoutLocalServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
        }
        catch (PortalException | SystemException e) {
            LOG.error((Object)String.format("Could not create link page %1$s with link to url %2$s", p.getFriendlyUrl(), p.getLinkToUrl()), e);
        }
        return layout;
    }

    private static void updateLinkPage(PageType page, long groupId) {
        try {
            Layout layout = LayoutLocalServiceUtil.getFriendlyURLLayout((long)groupId, (boolean)false, (String)page.getFriendlyUrl());
            if (layout.getLayoutType().getTypeSettingsProperties().get((Object)"url") == null) {
                LOG.error((Object)("Could not update link page " + page.getFriendlyUrl() + " with link to url " + page.getLinkToUrl() + " because page is not a link type page!  Maybe it has been imported before as non link type page. Please delete it and rerun!"));
            } else {
                UnicodeProperties props = layout.getTypeSettingsProperties();
                props.put("url", page.getLinkToUrl());
                layout.setTypeSettingsProperties(props);
                layout.setHidden(page.isHidden());
                LayoutLocalServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
            }
        }
        catch (PortalException | SystemException e) {
            LOG.error((Object)String.format("Could not update link page %1$s with link to url %2$s", page.getFriendlyUrl(), page.getLinkToUrl()), e);
        }
    }

    private static Layout createPage(long groupId, PageType currentPage, long parentLayoutId, boolean isPrivate) throws PortalException {
        Map<Locale, String> titleMap = TranslationMapUtil.getTranslationMap(currentPage.getTitleTranslation(), groupId, currentPage.getName(), String.format(" Page with title %1$s", currentPage.getFriendlyUrl()));
        Locale locale = LocaleUtil.getSiteDefault();
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        descriptionMap.put(locale, "");
        HashMap<Locale, String> friendlyURLMap = new HashMap<Locale, String>();
        friendlyURLMap.put(locale, currentPage.getFriendlyUrl());
        return LayoutLocalServiceUtil.addLayout((long)SetupConfigurationThreadLocal.getRunAsUserId(), (long)groupId, (boolean)isPrivate, (long)parentLayoutId, titleMap, titleMap, null, null, null, (String)currentPage.getType(), (String)"", (boolean)currentPage.isHidden(), friendlyURLMap, (ServiceContext)new ServiceContext());
    }

    private static void setCustomFields(long groupId, long company, PageType page, Layout layout) {
        Class<Layout> clazz = Layout.class;
        String resolverHint = "Resolving customized value for page " + page.getFriendlyUrl() + " failed for key %%key%% and value %%value%%";
        for (CustomFieldSetting cfs : page.getCustomFieldSetting()) {
            String key = cfs.getKey();
            String value = cfs.getValue();
            CustomFieldSettingUtil.setExpandoValue(resolverHint.replace("%%key%%", key).replace("%%value%%", value), groupId, company, clazz, layout.getPlid(), key, value);
        }
    }

    private static void setPageTarget(PageType page, Layout layout) {
        UnicodeProperties props = layout.getTypeSettingsProperties();
        props.put("target", page.getTarget());
        layout.setTypeSettingsProperties(props);
        try {
            LayoutLocalServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
        }
        catch (PortalException e) {
            LOG.error((Object)("Can not set target attribute value '" + page.getTarget() + "' to page with layoutId:" + layout.getLayoutId() + "."), (Throwable)e);
        }
    }

    private static void setPageTheme(Layout layout, PageType page) {
        Theme theme = page.getTheme();
        if (theme != null) {
            layout.setThemeId(theme.getName());
            try {
                LayoutLocalServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
            }
            catch (PortalException e) {
                LOG.error((Throwable)e);
            }
            LOG.info((Object)String.format("setting theme on page: %1$s : %2$s", page.getName(), theme.getName()));
        }
    }

    private static boolean isLinkPage(PageType page) {
        if (page.getLinkToUrl() != null && !page.getLinkToUrl().equals("")) {
            LOG.error((Object)"This is a link page! It cannot be cleared. If you intend to use this page for portlets, please delete this page, or remove the link from the page!");
            return true;
        }
        return false;
    }

    private static void addAssetPublisherPortletIntoPage(PageType page, Layout layout, AssetPublisherPortletType portlet, long company, long groupId) throws PortalException {
        if (SetupPages.isLinkPage(page)) {
            return;
        }
        LOG.info((Object)("Adding AssetPublisherPortlet: " + portlet.getColumn() + "@" + portlet.getColumnPosition() + "-" + portlet.getPortletId() + "; ADTgroupIdFrom:" + portlet.getAdtTemplateSiteUrl()));
        PagePortletType toInsert = null;
        toInsert = new PagePortletType();
        toInsert.setColumn(portlet.getColumn());
        toInsert.setColumnPosition(portlet.getColumnPosition());
        toInsert.setPortletId(portlet.getPortletId());
        toInsert.getPortletPreference().addAll(portlet.getPortletPreference());
        toInsert.setRolePermissions(portlet.getRolePermissions());
        Group group = GroupLocalServiceUtil.getFriendlyURLGroup((long)company, (String)portlet.getAdtTemplateSiteUrl());
        toInsert.getPortletPreference().add(SetupPages.newPortletPreference("displayStyleGroupId", String.valueOf(group.getPrimaryKey())));
        List shownArticleClasses = StringUtil.split((String)portlet.getShownArticleClasses(), (char)';');
        HashSet<String> shownClassIds = new HashSet<String>();
        for (String cls : shownArticleClasses) {
            ClassName shownClass = ClassNameLocalServiceUtil.getClassName((String)cls);
            shownClassIds.add(String.valueOf(shownClass.getPrimaryKey()));
        }
        toInsert.getPortletPreference().add(SetupPages.newPortletPreference("classNameIds", StringUtil.merge(shownClassIds, (String)",")));
        SetupPages.insertPortletIntoPage(page, layout, toInsert, company, groupId);
    }

    private static void addArticleDisplayPortletIntoPage(PageType page, Layout layout, ArticleDisplayPortletType portlet, long companyId, long groupId) throws PortalException {
        if (SetupPages.isLinkPage(page)) {
            return;
        }
        LOG.info((Object)("Adding ArticleDisplayPortlet: " + portlet.getColumn() + "@" + portlet.getColumnPosition() + "-" + portlet.getPortletId() + "; " + portlet.getArticleFolder().getFolderPath() + ":" + portlet.getArticleId()));
        PagePortletType toInsert = null;
        long folderId = SetupArticles.getCreateFolderId(portlet.getArticleFolder().getFolderPath(), groupId, portlet.getArticleFolder().getRolePermissions());
        JournalArticle journalArticle = SetupArticles.getJournalArticle(portlet.getArticleId(), folderId, groupId, portlet.getArticleFolder().getFolderPath());
        if (journalArticle != null) {
            Long assetEntryId = SetupArticles.getJournalAssetEntryId(journalArticle);
            toInsert = new PagePortletType();
            toInsert.setColumn(portlet.getColumn());
            toInsert.setColumnPosition(portlet.getColumnPosition());
            toInsert.setPortletId(portlet.getPortletId());
            toInsert.getPortletPreference().addAll(portlet.getPortletPreference());
            toInsert.setRolePermissions(portlet.getRolePermissions());
            toInsert.getPortletPreference().add(SetupPages.newPortletPreference("groupId", String.valueOf(groupId)));
            toInsert.getPortletPreference().add(SetupPages.newPortletPreference("articleId", journalArticle.getArticleId()));
            if (assetEntryId != null) {
                toInsert.getPortletPreference().add(SetupPages.newPortletPreference("assetEntryId", String.valueOf(assetEntryId)));
            }
        } else {
            LOG.error((Object)"No journal entry found = skip adding it to the wrappedPortlet. Manual task!");
            toInsert = portlet;
        }
        SetupPages.insertPortletIntoPage(page, layout, toInsert, companyId, groupId);
    }

    private static void addMenuViewPortletIntoPage(PageType page, Layout layout, MenuViewPortletType portlet, long companyId, long groupId) throws PortalException {
        if (SetupPages.isLinkPage(page)) {
            LOG.info((Object)" ! SKIP-page is a link");
            return;
        }
        LOG.info((Object)("Adding MenuViewPortlet: " + portlet.getColumn() + "@" + portlet.getColumnPosition() + "-" + portlet.getPortletId() + "; " + portlet.getAdtTemplate() + ":" + portlet.getMenuName()));
        PagePortletType toInsert = null;
        Long menuId = SetupPages.getMenuIdByName(groupId, portlet.getMenuName());
        if (menuId == null || menuId == 0L) {
            LOG.info((Object)" ! SKIP-no such menu to add");
            return;
        }
        portlet.getPortletPreference().add(SetupPages.newPortletPreference("siteNavigationMenuId", String.valueOf(menuId)));
        DDMTemplate adtTemplate = SetupPages.getAdtTemplate(groupId, portlet.getAdtTemplate(), portlet.getAdtTemplateSiteUrl());
        if (adtTemplate == null) {
            LOG.info((Object)" ! SKIP-no such template to display with");
            return;
        }
        portlet.getPortletPreference().add(SetupPages.newPortletPreference("displayStyle", "ddmTemplate_" + portlet.getAdtTemplate()));
        Group group = GroupLocalServiceUtil.getFriendlyURLGroup((long)companyId, (String)portlet.getAdtTemplateSiteUrl());
        portlet.getPortletPreference().add(SetupPages.newPortletPreference("displayStyleGroupId", String.valueOf(group.getPrimaryKey())));
        toInsert = new PagePortletType();
        toInsert.setColumn(portlet.getColumn());
        toInsert.setColumnPosition(portlet.getColumnPosition());
        toInsert.setPortletId(portlet.getPortletId());
        toInsert.setRolePermissions(portlet.getRolePermissions());
        for (Map.Entry<String, String> e : CONFIG_MENU_VIEW_PREFERENCES.entrySet()) {
            toInsert.getPortletPreference().add(SetupPages.newPortletPreference(e.getKey(), e.getValue()));
        }
        toInsert.getPortletPreference().addAll(portlet.getPortletPreference());
        SetupPages.insertPortletIntoPage(page, layout, toInsert, companyId, groupId);
    }

    private static DDMTemplate getAdtTemplate(long groupId, String adtTemplate, String adtClass) {
        long classNameId = 0L;
        DDMTemplate ddmTemplate = null;
        try {
            List tplsWithoutStruct = DDMTemplateLocalServiceUtil.getTemplates((long)classNameId);
            for (DDMTemplate tpl : tplsWithoutStruct) {
                if (!adtTemplate.equalsIgnoreCase(tpl.getTemplateKey()) || groupId != 0L && groupId != tpl.getGroupId()) continue;
                ddmTemplate = tpl;
                break;
            }
        }
        catch (Exception e) {
            LOG.error((Object)String.format("Error while trying to find ADT with key: %1$s", adtTemplate));
        }
        return ddmTemplate;
    }

    private static Long getMenuIdByName(long groupId, String menuName) {
        List existingMenus = SiteNavigationMenuLocalServiceUtil.getSiteNavigationMenus((long)groupId);
        for (SiteNavigationMenu existingMenu : existingMenus) {
            if (!menuName.equalsIgnoreCase(existingMenu.getName())) continue;
            LOG.info((Object)(" i '" + menuName + "' found"));
            return existingMenu.getPrimaryKey();
        }
        LOG.error((Object)(" i '" + menuName + "' NOT THERE"));
        return null;
    }

    private static PortletPreference newPortletPreference(String key, String value) {
        PortletPreference pref = new PortletPreference();
        pref.setKey(key);
        pref.setValue(value);
        return pref;
    }

    private static void addGenericPortletIntoPage(PageType page, Layout layout, PagePortletType portlet, long companyId, long groupId) throws PortalException {
        if (SetupPages.isLinkPage(page)) {
            return;
        }
        LOG.info((Object)("Adding PagePortlet: " + portlet.getColumn() + "@" + portlet.getColumnPosition() + "-" + portlet.getPortletId() + ";"));
        SetupPages.insertPortletIntoPage(page, layout, portlet, companyId, groupId);
    }

    private static void insertPortletIntoPage(PageType page, Layout layout, PagePortletType portlet, long companyId, long groupId) throws PortalException {
        long plid = layout.getPlid();
        long ownerId = 0L;
        int ownerType = 3;
        long runAsUserId = SetupConfigurationThreadLocal.getRunAsUserId();
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        String portletId = portlet.getPortletId();
        String column = portlet.getColumn();
        String portletIdInc = "";
        try {
            int columnPos = portlet.getColumnPosition();
            portletIdInc = layoutTypePortlet.addPortletId(runAsUserId, portletId, column, columnPos, false);
            if (portletIdInc == null) {
                portletIdInc = portletId;
            }
        }
        catch (SystemException e) {
            LOG.error((Object)"Add wrappedPortlet error ", (Throwable)e);
        }
        javax.portlet.PortletPreferences preferences = PortletPreferencesLocalServiceUtil.getPreferences((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletIdInc);
        List<PortletPreference> prefsList = portlet.getPortletPreference();
        for (PortletPreference p : prefsList) {
            try {
                preferences.setValue(p.getKey(), SetupPages.resolvePortletPrefValue(p.getKey(), p.getValue(), portlet, companyId, groupId));
            }
            catch (ReadOnlyException e) {
                LOG.error((Object)("Portlet preferences (" + p.getKey() + ", " + p.getValue() + ") of wrappedPortlet " + portlet.getPortletId() + " caused an excpetion! "));
            }
        }
        PortletPreferencesLocalServiceUtil.updatePreferences((long)ownerId, (int)ownerType, (long)plid, (String)portletIdInc, (javax.portlet.PortletPreferences)preferences);
        if (Validator.isNotNull((String)column) && Validator.isNotNull((String)portletIdInc)) {
            layoutTypePortlet.movePortletId(runAsUserId, portletIdInc, column, portlet.getColumnPosition());
        }
        LayoutLocalServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
        if (portlet.getRolePermissions() != null) {
            LOG.info((Object)" i portlet rights");
            SetupPages.updatePortletDisplayPermissions(portlet, portletIdInc, layout, page, companyId, groupId, portlet.getRolePermissions(), SetupPages.getDefaultPortletPermissions(layout.isPrivateLayout()));
        }
        LOG.info((Object)" i portlet added.");
    }

    public static void updatePortletDisplayPermissions(PagePortletType portlet, String portletIdInc, Layout layout, PageType page, long companyId, long groupId, RolePermissions rolePermissions, Map<String, List<String>> defaultPermissions) {
        ArrayList<Object> primaryKeys = new ArrayList<Object>();
        try {
            String portlet_on_layout_id = layout.getPlid() + "_LAYOUT_" + portletIdInc;
            primaryKeys.add(portlet_on_layout_id);
            SetupPermissions.updatePermission(String.format("Portlet %1$s on page %2$s", portlet_on_layout_id, page.getFriendlyUrl()), companyId, primaryKeys, portlet.getPortletId(), rolePermissions, defaultPermissions);
            LOG.info((Object)(" Permissions for " + portletIdInc + " changed: " + defaultPermissions));
        }
        catch (Exception e) {
            LOG.error((Object)(" Permissions for " + portletIdInc + " could not be changed. "), (Throwable)e);
        }
    }

    private static String resolvePortletPrefValue(String key, String value, PagePortletType portlet, long company, long groupId) {
        String locationHint = String.format("Key: %1$s of wrappedPortlet %2$s", key, portlet.getPortletId());
        return ResolverUtil.lookupAll(groupId, company, value, locationHint);
    }

    public static void setLayoutTemplate(Layout layout, PageType page, long userid) {
        block11: {
            if (layout.getLayoutType() instanceof LayoutTypePortlet) {
                LayoutTypePortlet portletLayout = (LayoutTypePortlet)layout.getLayoutType();
                if (page.isClearPage()) {
                    if (page.getPagePortlet() != null && !page.getPagePortlet().isEmpty() && page.getLinkToUrl() != null && !page.getLinkToUrl().equals("")) {
                        LOG.error((Object)"This is a link page! It cannot be cleared. If you intend to use this page for portlets, please delete this page, or remove the link from the page!");
                    } else {
                        SetupPages.removeAllPortlets(userid, portletLayout, layout);
                    }
                }
                String themeId = null;
                try {
                    LayoutTemplate layoutTemplate;
                    if (!Validator.isBlank((String)page.getLayoutThemeId())) {
                        themeId = page.getLayoutThemeId();
                    }
                    if ((layoutTemplate = LayoutTemplateLocalServiceUtil.getLayoutTemplate((String)page.getLayout(), (boolean)false, (String)themeId)) != null) {
                        LOG.info((Object)String.format("Setting layout to %1$s for page %2$s", page.getLayout(), page.getName()));
                        if (themeId != null) {
                            LOG.info((Object)String.format(LAYOUT_WAS_LOOKED_UP_IN_THEME, themeId));
                        }
                        portletLayout.setLayoutTemplateId(UserLocalServiceUtil.getDefaultUserId((long)layout.getCompanyId()), layoutTemplate.getLayoutTemplateId());
                        LayoutLocalServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
                    } else {
                        LOG.error((Object)String.format("Layout template %1$s not found !", page.getLayout()));
                        if (themeId != null) {
                            LOG.error((Object)String.format(LAYOUT_WAS_LOOKED_UP_IN_THEME, themeId));
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)String.format("Error by setting layout template : %1$s", page.getLayout()), (Throwable)e);
                    if (themeId == null) break block11;
                    LOG.error((Object)String.format(LAYOUT_WAS_LOOKED_UP_IN_THEME, themeId));
                }
            }
        }
    }

    private static void removeAllPortlets(long runasUser, LayoutTypePortlet layoutTypePortlet, Layout layout) {
        List portlets = null;
        try {
            portlets = layoutTypePortlet.getAllPortlets();
        }
        catch (SystemException e1) {
            LOG.error((Throwable)e1);
        }
        if (portlets != null) {
            for (Portlet portlet : portlets) {
                String portletId = portlet.getPortletId();
                try {
                    if (!layoutTypePortlet.hasPortletId(portletId)) continue;
                    LOG.debug((Object)String.format("Removing wrappedPortlet %1$s", portletId));
                    layoutTypePortlet.removePortletId(runasUser, portletId);
                    String rootPortletId = PortletIdCodec.decodePortletName((String)portletId);
                    LOG.debug((Object)String.format("Root portletId: %1$s", rootPortletId));
                    ResourceLocalServiceUtil.deleteResource((long)layout.getCompanyId(), (String)rootPortletId, (int)4, (String)PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portletId));
                    LayoutLocalServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
                    List list = PortletPreferencesLocalServiceUtil.getPortletPreferences((int)3, (long)layout.getPlid(), (String)portletId);
                    for (PortletPreferences p : list) {
                        PortletPreferencesLocalServiceUtil.deletePortletPreferences((PortletPreferences)p);
                    }
                }
                catch (PortalException | SystemException e) {
                    LOG.error(e);
                }
            }
        }
    }

    private static void deletePages(long groupId, boolean privatePages) {
        ServiceContext serviceContext = new ServiceContext();
        try {
            LayoutLocalServiceUtil.deleteLayouts((long)groupId, (boolean)privatePages, (ServiceContext)serviceContext);
            LOG.info((Object)"Setup: Pages removed.");
        }
        catch (PortalException | SystemException e) {
            LOG.error((Object)String.format("cannot remove pages: %1$s", e));
        }
    }

    public static void setupSitePortlets(Site site, long groupId) {
        if (site.getPrivatePages() != null) {
            for (PageType p : site.getPrivatePages().getPage()) {
                SetupPages.setupPagePortlets(p, groupId);
            }
        }
        if (site.getPublicPages() != null) {
            for (PageType p : site.getPublicPages().getPage()) {
                SetupPages.setupPagePortlets(p, groupId);
            }
        }
    }

    private static void setupPagePortlets(PageType page, long groupId) {
        for (PagePortletType p : page.getPagePortlet()) {
            if (p instanceof PortletWithRuntimeData) {
                SetupPages.addDeferredPortlet((PortletWithRuntimeData)p);
                continue;
            }
            LOG.error((Object)"Not implemented / only deferred portlet addition!");
        }
        if (!page.getPage().isEmpty()) {
            for (PageType sub : page.getPage()) {
                SetupPages.setupPagePortlets(sub, groupId);
            }
        }
    }

    private static void addDeferredPortlet(PortletWithRuntimeData wrap) {
        try {
            if (wrap.wrappedPortlet instanceof ArticleDisplayPortletType) {
                SetupPages.addArticleDisplayPortletIntoPage(wrap.page, wrap.layout, (ArticleDisplayPortletType)wrap.wrappedPortlet, wrap.company, wrap.groupId);
            } else if (wrap.wrappedPortlet instanceof AssetPublisherPortletType) {
                SetupPages.addAssetPublisherPortletIntoPage(wrap.page, wrap.layout, (AssetPublisherPortletType)wrap.wrappedPortlet, wrap.company, wrap.groupId);
            } else if (wrap.wrappedPortlet instanceof MenuViewPortletType) {
                SetupPages.addMenuViewPortletIntoPage(wrap.page, wrap.layout, (MenuViewPortletType)wrap.wrappedPortlet, wrap.company, wrap.groupId);
            } else {
                SetupPages.addGenericPortletIntoPage(wrap.page, wrap.layout, wrap.wrappedPortlet, wrap.company, wrap.groupId);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot add pre-wrapped portlet:[" + wrap + "]"), (Throwable)e);
        }
    }

    private static void addRuntimeInfo(List<PortletWithRuntimeData> deferredAdd, PagePortletType portlet, PageType page, Layout layout, long company, long groupId) {
        PortletWithRuntimeData p = new PortletWithRuntimeData();
        p.wrappedPortlet = portlet;
        p.page = page;
        p.layout = layout;
        p.company = company;
        p.groupId = groupId;
        deferredAdd.add(p);
    }

    private static void configure_CONFIG_MENU_VIEW_PREFERENCES() {
        CONFIG_MENU_VIEW_PREFERENCES.put("displayDepth", "0");
        CONFIG_MENU_VIEW_PREFERENCES.put("rootMenuItemType", "absolute");
        CONFIG_MENU_VIEW_PREFERENCES.put("siteNavigationMenuType", "-1");
        CONFIG_MENU_VIEW_PREFERENCES.put("expandedLevels", "auto");
        CONFIG_MENU_VIEW_PREFERENCES.put("rootMenuItemLevel", "0");
    }

    static {
        ArrayList<String> actionsOwner = new ArrayList<String>();
        actionsOwner.add("ADD_DISCUSSION");
        actionsOwner.add("ADD_LAYOUT");
        actionsOwner.add("CONFIGURE_PORTLETS");
        actionsOwner.add("CUSTOMIZE");
        actionsOwner.add("DELETE");
        actionsOwner.add("DELETE_DISCUSSION");
        actionsOwner.add("PERMISSIONS");
        actionsOwner.add("UPDATE");
        actionsOwner.add("UPDATE_DISCUSSION");
        actionsOwner.add("VIEW");
        actionsOwner.add("UPDATE_DISCUSSION");
        DEFAULT_PERMISSIONS_PUBLIC.put("Owner", actionsOwner);
        ArrayList<String> actionsUser = new ArrayList<String>();
        actionsUser.add("VIEW");
        DEFAULT_PERMISSIONS_PUBLIC.put("Site Member", actionsUser);
        DEFAULT_PERMISSIONS_PRIVATE.putAll(DEFAULT_PERMISSIONS_PUBLIC);
        ArrayList<String> actionsGuest = new ArrayList<String>();
        actionsGuest.add("VIEW");
        DEFAULT_PERMISSIONS_PUBLIC.put("Guest", actionsGuest);
        DEFAULT_PERMISSIONS_PORTLET_PUBLIC = new HashMap();
        DEFAULT_PERMISSIONS_PORTLET_PRIVATE = new HashMap();
        actionsOwner = new ArrayList();
        actionsOwner.add("CONFIGURE_PORTLETS");
        actionsOwner.add("CUSTOMIZE");
        actionsOwner.add("DELETE");
        actionsOwner.add("PERMISSIONS");
        actionsOwner.add("UPDATE");
        actionsOwner.add("VIEW");
        DEFAULT_PERMISSIONS_PORTLET_PUBLIC.put("Owner", actionsOwner);
        actionsUser = new ArrayList();
        actionsUser.add("VIEW");
        DEFAULT_PERMISSIONS_PORTLET_PUBLIC.put("Site Member", actionsUser);
        DEFAULT_PERMISSIONS_PORTLET_PRIVATE.putAll(DEFAULT_PERMISSIONS_PORTLET_PUBLIC);
        actionsGuest = new ArrayList();
        actionsGuest.add("VIEW");
        DEFAULT_PERMISSIONS_PORTLET_PUBLIC.put("Guest", actionsGuest);
        CONFIG_MENU_VIEW_PREFERENCES = new HashMap<String, String>();
    }

    private static class PortletWithRuntimeData
    extends PagePortletType {
        public long groupId;
        public long company;
        public Layout layout;
        public PageType page;
        private PagePortletType wrappedPortlet;

        private PortletWithRuntimeData() {
        }
    }
}

