/*
 * Decompiled with CFR 0.152.
 */
package com.ableneo.liferay.portal.setup.core;

import com.ableneo.liferay.portal.setup.SetupConfigurationThreadLocal;
import com.ableneo.liferay.portal.setup.core.util.ResolverUtil;
import com.ableneo.liferay.portal.setup.core.util.TranslationMapUtil;
import com.ableneo.liferay.portal.setup.domain.AssociatedAssetType;
import com.ableneo.liferay.portal.setup.domain.Category;
import com.ableneo.liferay.portal.setup.domain.PropertyKeyValueType;
import com.ableneo.liferay.portal.setup.domain.Vocabulary;
import com.liferay.asset.category.property.model.AssetCategoryProperty;
import com.liferay.asset.category.property.service.AssetCategoryPropertyLocalServiceUtil;
import com.liferay.asset.kernel.exception.NoSuchCategoryException;
import com.liferay.asset.kernel.exception.NoSuchVocabularyException;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetVocabularyLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.service.ClassNameLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.asset.util.AssetVocabularySettingsHelper;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SetupCategorization {
    private static final Logger LOG = LoggerFactory.getLogger(SetupCategorization.class);

    private SetupCategorization() {
    }

    public static void setupVocabularies(Iterable<Vocabulary> vocabularies, long groupId) {
        Locale siteDefaultLocale = LocaleUtil.getSiteDefault();
        StringBuilder statusLine = new StringBuilder();
        int index = 0;
        for (Vocabulary vocabulary : vocabularies) {
            LOG.info("Vocabulary setup STARTUP. It may take long time. To see runtime details enable DEBUG logging on {} class.", (Object)SetupCategorization.class.getName());
            SetupCategorization.setupVocabulary(vocabulary, groupId, siteDefaultLocale);
            if (index > 0) {
                statusLine.append(", ");
            }
            statusLine.append(vocabulary.getName());
            ++index;
        }
        if (statusLine.length() != 0) {
            LOG.info("Vocabulary setup DONE. Created/updated following vocabularies: {}", (Object)statusLine);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void setupVocabulary(Vocabulary vocabulary, long groupId, Locale defaultLocale) {
        SetupCategorization.LOG.debug("Setting up vocabulary [{}]", (Object)vocabulary.getName());
        titleMap = TranslationMapUtil.getTranslationMap(vocabulary.getTitleTranslation(), groupId, vocabulary.getName(), "");
        descMap = new HashMap<Locale, String>();
        descMap.put(defaultLocale, vocabulary.getDescription());
        assetVocabulary = null;
        try {
            assetVocabulary = AssetVocabularyLocalServiceUtil.getAssetVocabularyByUuidAndGroupId((String)vocabulary.getUuid(), (long)groupId);
        }
        catch (NoSuchVocabularyException e) {
            SetupCategorization.LOG.warn("Asset vocabulary: [{}] was not found", (Object)vocabulary.getName());
        }
        catch (PortalException e) {
            SetupCategorization.LOG.error("Error while fetching asset vocabulary: [{}]", (Object)vocabulary.getName(), (Object)e);
        }
        if (assetVocabulary == null) {
            try {
                assetVocabulary = AssetVocabularyLocalServiceUtil.getGroupVocabulary((long)groupId, (String)StringUtil.toLowerCase((String)vocabulary.getName().trim()));
            }
            catch (NoSuchVocabularyException e) {
                SetupCategorization.LOG.warn("Asset vocabulary: [{}] was not found", (Object)vocabulary.getName());
            }
            catch (PortalException e) {
                SetupCategorization.LOG.error("Error while fetching asset vocabulary: [{}]", (Object)vocabulary.getName(), (Object)e);
            }
        }
        settings = SetupCategorization.composeVocabularySettings(vocabulary, groupId);
        if (assetVocabulary != null) {
            SetupCategorization.LOG.debug("Vocabulary [{}] already exists. Will be updated.", (Object)assetVocabulary.getName());
            update = false;
            if (!assetVocabulary.getTitleMap().equals(titleMap)) {
                assetVocabulary.setTitleMap(titleMap);
                update = true;
            }
            if (!assetVocabulary.getDescriptionMap().equals(descMap)) {
                assetVocabulary.setDescriptionMap(descMap);
                update = true;
            }
            if (!assetVocabulary.getSettings().equals(settings)) {
                assetVocabulary.setSettings(settings);
                update = true;
            }
            if (!Validator.isBlank((String)vocabulary.getUuid()) && !assetVocabulary.getUuid().equals(vocabulary.getUuid())) {
                assetVocabulary.setUuid(vocabulary.getUuid());
                update = true;
            }
            try {
                if (!update) ** GOTO lbl61
                assetVocabulary = AssetVocabularyLocalServiceUtil.updateAssetVocabulary((AssetVocabulary)assetVocabulary);
                SetupCategorization.LOG.debug("Vocabulary [{}] successfully updated.", (Object)assetVocabulary.getName());
            }
            catch (RuntimeException e) {
                SetupCategorization.LOG.warn("Error while trying to update AssetVocabulary with ID: {}. Skipping.", (Object)assetVocabulary.getVocabularyId(), (Object)e);
                return;
            }
        } else {
            serviceContext = new ServiceContext();
            serviceContext.setCompanyId(SetupConfigurationThreadLocal.getRunInCompanyId().longValue());
            serviceContext.setScopeGroupId(groupId);
            try {
                assetVocabulary = AssetVocabularyLocalServiceUtil.addVocabulary((long)SetupConfigurationThreadLocal.getRunAsUserId(), (long)groupId, (String)vocabulary.getName(), (String)vocabulary.getName(), titleMap, descMap, (String)settings, (ServiceContext)serviceContext);
                if (!Validator.isBlank((String)vocabulary.getUuid())) {
                    assetVocabulary.setUuid(vocabulary.getUuid());
                    AssetVocabularyLocalServiceUtil.updateAssetVocabulary((AssetVocabulary)assetVocabulary);
                }
            }
            catch (PortalException e) {
                SetupCategorization.LOG.error("Error while trying to create vocabulary with title: {}", titleMap, (Object)e);
            }
            SetupCategorization.LOG.debug("AssetVocabulary [{}] successfuly added. ID: {}, group: {}", new Object[]{assetVocabulary.getName(), assetVocabulary.getVocabularyId(), assetVocabulary.getGroupId()});
        }
lbl61:
        // 3 sources

        SetupCategorization.setupCategories(assetVocabulary.getVocabularyId(), groupId, 0L, vocabulary.getCategory(), defaultLocale);
    }

    private static String composeVocabularySettings(Vocabulary vocabulary, long groupId) {
        AssetVocabularySettingsHelper assetVocabularySettingsHelper = new AssetVocabularySettingsHelper();
        assetVocabularySettingsHelper.setMultiValued(vocabulary.isMultiValued());
        List<AssociatedAssetType> types = vocabulary.getAssociatedAssetType();
        if (Objects.isNull(types) || types.isEmpty()) {
            assetVocabularySettingsHelper.setClassNameIdsAndClassTypePKs(new long[]{0L}, new long[]{-1L}, new boolean[]{false});
            return assetVocabularySettingsHelper.toString();
        }
        LinkedList<Long> classNameIds = new LinkedList<Long>();
        LinkedList<Long> classTypePKs = new LinkedList<Long>();
        LinkedList<Boolean> requireds = new LinkedList<Boolean>();
        for (AssociatedAssetType type : types) {
            ClassName className = ClassNameLocalServiceUtil.fetchClassName((String)type.getClassName());
            if (className.getValue().isEmpty()) continue;
            long subtypePK = -1L;
            if (Objects.nonNull(type.getSubtypeStructureKey()) && !type.getSubtypeStructureKey().isEmpty()) {
                try {
                    subtypePK = ResolverUtil.getStructureId(type.getSubtypeStructureKey(), groupId, type.getClassName(), true);
                }
                catch (PortalException e) {
                    LOG.error("Class can not be be resolved for classname: {}", (Object)type.getClassName(), (Object)e);
                    continue;
                }
            }
            classNameIds.add(className.getClassNameId());
            classTypePKs.add(subtypePK);
            requireds.add(type.isRequired());
        }
        if (classNameIds.isEmpty()) {
            assetVocabularySettingsHelper.setClassNameIdsAndClassTypePKs(new long[]{0L}, new long[]{-1L}, new boolean[]{false});
            return assetVocabularySettingsHelper.toString();
        }
        boolean[] requiredsArray = new boolean[requireds.size()];
        for (int i = 0; i < requireds.size(); ++i) {
            requiredsArray[i] = (Boolean)requireds.get(i);
        }
        assetVocabularySettingsHelper.setClassNameIdsAndClassTypePKs(ArrayUtil.toLongArray(classNameIds), ArrayUtil.toLongArray(classTypePKs), requiredsArray);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Vocabulary settings composed for vocabulary: [{}]. Content: {}", (Object)vocabulary.getName(), (Object)assetVocabularySettingsHelper);
        }
        return assetVocabularySettingsHelper.toString();
    }

    private static void setupCategories(long vocabularyId, long groupId, long parentCategoryId, List<Category> categories, Locale defaultLocale) {
        LOG.debug("Setting up categories with parentCategoryId: [{}]", (Object)parentCategoryId);
        if (categories != null && !categories.isEmpty()) {
            for (Category category : categories) {
                SetupCategorization.setupCategory(category, vocabularyId, groupId, defaultLocale, parentCategoryId);
            }
        }
    }

    private static void setupCategory(Category category, long vocabularyId, long groupId, Locale defaultLocale, long parentCategoryId) {
        LOG.debug("Processing category [{}]", (Object)category.getName());
        Map<Locale, String> titleMap = TranslationMapUtil.getTranslationMap(category.getTitleTranslation(), groupId, category.getName(), String.format("Category [%1$s]", category.getName()));
        HashMap<Locale, String> descMap = new HashMap<Locale, String>();
        String description = category.getDescription();
        descMap.put(defaultLocale, description);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(SetupConfigurationThreadLocal.getRunInCompanyId().longValue());
        serviceContext.setScopeGroupId(groupId);
        AssetCategory assetCategory = null;
        if (!Validator.isBlank((String)category.getUuid())) {
            assetCategory = SetupCategorization.fetchAssetCategoryByUuid(category.getUuid(), groupId);
        }
        if (assetCategory == null) {
            assetCategory = SetupCategorization.fetchAssetCategoryByName(titleMap.get(LocaleUtil.getSiteDefault()), parentCategoryId, vocabularyId);
        }
        if (assetCategory != null) {
            LOG.debug("Updating category {}", (Object)assetCategory.getName());
            boolean update = false;
            if (!assetCategory.getTitleMap().equals(titleMap)) {
                assetCategory.setTitleMap(titleMap);
                update = true;
            }
            if (!assetCategory.getDescriptionMap().equals(descMap)) {
                assetCategory.setDescriptionMap(descMap);
                update = true;
            }
            if (!assetCategory.getName().equals(category.getName())) {
                assetCategory.setName(category.getName());
                update = true;
            }
            if (!assetCategory.getUuid().equals(category.getUuid())) {
                assetCategory.setUuid(category.getUuid());
                update = true;
            }
            try {
                if (update) {
                    AssetCategoryLocalServiceUtil.updateAssetCategory((AssetCategory)assetCategory);
                }
                if (!category.getProperty().isEmpty()) {
                    SetupCategorization.updateCategoryProperties(category.getProperty(), assetCategory);
                }
                LOG.debug("Category [{}] successfully updated.", (Object)assetCategory.getName());
            }
            catch (RuntimeException e) {
                LOG.error("Error while trying to update category [{}]", (Object)assetCategory.getName(), (Object)e);
            }
            SetupCategorization.setupCategories(vocabularyId, groupId, assetCategory.getCategoryId(), category.getCategory(), defaultLocale);
            return;
        }
        try {
            LOG.debug("Creating new category [{}]", (Object)category.getName());
            assetCategory = AssetCategoryLocalServiceUtil.addCategory(null, (long)SetupConfigurationThreadLocal.getRunAsUserId(), (long)groupId, (long)parentCategoryId, titleMap, descMap, (long)vocabularyId, null, (ServiceContext)serviceContext);
            if (!Validator.isBlank((String)category.getUuid())) {
                assetCategory.setUuid(category.getUuid());
                assetCategory = AssetCategoryLocalServiceUtil.updateAssetCategory((AssetCategory)assetCategory);
            }
            if (!category.getProperty().isEmpty()) {
                SetupCategorization.updateCategoryProperties(category.getProperty(), assetCategory);
            }
            LOG.debug("Category [{}] successfully added with title: {}", (Object)assetCategory.getName(), (Object)assetCategory.getTitle());
            SetupCategorization.setupCategories(vocabularyId, groupId, assetCategory.getCategoryId(), category.getCategory(), defaultLocale);
        }
        catch (PortalException e) {
            LOG.error("Error in creating category [{}]", (Object)category.getName(), (Object)e);
        }
    }

    private static void updateCategoryProperties(List<PropertyKeyValueType> property, AssetCategory assetCategory) {
        for (PropertyKeyValueType propertyKeyValueType : property) {
            AssetCategoryProperty assetCategoryProperty = null;
            try {
                assetCategoryProperty = AssetCategoryPropertyLocalServiceUtil.getCategoryProperty((long)assetCategory.getCategoryId(), (String)propertyKeyValueType.getKey());
            }
            catch (PortalException e) {
                LOG.debug("Failed to get asset category property for asset category {} with id {} with key {}", new Object[]{assetCategory.getTitleCurrentValue(), assetCategory.getCategoryId(), propertyKeyValueType.getKey(), e});
            }
            if (assetCategoryProperty != null) {
                if (assetCategoryProperty.getValue().equals(propertyKeyValueType.getValue())) continue;
                assetCategoryProperty.setValue(propertyKeyValueType.getValue());
                AssetCategoryPropertyLocalServiceUtil.updateAssetCategoryProperty((AssetCategoryProperty)assetCategoryProperty);
                continue;
            }
            try {
                AssetCategoryPropertyLocalServiceUtil.addCategoryProperty((long)SetupConfigurationThreadLocal.getRunAsUserId(), (long)assetCategory.getCategoryId(), (String)propertyKeyValueType.getKey(), (String)propertyKeyValueType.getValue());
            }
            catch (PortalException e) {
                LOG.error("Failed to add category property {} with value {} to category {} with id {} uuid {}", new Object[]{propertyKeyValueType.getKey(), propertyKeyValueType.getValue(), assetCategory.getTitleCurrentValue(), assetCategory.getCategoryId(), assetCategory.getUuid(), e});
            }
        }
    }

    private static AssetCategory fetchAssetCategoryByName(String categoryName, long parentCategoryId, long vocabularyId) {
        AssetCategory assetCategory = null;
        try {
            List existingCategories = AssetCategoryLocalServiceUtil.getChildCategories((long)parentCategoryId);
            for (AssetCategory ac : existingCategories) {
                if (!ac.getName().equals(categoryName) || ac.getVocabularyId() != vocabularyId) continue;
                assetCategory = ac;
            }
        }
        catch (RuntimeException e) {
            LOG.warn("Error while trying to find category {} in a children list of category with id {}", new Object[]{categoryName, parentCategoryId, e});
        }
        return assetCategory;
    }

    private static AssetCategory fetchAssetCategoryByUuid(String uuid, long groupId) {
        AssetCategory assetCategory = null;
        try {
            assetCategory = AssetCategoryLocalServiceUtil.getAssetCategoryByUuidAndGroupId((String)uuid, (long)groupId);
        }
        catch (NoSuchCategoryException e) {
            LOG.warn("Failed to fetch category with uuid {} from group with groupId {}. It will be updated by name or created as new.", (Object)uuid, (Object)groupId);
        }
        catch (PortalException e) {
            LOG.error("Failed to fetch category with uuid {} from group with groupId {}. Unexpected error occured.", (Object)uuid, (Object)groupId);
            throw new IllegalStateException(e);
        }
        return assetCategory;
    }
}

