/*
 * Decompiled with CFR 0.152.
 */
package com.ableneo.liferay.portal.setup;

import com.ableneo.liferay.portal.setup.domain.ObjectFactory;
import com.ableneo.liferay.portal.setup.domain.Setup;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class MarshallUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MarshallUtil.class);
    private static final SAXParserFactory spf = SAXParserFactory.newInstance();
    private static final Schema schema = MarshallUtil.getSchema();
    private static XMLReader xr = null;
    private static Unmarshaller unmarshaller = MarshallUtil.getUnmarshaller();
    private static boolean skipValidate = false;

    private MarshallUtil() {
    }

    public static Setup unmarshall(File xmlConfigurationFile) throws FileNotFoundException {
        return MarshallUtil.unmarshall(new FileInputStream(xmlConfigurationFile));
    }

    public static Setup unmarshall(InputStream stream) {
        try {
            SAXSource src = new SAXSource(xr, new InputSource(stream));
            return (Setup)unmarshaller.unmarshal((Source)src);
        }
        catch (JAXBException e) {
            LOG.error("Cannot unmarshall the provided stream", (Throwable)e);
            return null;
        }
    }

    private static Unmarshaller getUnmarshaller() {
        ClassLoader cl = ObjectFactory.class.getClassLoader();
        try {
            JAXBContext jc = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName(), (ClassLoader)cl);
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setSchema(schema);
            return unmarshaller;
        }
        catch (Exception e) {
            LOG.error("db-setup-core library is broken in unexpected way. Please fix the library.", (Throwable)e);
            return null;
        }
    }

    public static void toXmlStdOut(Setup setup) {
        MarshallUtil.toXmlStream(setup, System.out);
    }

    public static void toXmlStream(Setup setup, OutputStream os) {
        Marshaller m = MarshallUtil.getMarshaller();
        try {
            if (skipValidate) {
                m.setEventHandler(event -> true);
            }
            m.marshal((Object)setup, os);
        }
        catch (JAXBException e) {
            LOG.error("Could not convert from xml", (Throwable)e);
        }
    }

    public static void skipValidate(boolean skipValidate) {
        MarshallUtil.skipValidate = skipValidate;
    }

    private static Marshaller getMarshaller() {
        ClassLoader cl = ObjectFactory.class.getClassLoader();
        try {
            JAXBContext jc = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName(), (ClassLoader)cl);
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setSchema(schema);
            return marshaller;
        }
        catch (JAXBException e) {
            throw new IllegalStateException("db-setup-core library is broken in unexpected way. Please fix the library.", e);
        }
    }

    public static boolean validateAgainstXSD(InputStream inputStream) {
        Validator validator = schema.newValidator();
        try {
            validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            validator.validate(new StreamSource(inputStream));
        }
        catch (IOException e) {
            throw new IllegalStateException("db-setup-core is broken in unexpected manner. Please fix the library.", e);
        }
        catch (SAXException e) {
            LOG.error("Parsing error", (Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean validateAgainstXSD(File xmlConfigurationFile) {
        try {
            return MarshallUtil.validateAgainstXSD(new FileInputStream(xmlConfigurationFile));
        }
        catch (IOException e) {
            throw new IllegalStateException("db-setup-core is broken in unexpected manner. Please fix the library.", e);
        }
    }

    private static Schema getSchema() {
        Schema schema;
        ClassLoader cl = MarshallUtil.class.getClassLoader();
        InputStream schemaInputStream = cl.getResourceAsStream("setup_definition.xsd");
        if (schemaInputStream == null) {
            throw new IllegalStateException("XSD schema that is used for validation configuration not found");
        }
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            schema = factory.newSchema(new StreamSource(schemaInputStream));
        }
        catch (SAXException e) {
            throw new IllegalStateException("XSD schema that is used for configuration validation cannot be parsed", e);
        }
        return schema;
    }

    static {
        spf.setNamespaceAware(true);
        try {
            spf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            xr = spf.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException | SAXException e) {
            LOG.error("Failed to setup SAX parser.", (Throwable)e);
        }
    }
}

