/*
 * Decompiled with CFR 0.152.
 */
package com.ableneo.liferay.portal.setup.core.util;

import com.ableneo.liferay.portal.setup.SetupConfigurationThreadLocal;
import com.ableneo.liferay.portal.setup.core.SetupPermissions;
import com.ableneo.liferay.portal.setup.core.SetupWebFolders;
import com.ableneo.liferay.portal.setup.domain.ArticleFolder;
import com.ableneo.liferay.portal.setup.domain.RolePermissions;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalFolderLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class WebFolderUtil {
    private static final Log LOG = LogFactoryUtil.getLog(WebFolderUtil.class);

    private WebFolderUtil() {
    }

    public static JournalFolder findWebFolder(long companyId, long groupId, long userId, String name, String description, boolean createIfNotExists, RolePermissions rolePermissions) {
        String[] folderPath = name.split("/");
        JournalFolder foundFolder = null;
        long parentId = 0L;
        boolean hasCreated = false;
        for (int count = 0; count < folderPath.length; ++count) {
            String folder = folderPath[count];
            if (Validator.isBlank((String)folder)) continue;
            foundFolder = WebFolderUtil.findWebFolder(groupId, parentId, folder);
            if (foundFolder == null && createIfNotExists) {
                foundFolder = WebFolderUtil.createWebFolder(userId, companyId, groupId, parentId, folder, description);
                hasCreated = true;
            }
            if (foundFolder == null) break;
            parentId = foundFolder.getFolderId();
        }
        if (hasCreated) {
            WebFolderUtil.updateFolderPermissions(foundFolder, companyId, groupId, SetupWebFolders.getDefaultPermissions(), rolePermissions);
        }
        return foundFolder;
    }

    public static JournalFolder findWebFolder(Long groupId, Long parentFolderId, String name) {
        JournalFolder dir = null;
        try {
            List dirs = JournalFolderLocalServiceUtil.getFolders((long)groupId, (long)parentFolderId);
            for (JournalFolder jf : dirs) {
                if (jf.getName() == null || !jf.getName().equals(name)) continue;
                dir = jf;
                break;
            }
        }
        catch (SystemException e) {
            LOG.error((Throwable)e);
        }
        return dir;
    }

    public static JournalFolder createWebFolder(long userId, long companyId, long groupId, long parentFolderId, String name, String description) {
        JournalFolder folder = null;
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setScopeGroupId(groupId);
            serviceContext.setCompanyId(companyId);
            folder = JournalFolderLocalServiceUtil.addFolder((long)userId, (long)groupId, (long)parentFolderId, (String)name, (String)description, (ServiceContext)serviceContext);
        }
        catch (PortalException e) {
            LOG.error((Throwable)e);
        }
        return folder;
    }

    public static JournalFolder findArticleWebFolder(ArticleFolder af, long groupId) {
        String webFolderPath = af.getFolderPath();
        String description = af.getDescription();
        long companyId = SetupConfigurationThreadLocal.getRunInCompanyId();
        JournalFolder jf = WebFolderUtil.findWebFolder(companyId, groupId, SetupConfigurationThreadLocal.getRunAsUserId(), webFolderPath, description, true, af.getRolePermissions());
        return jf;
    }

    public static void updateFolderPermissions(JournalFolder jf, long companyId, long groupId, Map<String, List<String>> webFolderDefaultPermissions, RolePermissions rolePermissions) {
        try {
            ArrayList<Object> ownAndParentIds = new ArrayList<Object>(jf.getAncestorFolderIds());
            ownAndParentIds.add(jf.getFolderId());
            SetupPermissions.updatePermission(String.format("Folder %1$s", jf.getName()), companyId, ownAndParentIds, JournalFolder.class, rolePermissions, webFolderDefaultPermissions);
            LOG.info((Object)(" Permissions for " + ownAndParentIds + " changed: " + webFolderDefaultPermissions));
        }
        catch (PortalException e) {
            LOG.error((Object)(" Permissions for " + jf.getName() + " could not be changed. "), (Throwable)e);
        }
    }
}

