/*
 * Decompiled with CFR 0.152.
 */
package com.ableneo.liferay.portal.setup.core.util;

import com.ableneo.liferay.portal.setup.domain.TranslationType;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TranslationMapUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TranslationMapUtil.class);

    private TranslationMapUtil() {
    }

    public static Map<Locale, String> getTranslationMap(List<TranslationType> translations, long groupId, String defaultLocaleTitle, String locationHint) {
        HashMap<Locale, String> translationMap = new HashMap<Locale, String>();
        translationMap.put(LocaleUtil.getSiteDefault(), defaultLocaleTitle);
        if (translations != null) {
            for (TranslationType translation : translations) {
                try {
                    Locale locale = Locale.forLanguageTag(translation.getLocale().replace('_', '-'));
                    translationMap.put(locale, translation.getText());
                }
                catch (RuntimeException ex) {
                    LOG.error("Exception while retrieving locale {} for {}", new Object[]{translation.getLocale(), locationHint, ex});
                }
            }
        }
        return translationMap;
    }
}

