/*
 * Decompiled with CFR 0.152.
 */
package com.ableneo.liferay.portal.setup.core.util;

import com.ableneo.liferay.portal.setup.SetupConfigurationThreadLocal;
import com.ableneo.liferay.portal.setup.core.util.ResolverUtil;
import com.ableneo.liferay.portal.setup.domain.Article;
import com.ableneo.liferay.portal.setup.domain.Tag;
import com.liferay.asset.kernel.exception.NoSuchTagException;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetTagLocalServiceUtil;
import com.liferay.journal.model.JournalArticle;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;

public final class TaggingUtil {
    private static final Log LOG = LogFactoryUtil.getLog(TaggingUtil.class);

    private TaggingUtil() {
    }

    public static void associateTagsAndCategories(long groupId, Article article, JournalArticle journalArticle) throws PortalException {
        List<Tag> tags = article.getTag();
        String[] tagNames = null;
        if (tags != null) {
            tagNames = (String[])tags.stream().map(Tag::getName).toArray(String[]::new);
        }
        long[] categoryIds = article.getCategory().stream().map(category -> ResolverUtil.lookupAll(groupId, journalArticle.getCompanyId(), category.getUuid(), article.getPath())).filter(Validator::isNumber).mapToLong(Long::parseLong).toArray();
        AssetEntry entry = AssetEntryLocalServiceUtil.getEntry((String)JournalArticle.class.getName(), (long)journalArticle.getResourcePrimKey());
        AssetEntryLocalServiceUtil.updateEntry((long)SetupConfigurationThreadLocal.getRunAsUserId(), (long)groupId, (String)JournalArticle.class.getName(), (long)entry.getClassPK(), (long[])categoryIds, (String[])tagNames);
    }

    public static void associateTagsWithJournalArticle(List<String> tags, List<String> categories, long userId, long groupId, long primaryKey) {
        try {
            long[] catIds = new long[]{};
            if (categories != null) {
                catIds = TaggingUtil.getCategories(categories, groupId, userId);
            }
            AssetEntryLocalServiceUtil.updateEntry((long)userId, (long)groupId, (String)JournalArticle.class.getName(), (long)primaryKey, (long[])catIds, (String[])tags.toArray(new String[tags.size()]));
        }
        catch (PortalException | SystemException e) {
            LOG.error(e);
        }
    }

    public static long[] getCategories(List<String> categories, long groupId, long runAsUser) {
        long[] assetCategoryIds = new long[categories.size()];
        for (int i = 0; i < categories.size(); ++i) {
            String name = categories.get(i);
            AssetTag assetTag = null;
            try {
                assetTag = AssetTagLocalServiceUtil.getTag((long)groupId, (String)name);
            }
            catch (NoSuchTagException e) {
                try {
                    assetTag = AssetTagLocalServiceUtil.addTag((long)runAsUser, (long)groupId, (String)name, (ServiceContext)new ServiceContext());
                }
                catch (PortalException | SystemException e1) {
                    LOG.error((Object)String.format("Category %1$s not found! ", name), e1);
                }
            }
            catch (PortalException | SystemException e) {
                LOG.error((Object)String.format("Category %1$s not found! ", name), e);
            }
            if (assetTag == null) continue;
            assetCategoryIds[i] = assetTag.getTagId();
        }
        return assetCategoryIds;
    }
}

